/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.general_features;

import com.legacy.blue_skies.world.general_features.AbstractSkyTreeFeature;
import com.legacy.structure_gel.util.Internal;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HugeMushroomBlock;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeature;

public abstract class BaseLargeMushroomFeature
extends AbstractSkyTreeFeature {
    public BaseLargeMushroomFeature(Codec<BaseTreeFeatureConfig> config) {
        super(config, true);
    }

    public abstract boolean place(ISeedReader var1, Random var2, BlockPos var3, Set<BlockPos> var4, MutableBoundingBox var5);

    @Override
    @Internal
    public final boolean place(ISeedReader world, Random rand, BlockPos pos, Set<BlockPos> changedMushrooms, @Deprecated Set<BlockPos> dontUseThis, MutableBoundingBox bounds) {
        if (this.place(world, rand, pos, changedMushrooms, bounds)) {
            changedMushrooms.forEach(blockPos -> {
                for (Direction dir : Direction.values()) {
                    TreeFeature.func_236408_b_((IWorldWriter)world, (BlockPos)blockPos, (BlockState)world.func_180495_p(blockPos).func_196956_a(dir, world.func_180495_p(blockPos.func_177972_a(dir)), (IWorld)world, blockPos, blockPos.func_177972_a(dir)));
                }
            });
            return true;
        }
        return false;
    }

    @Override
    protected boolean setBlockIfOk(@Nullable Set<BlockPos> changedBlocks, ISeedReader world, BlockPos pos, BlockState state, MutableBoundingBox bounds) {
        Block block = state.func_177230_c();
        if (block instanceof HugeMushroomBlock) {
            if (this.isReplaceableByMushroom(world, pos)) {
                this.setBlock(changedBlocks, world, pos, state, bounds);
                return true;
            }
            return false;
        }
        return super.setBlockIfOk(changedBlocks, world, pos, state, bounds);
    }

    @Override
    public boolean isReplaceableByLeaves(ISeedReader world, BlockPos pos) {
        return this.isReplaceableByMushroom(world, pos);
    }

    @Override
    public boolean isReplaceableByLogs(ISeedReader world, BlockPos pos) {
        return this.isReplaceableByMushroom(world, pos);
    }

    public boolean isReplaceableByMushroom(ISeedReader world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return this.isMushroomBlock(state) || this.isMushroomStem(state) || super.isReplaceableByLogs(world, pos) || super.isReplaceableByLeaves(world, pos);
    }

    @Override
    public boolean isLeavesOrLog(BlockState state) {
        return this.isMushroomBlock(state) || this.isMushroomStem(state) || super.isLeavesOrLog(state);
    }

    @Override
    public boolean isValidGround(ISeedReader world, BlockState state, BlockPos pos) {
        return super.isValidGround(world, state, pos) || state.func_235714_a_((ITag)BlockTags.field_242171_aD);
    }

    public boolean isMushroomStem(BlockState state) {
        return state.func_177230_c() instanceof HugeMushroomBlock;
    }

    public boolean isMushroomBlock(BlockState state) {
        return state.func_177230_c() instanceof HugeMushroomBlock;
    }
}

