/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everdawn.gen.features.cave;

import com.legacy.blue_skies.data.providers.SkiesLootProv;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.world.general_features.cave.AbstractCaveSpawnerFeature;
import com.mojang.serialization.Codec;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.StairsBlock;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class EverdawnCaveSpawnerFeature
extends AbstractCaveSpawnerFeature {
    public EverdawnCaveSpawnerFeature(Codec<NoFeatureConfig> codec) {
        super(codec, new Simple(), new SpiderNest(), new Moonstone());
    }

    private static class Moonstone
    extends AbstractCaveSpawnerFeature.SpawnerTemplateData {
        public Moonstone() {
            super(SkiesEntityTypes.INFESTED_SWARMER, "everdawn_moonstone");
        }

        @Override
        @Nullable
        public BlockState modifyState(IServerWorld world, Random rand, BlockPos pos, BlockState originalState) {
            if (originalState.func_177230_c() == SkiesBlocks.lunar_stone && rand.nextFloat() < 0.1f) {
                return SkiesBlocks.lunar_cobblestone.func_176223_P();
            }
            return originalState;
        }

        @Override
        protected ResourceLocation getLoot() {
            return SkiesLootProv.EVERDAWN_CAVE_SPAWNER;
        }
    }

    private static class SpiderNest
    extends AbstractCaveSpawnerFeature.SpawnerTemplateData {
        public SpiderNest() {
            super(SkiesEntityTypes.VENOM_SPIDER, "everdawn_spider_nest");
        }

        @Override
        @Nullable
        public BlockState modifyState(IServerWorld world, Random rand, BlockPos pos, BlockState originalState) {
            if (originalState.func_177230_c() == SkiesBlocks.lunar_mud && rand.nextFloat() < 0.35f) {
                return SkiesBlocks.coarse_lunar_dirt.func_176223_P();
            }
            if (originalState.func_177230_c() == SkiesBlocks.spider_webbing && rand.nextFloat() < 0.4f) {
                return Blocks.field_150350_a.func_176223_P();
            }
            return originalState;
        }

        @Override
        protected ResourceLocation getLoot() {
            return SkiesLootProv.EVERDAWN_CAVE_SPAWNER;
        }
    }

    private static class Simple
    extends AbstractCaveSpawnerFeature.SpawnerTemplateData {
        public Simple() {
            super(SkiesEntityTypes.INFESTED_SWARMER, "everdawn_simple");
        }

        @Override
        @Nullable
        public BlockState modifyState(IServerWorld world, Random rand, BlockPos pos, BlockState originalState) {
            if (originalState.func_177230_c() == SkiesBlocks.lunar_stonebrick && rand.nextFloat() < 0.64f) {
                return SkiesBlocks.cracked_lunar_stonebrick.func_176223_P();
            }
            if (originalState.func_177230_c() == SkiesBlocks.lunar_stonebrick_stairs && rand.nextFloat() < 0.5f) {
                return (BlockState)((BlockState)((BlockState)((BlockState)SkiesBlocks.cracked_lunar_stonebrick_stairs.func_176223_P().func_206870_a((Property)StairsBlock.field_176309_a, originalState.func_177229_b((Property)StairsBlock.field_176309_a))).func_206870_a((Property)StairsBlock.field_176308_b, originalState.func_177229_b((Property)StairsBlock.field_176308_b))).func_206870_a((Property)StairsBlock.field_176310_M, originalState.func_177229_b((Property)StairsBlock.field_176310_M))).func_206870_a((Property)StairsBlock.field_204513_t, originalState.func_177229_b((Property)StairsBlock.field_204513_t));
            }
            return originalState;
        }

        @Override
        protected ResourceLocation getLoot() {
            return SkiesLootProv.EVERDAWN_CAVE_SPAWNER;
        }
    }
}

