/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everdawn.gen.features.cave;

import com.legacy.blue_skies.registries.SkiesFeatures;
import com.legacy.blue_skies.util.GeometryHelper;
import com.legacy.blue_skies.world.general_features.cave.AbstractCaveFeature;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class CaveMagmaFeature
extends AbstractCaveFeature<NoFeatureConfig> {
    public CaveMagmaFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    @Override
    public boolean generate(ISeedReader world, ChunkGenerator chunkGen, Random rand, BlockPos pos, NoFeatureConfig config) {
        pos = new BlockPos(pos.func_177958_n(), 10, pos.func_177952_p());
        int width = rand.nextInt(6) + 5;
        int height = rand.nextInt(7) + 6;
        int depth = rand.nextInt(6) + 5;
        for (int x = -width; x <= width; ++x) {
            for (int z = -depth; z <= depth; ++z) {
                for (int y = -height; y <= height; ++y) {
                    BlockPos offsetPos;
                    if (!GeometryHelper.isInEllipsoid(width, height, depth, x, y, z) || !SkiesFeatures.Carvers.CARVABLE_BLOCKS.contains(world.func_180495_p(offsetPos = pos.func_177982_a(x, y, z)).func_177230_c())) continue;
                    float chance = y <= 1 ? 1.0f : ((float)y <= (float)height / 2.0f ? 0.25f : 0.05f);
                    if (!(rand.nextFloat() < chance)) continue;
                    this.func_230367_a_((IWorldWriter)world, offsetPos, Blocks.field_196814_hQ.func_176223_P());
                }
            }
        }
        return true;
    }

    @Override
    public boolean isValidPos(ISeedReader world, ChunkGenerator chunkGen, Random rand, BlockPos pos, NoFeatureConfig config) {
        return world.func_204610_c(new BlockPos(pos.func_177958_n(), 10, pos.func_177952_p())).func_206884_a((ITag)FluidTags.field_206960_b);
    }
}

