/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everdawn.gen.features;

import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.util.LogicUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;

public class MoonstoneSpikeFeature
extends Feature<Config> {
    protected static final BlockState SPIKE = SkiesBlocks.raw_moonstone.func_176223_P();

    public MoonstoneSpikeFeature(Codec<Config> config) {
        super(config);
    }

    public boolean place(ISeedReader world, ChunkGenerator chunkGen, Random rand, BlockPos pos, Config config) {
        int maxHeight = rand.nextInt(config.maxHeight - config.minHeight + 1) + config.minHeight;
        for (int height = 0; height < 26; ++height) {
            if (world.func_180495_p(pos.func_177981_b(height - 1)).func_177230_c() != SkiesBlocks.crystal_sand || world.func_180495_p(pos.func_177981_b(height)).func_177230_c() != Blocks.field_150350_a) continue;
            for (int y = height; y <= maxHeight + height; ++y) {
                this.setBlock((IWorld)world, pos.func_177981_b(y));
            }
            int radius = rand.nextInt(config.maxRadius - config.minRadius + 1) + config.minRadius;
            double slope = (double)maxHeight / ((double)radius + 1.0);
            for (int i = 1; i <= radius; ++i) {
                for (int x = -i; x <= i; ++x) {
                    for (int z = -i; z <= i; ++z) {
                        if (Math.abs(x) + Math.abs(z) != i) continue;
                        for (int y = height; y <= Math.max(1, maxHeight + height - LogicUtil.plusOrMinus((int)(slope * (double)i), 2, rand)); ++y) {
                            this.setBlock((IWorld)world, pos.func_177982_a(x, y, z));
                        }
                    }
                }
            }
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    if (Math.abs(x) + Math.abs(z) > radius + 1) continue;
                    for (int y = -2; y <= 0; ++y) {
                        this.setBlock((IWorld)world, pos.func_177982_a(x, height + y, z));
                    }
                }
            }
            return true;
        }
        return false;
    }

    private void setBlock(IWorld world, BlockPos pos) {
        world.func_180501_a(pos, SPIKE, 2);
    }

    public static class Config
    implements IFeatureConfig {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("min_height").forGetter(config -> config.minHeight), (App)Codec.INT.fieldOf("max_height").forGetter(config -> config.maxHeight), (App)Codec.INT.fieldOf("min_radius").forGetter(config -> config.minRadius), (App)Codec.INT.fieldOf("max_radius").forGetter(config -> config.maxRadius)).apply((Applicative)instance, Config::new));
        public final int minHeight;
        public final int maxHeight;
        public final int minRadius;
        public final int maxRadius;

        public Config(int minHeight, int maxHeight, int minRadius, int maxRadius) {
            this.minHeight = Math.max(0, minHeight);
            this.maxHeight = Math.max(minHeight, maxHeight);
            this.minRadius = Math.max(0, minRadius);
            this.maxRadius = Math.max(minRadius, maxRadius);
        }
    }
}

