/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everdawn.gen.features;

import com.legacy.blue_skies.blocks.natural.FruitLeavesBlock;
import com.legacy.blue_skies.blocks.natural.SkyLeavesBlock;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.util.DirectionUtil;
import com.legacy.blue_skies.world.general_features.AbstractSkyTreeFeature;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.BushBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;

public class CrescentFruitTreeFeature
extends AbstractSkyTreeFeature {
    private static final BlockState LOG = SkiesBlocks.dusk_log.func_176223_P();
    private static final BlockState LEAF = (BlockState)SkiesBlocks.crescent_fruit_leaves.func_176223_P().func_206870_a((Property)SkyLeavesBlock.field_208495_b, (Comparable)Boolean.valueOf(false));

    public CrescentFruitTreeFeature(Codec<BaseTreeFeatureConfig> config) {
        super(config, true);
    }

    @Override
    public boolean place(ISeedReader world, Random rand, BlockPos pos, Set<BlockPos> changedLogs, Set<BlockPos> changedLeaves, MutableBoundingBox bounds) {
        int height = rand.nextInt(3) + ((double)rand.nextFloat() < 0.2 ? 9 : 6);
        if (!this.isAreaOk(world, pos, height, 1, 3, 5)) {
            return false;
        }
        this.setLeaves(changedLeaves, world, rand, pos, bounds, height);
        for (int yOffset = 0; yOffset < height; ++yOffset) {
            this.setBlockIfOk(changedLogs, world, pos.func_177981_b(yOffset), LOG, bounds);
        }
        this.setSideLogs(changedLogs, world, rand, pos, bounds);
        return true;
    }

    protected void setLeaves(Set<BlockPos> changedLeaves, ISeedReader world, Random rand, BlockPos pos, MutableBoundingBox bounds, int height) {
        pos = new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1 + height, pos.func_177952_p());
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                for (int y = -3; y <= -1; ++y) {
                    if (Math.abs(x) == 2 && Math.abs(z) == 2) continue;
                    if (y == -3 && rand.nextInt(3) == 0) {
                        this.setLeaf(changedLeaves, world, rand, pos.func_177982_a(x, y, z), bounds);
                    }
                    if (y < -2) continue;
                    this.setLeaf(changedLeaves, world, rand, pos.func_177982_a(x, y, z), bounds);
                }
            }
        }
        for (int y = 0; y <= 1; ++y) {
            if (y == 0) {
                this.setLeaf(changedLeaves, world, rand, pos.func_177982_a(1, y, 1), bounds);
                this.setLeaf(changedLeaves, world, rand, pos.func_177982_a(1, y, -1), bounds);
                this.setLeaf(changedLeaves, world, rand, pos.func_177982_a(-1, y, 1), bounds);
                this.setLeaf(changedLeaves, world, rand, pos.func_177982_a(-1, y, -1), bounds);
            }
            this.setLeaf(changedLeaves, world, rand, pos.func_177982_a(1, y, 0), bounds);
            this.setLeaf(changedLeaves, world, rand, pos.func_177982_a(0, y, 1), bounds);
            this.setLeaf(changedLeaves, world, rand, pos.func_177982_a(0, y, 0), bounds);
            this.setLeaf(changedLeaves, world, rand, pos.func_177982_a(0, y, -1), bounds);
            this.setLeaf(changedLeaves, world, rand, pos.func_177982_a(-1, y, 0), bounds);
        }
        this.setLeaf(changedLeaves, world, rand, pos.func_177982_a(2, 0, 0), bounds);
        this.setLeaf(changedLeaves, world, rand, pos.func_177982_a(-2, 0, 0), bounds);
        this.setLeaf(changedLeaves, world, rand, pos.func_177982_a(0, 0, 2), bounds);
        this.setLeaf(changedLeaves, world, rand, pos.func_177982_a(0, 0, -2), bounds);
    }

    protected void setSideLogs(Set<BlockPos> changedLogs, ISeedReader world, Random rand, BlockPos pos, MutableBoundingBox bounds) {
        pos = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        for (Direction dir : DirectionUtil.HORIZONTAL) {
            BlockState state = world.func_180495_p(pos.func_177972_a(dir).func_177977_b());
            if (!state.func_185904_a().func_76222_j() && !(state.func_177230_c() instanceof BushBlock)) continue;
            this.setBlockIfOk(changedLogs, world, pos.func_177972_a(dir).func_177977_b(), LOG, bounds);
        }
        this.setBlockIfOk(changedLogs, world, pos.func_177982_a(rand.nextInt(3) - 1, 0, 0), LOG, bounds);
        this.setBlockIfOk(changedLogs, world, pos.func_177982_a(0, 0, rand.nextInt(3) - 1), LOG, bounds);
    }

    protected void setLeaf(Set<BlockPos> changedLeaves, ISeedReader world, Random rand, BlockPos pos, MutableBoundingBox bounds) {
        this.setBlockIfOk(changedLeaves, world, pos, (double)rand.nextFloat() > 0.33 ? (BlockState)LEAF.func_206870_a((Property)FruitLeavesBlock.MATURE, (Comparable)Boolean.valueOf(false)) : (BlockState)LEAF.func_206870_a((Property)FruitLeavesBlock.MATURE, (Comparable)Boolean.valueOf(true)), bounds);
    }
}

