/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everdawn.biome.provider.layer;

import com.legacy.blue_skies.world.everdawn.biome.provider.layer.DawnRiverLayer;
import com.legacy.blue_skies.world.everdawn.biome.provider.layer.EverdawnBiomeLayer;
import com.legacy.blue_skies.world.everdawn.biome.provider.layer.MixDawnRiverLayer;
import com.legacy.blue_skies.world.general_layers.BiomeMutationLayer;
import com.legacy.blue_skies.world.general_layers.BiomeMutationNoiseLayer;
import java.util.function.LongFunction;
import net.minecraft.world.gen.IExtendedNoiseRandom;
import net.minecraft.world.gen.LazyAreaLayerContext;
import net.minecraft.world.gen.area.IArea;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraft.world.gen.layer.IslandLayer;
import net.minecraft.world.gen.layer.Layer;
import net.minecraft.world.gen.layer.SmoothLayer;
import net.minecraft.world.gen.layer.StartRiverLayer;
import net.minecraft.world.gen.layer.ZoomLayer;
import net.minecraft.world.gen.layer.traits.IAreaTransformer1;

public class EverdawnLayer {
    public static <T extends IArea, C extends IExtendedNoiseRandom<T>> IAreaFactory<T> repeat(long seed, IAreaTransformer1 parent, IAreaFactory<T> layer, int count, LongFunction<C> contextFactory) {
        IAreaFactory iareafactory = layer;
        for (int i = 0; i < count; ++i) {
            iareafactory = parent.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(seed + (long)i), iareafactory);
        }
        return iareafactory;
    }

    private static <T extends IArea, C extends IExtendedNoiseRandom<T>> IAreaFactory<T> setupLayers(int biomeSize, int riverSize, LongFunction<C> contextFactory) {
        IAreaFactory<T> baseLayer = IslandLayer.INSTANCE.func_202823_a((IExtendedNoiseRandom)contextFactory.apply(1L));
        baseLayer = ZoomLayer.FUZZY.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(2000L), (IAreaFactory)baseLayer);
        baseLayer = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(2001L), (IAreaFactory)baseLayer);
        baseLayer = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(2002L), (IAreaFactory)baseLayer);
        baseLayer = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(2003L), (IAreaFactory)baseLayer);
        baseLayer = EverdawnLayer.repeat(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, baseLayer, 0, contextFactory);
        IAreaFactory baseZoom1 = EverdawnLayer.repeat(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, baseLayer, 0, contextFactory);
        baseZoom1 = StartRiverLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(100L), baseZoom1);
        IAreaFactory everdawnBiomeLayer = new EverdawnBiomeLayer().func_202713_a((IExtendedNoiseRandom)contextFactory.apply(200L), baseLayer);
        baseZoom1 = EverdawnLayer.repeat(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, baseZoom1, 2, contextFactory);
        baseZoom1 = EverdawnLayer.repeat(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, baseZoom1, riverSize, contextFactory);
        baseZoom1 = DawnRiverLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1L), baseZoom1);
        baseZoom1 = SmoothLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1000L), baseZoom1);
        for (int k = 0; k < biomeSize; ++k) {
            everdawnBiomeLayer = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1000 + k), everdawnBiomeLayer);
        }
        everdawnBiomeLayer = SmoothLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1000L), everdawnBiomeLayer);
        everdawnBiomeLayer = MixDawnRiverLayer.INSTANCE.func_202707_a((IExtendedNoiseRandom)contextFactory.apply(100L), everdawnBiomeLayer, baseZoom1);
        IAreaFactory mutationLayer = BiomeMutationNoiseLayer.INSTANCE.func_202823_a((IExtendedNoiseRandom)contextFactory.apply(2L));
        everdawnBiomeLayer = BiomeMutationLayer.LARGE.func_202707_a((IExtendedNoiseRandom)contextFactory.apply(100L), everdawnBiomeLayer, EverdawnLayer.repeat(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, mutationLayer, 2, contextFactory));
        everdawnBiomeLayer = BiomeMutationLayer.SMALL.func_202707_a((IExtendedNoiseRandom)contextFactory.apply(100L), everdawnBiomeLayer, mutationLayer);
        return everdawnBiomeLayer;
    }

    public static Layer build(long seed, int biomeSize, int riverSize) {
        IAreaFactory layerFactory = EverdawnLayer.setupLayers(biomeSize, riverSize, seedModifier -> new LazyAreaLayerContext(25, seed, seedModifier));
        return new Layer(layerFactory);
    }
}

