/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everbright.gen.structures.nature_dungeon;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.legacy.blue_skies.registries.SkiesDimensions;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.world.everbright.gen.structures.nature_dungeon.NatureDungeonPieces;
import com.legacy.structure_gel.worldgen.structure.GelStructure;
import com.legacy.structure_gel.worldgen.structure.GelStructureStart;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class NatureDungeonStructure
extends GelStructure<NoFeatureConfig> {
    private static final List<MobSpawnInfo.Spawners> DUNGEON_ENEMIES = Lists.newArrayList((Object[])new MobSpawnInfo.Spawners[]{new MobSpawnInfo.Spawners(SkiesEntityTypes.STONELET, 2, 1, 1), new MobSpawnInfo.Spawners(SkiesEntityTypes.SPEWTER, 2, 1, 1)});

    public NatureDungeonStructure(Codec<NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
        this.setSpawnList(EntityClassification.MONSTER, DUNGEON_ENEMIES);
    }

    protected boolean isFeatureChunk(ChunkGenerator chunkGen, BiomeProvider biomeProvider, long seed, SharedSeedRandom sharedSeedRand, int chunkPosX, int chunkPosZ, Biome biomeIn, ChunkPos chunkPos, NoFeatureConfig config) {
        return super.func_230363_a_(chunkGen, biomeProvider, seed, sharedSeedRand, chunkPosX, chunkPosZ, biomeIn, chunkPos, (IFeatureConfig)config) && !this.isNearSpawn(chunkPosX, chunkPosZ, 15);
    }

    private boolean isNearSpawn(int chunkPosX, int chunkPosZ, int range) {
        return chunkPosX > -range && chunkPosX < range && chunkPosZ > -range && chunkPosZ < range;
    }

    public double getProbability() {
        return 1.0;
    }

    public int getSpacing() {
        return 30;
    }

    public int getOffset() {
        return this.getSpacing() / 4;
    }

    public Set<ResourceLocation> getValidDimensions() {
        return ImmutableSet.of((Object)SkiesDimensions.EVERBRIGHT_ID);
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public static int getYValue(ChunkGenerator chunkGen, int chunkX, int chunkZ) {
        return chunkGen.func_222531_c(chunkX * 16, chunkZ * 16, Heightmap.Type.WORLD_SURFACE_WG);
    }

    public static class Start
    extends GelStructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox boundsIn, int referenceIn, long seed) {
            super(structureIn, chunkX, chunkZ, boundsIn, referenceIn, seed);
        }

        public void generatePieces(DynamicRegistries registry, ChunkGenerator generator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn, NoFeatureConfig config) {
            NatureDungeonPieces.assemble(templateManagerIn, new BlockPos(chunkX * 16 + 8, 88, chunkZ * 16 + 8), Rotation.func_222466_a((Random)this.field_214631_d), this.field_75075_a, (Random)this.field_214631_d, generator);
            this.func_202500_a();
        }
    }
}

