/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everbright.gen.features;

import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.world.general_features.AbstractSkyTreeFeature;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;

public class BluebrightTreeFeature
extends AbstractSkyTreeFeature {
    private static final BlockState LOG = SkiesBlocks.bluebright_log.func_176223_P();
    private static final BlockState LEAF = SkiesBlocks.bluebright_leaves.func_176223_P();
    private int minTreeHeight;

    public BluebrightTreeFeature(Codec<BaseTreeFeatureConfig> config, int minTreeHeight) {
        super(config, true);
        this.minTreeHeight = minTreeHeight;
    }

    @Override
    public boolean place(ISeedReader world, Random rand, BlockPos pos, Set<BlockPos> changedLogs, Set<BlockPos> changedLeaves, MutableBoundingBox bounds) {
        int i;
        int height = rand.nextInt(3) + this.minTreeHeight;
        if (!this.isAreaOk(world, pos, height, 1, 3, 7)) {
            return false;
        }
        for (int y = 0; y < height; ++y) {
            this.setBlockIfOk(changedLogs, world, pos.func_177981_b(y), LOG, bounds);
        }
        this.setLeafBall(changedLeaves, world, rand, pos.func_177982_a(0, height - 2, 0), bounds);
        int iPosX = height - 4 - rand.nextInt(3);
        int iNegX = height - 4 - rand.nextInt(3);
        int iPosZ = height - 4 - rand.nextInt(3);
        int iNegZ = height - 4 - rand.nextInt(3);
        for (i = 1; i <= 3; ++i) {
            this.setBlockIfOk(changedLogs, world, pos.func_177982_a(i, iPosX + i, 0), (BlockState)LOG.func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.X), bounds);
            this.setBlockIfOk(changedLogs, world, pos.func_177982_a(0, iPosZ + i, i), (BlockState)LOG.func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Z), bounds);
            if (i != 3) continue;
            this.setLeafBall(changedLeaves, world, rand, pos.func_177982_a(i, iPosX + 2, 0), bounds);
            this.setLeafBall(changedLeaves, world, rand, pos.func_177982_a(0, iPosZ + 2, i), bounds);
        }
        for (i = -1; i >= -3; --i) {
            this.setBlockIfOk(changedLogs, world, pos.func_177982_a(i, iNegX - i, 0), (BlockState)LOG.func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.X), bounds);
            this.setBlockIfOk(changedLogs, world, pos.func_177982_a(0, iNegZ - i, i), (BlockState)LOG.func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Z), bounds);
            if (i != -3) continue;
            this.setLeafBall(changedLeaves, world, rand, pos.func_177982_a(i, iNegX + 2, 0), bounds);
            this.setLeafBall(changedLeaves, world, rand, pos.func_177982_a(0, iNegZ + 2, i), bounds);
        }
        return true;
    }

    protected void setLeafBall(Set<BlockPos> changedLeaves, ISeedReader world, Random rand, BlockPos pos, MutableBoundingBox bounds) {
        for (int y = 0; y <= 2; ++y) {
            this.setBlockIfOk(changedLeaves, world, pos.func_177982_a(0, y, 0), LEAF, bounds);
            for (int i = -1; i <= 1; i += 2) {
                this.setBlockIfOk(changedLeaves, world, pos.func_177982_a(i, y, 0), LEAF, bounds);
                this.setBlockIfOk(changedLeaves, world, pos.func_177982_a(0, y, i), LEAF, bounds);
            }
        }
        for (int i = -1; i <= 1; i += 2) {
            this.setBlockIfOk(changedLeaves, world, pos.func_177982_a(i, 1, i), LEAF, bounds);
            this.setBlockIfOk(changedLeaves, world, pos.func_177982_a(i, 1, -i), LEAF, bounds);
        }
        this.setBlockIfOk(changedLeaves, world, pos.func_177982_a(0, -1, 0), LEAF, bounds);
        this.setBlockIfOk(changedLeaves, world, pos.func_177982_a(0, 3, 0), LEAF, bounds);
    }
}

