/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.util;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.structure_gel.util.RegistryHelper;
import java.util.Optional;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;

public class BiomeUtil {
    public static RegistryKey<Biome> getKeyFromBiome(IWorld world, Biome biomeIn) {
        Optional biome = RegistryHelper.getKey((IWorld)world, (RegistryKey)Registry.field_239720_u_, (Object)biomeIn);
        if (biome.isPresent()) {
            return (RegistryKey)biome.get();
        }
        BlueSkies.LOGGER.error("Failed to get the registry key from " + biomeIn + ". This is not good!");
        return null;
    }

    public static Biome getBiomeFromId(int id) {
        return (Biome)WorldGenRegistries.field_243657_i.func_148745_a(id);
    }

    public static int getBiomeId(Biome biome) {
        return WorldGenRegistries.field_243657_i.func_148757_b((Object)biome);
    }

    public static int getBiomeId(RegistryKey<Biome> biomeKey) {
        Biome biome = (Biome)WorldGenRegistries.field_243657_i.func_230516_a_(biomeKey);
        if (biome != null) {
            return WorldGenRegistries.field_243657_i.func_148757_b((Object)biome);
        }
        BlueSkies.LOGGER.error("Could not find a biome with the key: ", (Object)biomeKey.getRegistryName().toString());
        return 0;
    }

    public static RegistryKey<Biome> getKeyFromBiomeId(IWorld world, int biomeId) {
        return BiomeUtil.getKeyFromBiome(world, BiomeUtil.getBiomeFromId(biomeId));
    }
}

