/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.registries;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.data.providers.SkiesLootProv;
import com.legacy.blue_skies.entities.villager.SkiesVillagerTrades;
import com.legacy.blue_skies.registries.SkiesBiomes;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.registries.SkiesPointsOfInterest;
import com.legacy.blue_skies.registries.SkiesRegistry;
import com.legacy.blue_skies.registries.SkiesSounds;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.ai.brain.task.GiveHeroGiftsTask;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.villager.VillagerType;
import net.minecraft.item.Item;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.registry.Registry;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class SkiesVillagers {
    public static final VillagerProfession STARGAZER = SkiesVillagers.createProfession("stargazer", SkiesPointsOfInterest.STAR_EMITTER, (ImmutableSet<Item>)ImmutableSet.of(), (ImmutableSet<Block>)ImmutableSet.of(), SkiesSounds.ENTITY_VILLAGER_WORK_STARGAZER);
    public static final VillagerProfession WRANGLER = SkiesVillagers.createProfession("wrangler", SkiesPointsOfInterest.TROUGH, (ImmutableSet<Item>)ImmutableSet.of(), (ImmutableSet<Block>)ImmutableSet.of(), SkiesSounds.ENTITY_VILLAGER_WORK_WRANGLER);
    public static final VillagerProfession SHOVELER = SkiesVillagers.createProfession("shoveler", SkiesPointsOfInterest.TOOL_BOX, (ImmutableSet<Item>)ImmutableSet.of(), (ImmutableSet<Block>)ImmutableSet.of((Object)SkiesBlocks.coarse_turquoise_dirt, (Object)Blocks.field_150433_aE), SkiesSounds.ENTITY_VILLAGER_WORK_SHOVELER);
    public static final VillagerProfession NIGHTWATCHER = SkiesVillagers.createProfession("nightwatcher", SkiesPointsOfInterest.BAG_OF_SPOILS, (ImmutableSet<Item>)ImmutableSet.of(), (ImmutableSet<Block>)ImmutableSet.of(), SkiesSounds.ENTITY_VILLAGER_WORK_NIGHTWATCHER);
    public static final VillagerProfession SUMMONER = SkiesVillagers.createProfession("summoner", SkiesPointsOfInterest.SUMMONING_TABLE, (ImmutableSet<Item>)ImmutableSet.of(), (ImmutableSet<Block>)ImmutableSet.of(), SkiesSounds.ENTITY_VILLAGER_WORK_SUMMONER);
    public static final VillagerProfession ALCHEMIST = SkiesVillagers.createProfession("alchemist", SkiesPointsOfInterest.ALCHEMY_TABLE, (ImmutableSet<Item>)ImmutableSet.of(), (ImmutableSet<Block>)ImmutableSet.of(), SkiesSounds.ENTITY_VILLAGER_WORK_ALCHEMIST);
    public static final Set<VillagerType> SKIES_TYPES = Sets.newHashSet();
    public static VillagerType CALMING_SKIES;
    public static VillagerType BRIGHTLANDS;
    public static VillagerType SLUSHLANDS;
    public static VillagerType UNORTHODOX_VALLEY;
    public static VillagerType SHADED_WOODLANDS;
    public static VillagerType CRYSTAL_DUNES;
    public static VillagerType SUNSET_MAPLE_FOREST;

    public static void init(RegistryEvent.Register<VillagerProfession> event) {
        SkiesRegistry.register(event.getRegistry(), "stargazer", STARGAZER);
        SkiesRegistry.register(event.getRegistry(), "wrangler", WRANGLER);
        SkiesRegistry.register(event.getRegistry(), "shoveler", SHOVELER);
        SkiesRegistry.register(event.getRegistry(), "nightwatcher", NIGHTWATCHER);
        SkiesRegistry.register(event.getRegistry(), "summoner", SUMMONER);
        SkiesRegistry.register(event.getRegistry(), "alchemist", ALCHEMIST);
        SkiesVillagers.registerTrades(STARGAZER, SkiesVillagerTrades.STARGAZER_OFFERS);
        SkiesVillagers.registerTrades(WRANGLER, SkiesVillagerTrades.WRANGLER_OFFERS);
        SkiesVillagers.registerTrades(SHOVELER, SkiesVillagerTrades.SHOVELER_OFFERS);
        SkiesVillagers.registerTrades(NIGHTWATCHER, SkiesVillagerTrades.NIGHTWATCHER_OFFERS);
        SkiesVillagers.registerTrades(SUMMONER, SkiesVillagerTrades.SUMMONER_OFFERS);
        SkiesVillagers.registerTrades(ALCHEMIST, SkiesVillagerTrades.ALCHEMIST_OFFERS);
        SkiesVillagers.registerGifts(STARGAZER, SkiesLootProv.STARGAZER_GIFTS);
        SkiesVillagers.registerGifts(WRANGLER, SkiesLootProv.WRANGLER_GIFTS);
        SkiesVillagers.registerGifts(SHOVELER, SkiesLootProv.SHOVELER_GIFTS);
        SkiesVillagers.registerGifts(SUMMONER, SkiesLootProv.SUMMONER_GIFTS);
        SkiesVillagers.registerGifts(ALCHEMIST, SkiesLootProv.ALCHEMIST_GIFTS);
        SkiesVillagers.initFoodItem(SkiesItems.solnut, 1);
        SkiesVillagers.initFoodItem(SkiesItems.cryo_root, 1);
        SkiesVillagers.initItemPickup(SkiesItems.winter_leaf_seeds);
        SkiesVillagers.initFoodItem(SkiesItems.winter_leaves, 2);
        SkiesVillagers.initItemPickup(SkiesItems.pine_fruit_seeds);
        SkiesVillagers.initFoodItem(SkiesItems.pine_fruit, 2);
        SkiesVillagers.initItemPickup(SkiesItems.fiery_bean_seeds);
        SkiesVillagers.initFoodItem(SkiesItems.fiery_beans, 1);
        SkiesVillagers.initItemPickup(SkiesItems.scalefruit_seeds);
        SkiesVillagers.initFoodItem(SkiesItems.scalefruit, 2);
    }

    public static void initVillagerTypes() {
        BlueSkies.LOGGER.debug("Registering villager types: " + VillagerTrades.field_221239_a.size());
        CALMING_SKIES = SkiesVillagers.registerType("calming_skies");
        BRIGHTLANDS = SkiesVillagers.registerType("brightlands");
        SLUSHLANDS = SkiesVillagers.registerType("slushlands");
        UNORTHODOX_VALLEY = SkiesVillagers.registerType("unorthodox_valley");
        SHADED_WOODLANDS = SkiesVillagers.registerType("shaded_woodlands");
        CRYSTAL_DUNES = SkiesVillagers.registerType("crystal_dunes");
        SUNSET_MAPLE_FOREST = SkiesVillagers.registerType("sunset_maple_forest");
        SkiesVillagers.putTypeToBiome((RegistryKey<Biome>)SkiesBiomes.CALMING_SKIES.getKey(), CALMING_SKIES);
        SkiesVillagers.putTypeToBiome((RegistryKey<Biome>)SkiesBiomes.BRIGHTLANDS.getKey(), BRIGHTLANDS);
        SkiesVillagers.putTypeToBiome((RegistryKey<Biome>)SkiesBiomes.SNOW_COVERED_PINES.getKey(), BRIGHTLANDS);
        SkiesVillagers.putTypeToBiome((RegistryKey<Biome>)SkiesBiomes.FROSTBITTEN_FOREST.getKey(), BRIGHTLANDS);
        SkiesVillagers.putTypeToBiome((RegistryKey<Biome>)SkiesBiomes.MIDDAY_SHORE.getKey(), CALMING_SKIES);
        SkiesVillagers.putTypeToBiome((RegistryKey<Biome>)SkiesBiomes.PEEKING_OCEAN.getKey(), CALMING_SKIES);
        SkiesVillagers.putTypeToBiome((RegistryKey<Biome>)SkiesBiomes.SLUSHLANDS.getKey(), SLUSHLANDS);
        SkiesVillagers.putTypeToBiome((RegistryKey<Biome>)SkiesBiomes.POLAR_HIGHLAND.getKey(), CALMING_SKIES);
        SkiesVillagers.putTypeToBiome((RegistryKey<Biome>)SkiesBiomes.BRISK_MEADOW.getKey(), CALMING_SKIES);
        SkiesVillagers.putTypeToBiome((RegistryKey<Biome>)SkiesBiomes.DEEP_PEEKING_OCEAN.getKey(), CALMING_SKIES);
        SkiesVillagers.putTypeToBiome((RegistryKey<Biome>)SkiesBiomes.UNORTHODOX_VALLEY.getKey(), UNORTHODOX_VALLEY);
        SkiesVillagers.putTypeToBiome((RegistryKey<Biome>)SkiesBiomes.SHADED_WOODLANDS.getKey(), SHADED_WOODLANDS);
        SkiesVillagers.putTypeToBiome((RegistryKey<Biome>)SkiesBiomes.CRYSTAL_DUNES.getKey(), CRYSTAL_DUNES);
        SkiesVillagers.putTypeToBiome((RegistryKey<Biome>)SkiesBiomes.SUNSET_MAPLE_FOREST.getKey(), SUNSET_MAPLE_FOREST);
        SkiesVillagers.putTypeToBiome((RegistryKey<Biome>)SkiesBiomes.MOONLIT_RESERVOIR.getKey(), SHADED_WOODLANDS);
        SkiesVillagers.putTypeToBiome((RegistryKey<Biome>)SkiesBiomes.RISING_CREEK.getKey(), UNORTHODOX_VALLEY);
        SkiesVillagers.putTypeToBiome((RegistryKey<Biome>)SkiesBiomes.CRYSTAL_ROUGHS.getKey(), CRYSTAL_DUNES);
        SkiesVillagers.putTypeToBiome((RegistryKey<Biome>)SkiesBiomes.SEARING_GRASSLAND.getKey(), SUNSET_MAPLE_FOREST);
        SkiesVillagers.putTypeToBiome((RegistryKey<Biome>)SkiesBiomes.CRESCENT_ORCHARD.getKey(), UNORTHODOX_VALLEY);
    }

    public static void putTypeToBiome(RegistryKey<Biome> biomeIn, VillagerType villagerTypeIn) {
        Map biomeMap = (Map)ObfuscationReflectionHelper.getPrivateValue(VillagerType.class, (Object)villagerTypeIn, (String)"field_221180_h");
        biomeMap.put(biomeIn, villagerTypeIn);
    }

    public static void registerTrades(VillagerProfession prof, Int2ObjectMap<VillagerTrades.ITrade[]> tradeMap) {
        VillagerTrades.field_221239_a.put(prof, tradeMap);
    }

    public static void registerGifts(VillagerProfession prof, ResourceLocation giftTable) {
        GiveHeroGiftsTask.field_220403_a.put(prof, giftTable);
    }

    public static VillagerType registerType(String key) {
        VillagerType type = (VillagerType)Registry.func_218322_a((Registry)Registry.field_218369_K, (ResourceLocation)BlueSkies.locate(key), (Object)new VillagerType(key));
        SKIES_TYPES.add(type);
        return type;
    }

    public static VillagerProfession createProfession(String nameIn, PointOfInterestType pointOfInterestIn, ImmutableSet<Item> specificItemsIn, ImmutableSet<Block> relatedWorldBlocksIn, SoundEvent soundIn) {
        try {
            Constructor constructor = VillagerProfession.class.getDeclaredConstructor(String.class, PointOfInterestType.class, ImmutableSet.class, ImmutableSet.class, SoundEvent.class);
            constructor.setAccessible(true);
            return (VillagerProfession)constructor.newInstance(nameIn, pointOfInterestIn, specificItemsIn, relatedWorldBlocksIn, soundIn);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static void initItemPickup(Item item) {
        VillagerEntity.field_213776_bD = Sets.newHashSet((Iterable)VillagerEntity.field_213776_bD);
        VillagerEntity.field_213776_bD.add(item);
    }

    static void initFoodItem(Item item, int efficiency) {
        VillagerEntity.field_213788_bA = Maps.newHashMap((Map)VillagerEntity.field_213788_bA);
        VillagerEntity.field_213788_bA.put(item, efficiency);
        SkiesVillagers.initItemPickup(item);
    }
}

