/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.registries;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.blocks.util.MapColors;
import com.legacy.blue_skies.registries.SkiesBiomeDict;
import com.legacy.blue_skies.registries.SkiesBiomes;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesConfiguredCarvers;
import com.legacy.blue_skies.registries.SkiesConfiguredFeatures;
import com.legacy.blue_skies.registries.SkiesContainers;
import com.legacy.blue_skies.registries.SkiesEffects;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesFeatures;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.registries.SkiesLootFunctions;
import com.legacy.blue_skies.registries.SkiesParticles;
import com.legacy.blue_skies.registries.SkiesPointsOfInterest;
import com.legacy.blue_skies.registries.SkiesRecipes;
import com.legacy.blue_skies.registries.SkiesSchedules;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.registries.SkiesStructures;
import com.legacy.blue_skies.registries.SkiesTileEntityTypes;
import com.legacy.blue_skies.registries.SkiesVillagers;
import com.legacy.structure_gel.biome_dictionary.BiomeType;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.brain.schedule.Schedule;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SkiesRegistry {
    @SubscribeEvent
    public static void registerContainers(RegistryEvent.Register<ContainerType<?>> event) {
        SkiesContainers.init(event);
    }

    @SubscribeEvent
    public static void registerParticles(RegistryEvent.Register<ParticleType<?>> event) {
        SkiesParticles.init(event);
    }

    @SubscribeEvent
    public static void registerParticleFactories(ParticleFactoryRegisterEvent event) {
        SkiesParticles.registerFactories(event);
    }

    @SubscribeEvent
    public static void registerEffects(RegistryEvent.Register<Effect> event) {
        SkiesEffects.init(event);
    }

    @SubscribeEvent
    public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        SkiesSounds.init();
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        SkiesBlocks.init(event);
        MapColors.init();
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        SkiesItems.init(event);
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        SkiesRecipes.init(event);
        SkiesLootFunctions.init();
    }

    @SubscribeEvent
    public static void registerTileEntityTypes(RegistryEvent.Register<TileEntityType<?>> event) {
        SkiesTileEntityTypes.init(event);
    }

    @SubscribeEvent
    public static void onRegisterSchedules(RegistryEvent.Register<Schedule> event) {
        SkiesSchedules.init(event);
    }

    @SubscribeEvent
    public static void registerEntityTypes(RegistryEvent.Register<EntityType<?>> event) {
        SkiesEntityTypes.init(event);
        SkiesVillagers.initVillagerTypes();
    }

    @SubscribeEvent
    public static void registerVillagerProfessions(RegistryEvent.Register<VillagerProfession> event) {
        SkiesVillagers.init(event);
    }

    @SubscribeEvent
    public static void registerPointsOfInterest(RegistryEvent.Register<PointOfInterestType> event) {
        SkiesPointsOfInterest.init(event);
    }

    @SubscribeEvent
    public static void registerSurfaceBuilders(RegistryEvent.Register<SurfaceBuilder<?>> event) {
        SkiesBiomes.SurfaceBuilders.init(event);
    }

    @SubscribeEvent
    public static void registerBiomes(RegistryEvent.Register<Biome> event) {
        SkiesBiomes.init(event);
    }

    @SubscribeEvent
    public static void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
        SkiesFeatures.init(event);
        SkiesConfiguredFeatures.init();
        SkiesConfiguredCarvers.init();
    }

    @SubscribeEvent
    public static void registerWorldCarvers(RegistryEvent.Register<WorldCarver<?>> event) {
        SkiesFeatures.Carvers.init(event);
    }

    @SubscribeEvent
    public static void registerStructures(RegistryEvent.Register<Structure<?>> event) {
        SkiesStructures.init(event);
    }

    @SubscribeEvent
    public static void registerBiomeDict(RegistryEvent.Register<BiomeType> event) {
        SkiesBiomeDict.init();
    }

    public static <T extends IForgeRegistryEntry<T>> void register(IForgeRegistry<T> registry, String key, T object) {
        SkiesRegistry.register(registry, BlueSkies.locate(key), object);
    }

    public static <T extends IForgeRegistryEntry<T>> void register(IForgeRegistry<T> registry, ResourceLocation key, T object) {
        object.setRegistryName(key);
        registry.register(object);
    }
}

