/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.network.s_to_c;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class IllagerTeleportPacket {
    private int entityId;
    private BlockPos teleportingPos;

    public IllagerTeleportPacket(int entityIdIn, BlockPos teleportingPosIn) {
        this.entityId = entityIdIn;
        this.teleportingPos = teleportingPosIn;
    }

    public static void encoder(IllagerTeleportPacket packet, PacketBuffer buff) {
        buff.writeInt(packet.entityId);
        buff.func_179255_a(packet.teleportingPos);
    }

    public static IllagerTeleportPacket decoder(PacketBuffer buff) {
        return new IllagerTeleportPacket(buff.readInt(), buff.func_179259_c());
    }

    public static void handler(IllagerTeleportPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> IllagerTeleportPacket.handlePacket(packet)));
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handlePacket(IllagerTeleportPacket packet) {
        Entity boss = Minecraft.func_71410_x().field_71441_e.func_73045_a(packet.entityId);
        boss.func_70634_a((double)packet.teleportingPos.func_177958_n(), (double)packet.teleportingPos.func_177956_o(), (double)packet.teleportingPos.func_177952_p());
    }
}

