/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.mod_compat.jei.category;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.data.BlueSkiesData;
import com.legacy.blue_skies.data.objects.SnowcapMushroomFreezing;
import com.legacy.blue_skies.mod_compat.jei.SkiesJEIPlugin;
import com.legacy.blue_skies.mod_compat.jei.category.SkiesCategory;
import com.legacy.blue_skies.registries.SkiesBlocks;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class SnowcapMushroomFreezingCategory
extends SkiesCategory<SnowcapMushroomFreezing> {
    public static final ResourceLocation ID = BlueSkies.locate("snowcap_mushroom_freezing");
    private static final ResourceLocation TEXTURE = BlueSkies.locate("textures/gui/jei/snowcap_mushroom_freezing.png");

    public SnowcapMushroomFreezingCategory(IGuiHelper guiHelper) {
        super(guiHelper, (IItemProvider)SkiesBlocks.snowcap_mushroom, TEXTURE, 94, 33);
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends SnowcapMushroomFreezing> getRecipeClass() {
        return SnowcapMushroomFreezing.class;
    }

    public void setIngredients(SnowcapMushroomFreezing recipe, IIngredients ingredients) {
        if (recipe.block instanceof FlowingFluidBlock) {
            ingredients.setInput(VanillaTypes.FLUID, (Object)new FluidStack((Fluid)((FlowingFluidBlock)recipe.block).getFluid(), 1000));
        } else if (recipe.block.func_199767_j() == Items.field_190931_a) {
            ingredients.setInput(SkiesJEIPlugin.BLOCKSTATE, (Object)recipe.block.func_176223_P());
        } else {
            ingredients.setInput(VanillaTypes.ITEM, (Object)new ItemStack((IItemProvider)recipe.block.func_199767_j()));
        }
        if (recipe.frozenBlock instanceof FlowingFluidBlock) {
            ingredients.setOutput(VanillaTypes.FLUID, (Object)new FluidStack((Fluid)((FlowingFluidBlock)recipe.frozenBlock).getFluid(), 1000));
        } else if (recipe.frozenBlock.func_199767_j() == Items.field_190931_a) {
            ingredients.setOutput(SkiesJEIPlugin.BLOCKSTATE, (Object)BlueSkiesData.SNOWCAP_MUSHROOM_FREEZING.getFrozenState(recipe, recipe.block.func_176223_P()));
        } else {
            ingredients.setOutput(VanillaTypes.ITEM, (Object)new ItemStack((IItemProvider)recipe.frozenBlock.func_199767_j()));
        }
    }

    public void setRecipe(IRecipeLayout recipeLayout, SnowcapMushroomFreezing recipe, IIngredients ingredients) {
        int inputX = 7;
        int y = 8;
        int outputX = 69;
        if (!ingredients.getInputs(VanillaTypes.FLUID).isEmpty()) {
            recipeLayout.getFluidStacks().init(0, true, inputX + 1, y + 1, 16, 16, 1000, false, null);
            recipeLayout.getFluidStacks().set(0, (List)ingredients.getInputs(VanillaTypes.FLUID).get(0));
        } else if (!ingredients.getInputs(SkiesJEIPlugin.BLOCKSTATE).isEmpty()) {
            recipeLayout.getIngredientsGroup(SkiesJEIPlugin.BLOCKSTATE).init(0, true, inputX + 1, y + 1);
            recipeLayout.getIngredientsGroup(SkiesJEIPlugin.BLOCKSTATE).set(0, (List)ingredients.getInputs(SkiesJEIPlugin.BLOCKSTATE).get(0));
        } else {
            recipeLayout.getItemStacks().init(0, true, inputX, y);
            recipeLayout.getItemStacks().set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        }
        if (!ingredients.getOutputs(VanillaTypes.FLUID).isEmpty()) {
            recipeLayout.getFluidStacks().init(1, false, outputX + 1, y + 1, 16, 16, 1000, false, null);
            recipeLayout.getFluidStacks().set(1, (List)ingredients.getOutputs(VanillaTypes.FLUID).get(0));
        } else if (!ingredients.getOutputs(SkiesJEIPlugin.BLOCKSTATE).isEmpty()) {
            recipeLayout.getIngredientsGroup(SkiesJEIPlugin.BLOCKSTATE).init(1, false, outputX + 1, y + 1);
            recipeLayout.getIngredientsGroup(SkiesJEIPlugin.BLOCKSTATE).set(1, (List)ingredients.getOutputs(SkiesJEIPlugin.BLOCKSTATE).get(0));
        } else {
            recipeLayout.getItemStacks().init(1, false, outputX, y);
            recipeLayout.getItemStacks().set(1, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
        }
    }

    public static List<SnowcapMushroomFreezing> getAllRecipes() {
        ArrayList<SnowcapMushroomFreezing> recipes = new ArrayList<SnowcapMushroomFreezing>();
        for (List recipeList : BlueSkiesData.SNOWCAP_MUSHROOM_FREEZING.getData().values()) {
            recipes.addAll(recipeList);
        }
        return recipes;
    }
}

