/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.items.util;

import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public interface IRarityItem {
    default public void setRarityTag(ItemStack stack, SkiesRarity rarity) {
        CompoundNBT nbt = stack.func_196082_o();
        nbt.func_74768_a("Rarity", rarity.id);
    }

    default public SkiesRarity getRarityTag(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        return SkiesRarity.getFromId(nbt.func_74762_e("Rarity"));
    }

    default public <T extends Item> void fillItemCategoryWithRarity(ItemGroup group, NonNullList<ItemStack> stacks, T item) {
        for (SkiesRarity rarity : SkiesRarity.values()) {
            ItemStack stack = new ItemStack(item);
            ((IRarityItem)item).setRarityTag(stack, rarity);
            stacks.add((Object)stack);
        }
    }

    default public void addRarityText(ItemStack stack, List<ITextComponent> lore) {
        IFormattableTextComponent rarityLabel = new TranslationTextComponent("gui.blue_skies.item.rarity").func_240699_a_(TextFormatting.LIGHT_PURPLE);
        TranslationTextComponent itemRarity = new TranslationTextComponent(String.format("gui.blue_skies.item.rarity.%s", this.getRarityTag(stack).getId()));
        lore.add((ITextComponent)new TranslationTextComponent("%s: %s", new Object[]{rarityLabel, itemRarity}));
    }

    public static class WeightedSkiesRarity
    extends WeightedRandom.Item {
        private final SkiesRarity rarity;

        public WeightedSkiesRarity(int itemWeightIn, SkiesRarity rarity) {
            super(itemWeightIn);
            this.rarity = rarity;
        }

        public SkiesRarity getRarity() {
            return this.rarity;
        }
    }

    public static enum SkiesRarity {
        COMMON(0, "common"),
        UNCOMMON(1, "uncommon"),
        RARE(2, "rare");

        private final int id;
        private final String name;

        private SkiesRarity(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String toString() {
            return this.name;
        }

        public static SkiesRarity getFromId(int id) {
            if (id >= 0 && id < SkiesRarity.values().length) {
                return SkiesRarity.values()[id];
            }
            return COMMON;
        }
    }
}

