/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.items.arcs;

import com.legacy.blue_skies.items.arcs.ArcItem;
import java.util.UUID;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeMod;

public class AquaticArcItem
extends ArcItem {
    private static final AttributeModifier[] SWIM_SPEED_BOOSTS = new AttributeModifier[]{new AttributeModifier(UUID.fromString("f8edab1e-d58d-45b3-9615-d9f72f21c763"), "aquatic_swim_speed_1", 0.1, AttributeModifier.Operation.MULTIPLY_TOTAL), new AttributeModifier(UUID.fromString("4291562c-d877-4c00-b354-92758e421ee0"), "aquatic_swim_speed_2", 0.2, AttributeModifier.Operation.MULTIPLY_TOTAL)};

    public AquaticArcItem(int slotId) {
        super(slotId, "aquatic");
    }

    @Override
    public void onEquip(ItemStack stack, PlayerEntity player) {
        int level;
        ModifiableAttributeInstance swimSpeed = player.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get());
        if (!swimSpeed.func_180374_a(SWIM_SPEED_BOOSTS[Math.min(1, level = this.getFunctionalLevel(stack, player))])) {
            swimSpeed.func_233767_b_(SWIM_SPEED_BOOSTS[Math.min(1, level)]);
        }
    }

    @Override
    public void onUnequip(ItemStack stack, PlayerEntity player) {
        ModifiableAttributeInstance swimSpeed = player.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get());
        for (int i = 0; i < SWIM_SPEED_BOOSTS.length; ++i) {
            if (!swimSpeed.func_180374_a(SWIM_SPEED_BOOSTS[i])) continue;
            swimSpeed.func_111124_b(SWIM_SPEED_BOOSTS[i]);
        }
    }

    @Override
    public void serverTick(ItemStack stack, ServerPlayerEntity player) {
        int level = this.getFunctionalLevel(stack, (PlayerEntity)player);
        if (level > 1 && player.func_223314_ad() > 0 && player.func_223314_ad() % 15 == 0) {
            int amount = player.func_223314_ad() - (level - 1) * 10;
            player.func_241209_g_(amount);
        }
    }

    @Override
    public void refresh(ItemStack stack, PlayerEntity player) {
        this.onUnequip(stack, player);
        this.onEquip(stack, player);
    }
}

