/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.items;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.items.util.FoodPrepUtils;
import com.legacy.blue_skies.items.util.PreparedFood;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PreparedFoodItem
extends Item {
    public PreparedFoodItem(Item.Properties properties) {
        super(properties);
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.EAT;
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (player.func_71043_e(FoodPrepUtils.deserialize(heldItem.func_77978_p()).getHungerPerBite() <= 2)) {
            player.func_184598_c(hand);
            return ActionResult.func_226249_b_((Object)heldItem);
        }
        return ActionResult.func_226251_d_((Object)heldItem);
    }

    public ItemStack func_77654_b(ItemStack stack, World world, LivingEntity entity) {
        PreparedFood preparedFood = FoodPrepUtils.deserialize(stack.func_77978_p());
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            player.func_71024_bL().func_75122_a(preparedFood.getHungerPerBite(), preparedFood.getSaturation());
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)stack.func_77973_b()));
            world.func_184148_a((PlayerEntity)null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            if (player instanceof ServerPlayerEntity) {
                CriteriaTriggers.field_193138_y.func_193148_a((ServerPlayerEntity)player, stack);
            }
        }
        world.func_184148_a((PlayerEntity)null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), entity.func_213353_d(stack), SoundCategory.NEUTRAL, 1.0f, 1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.4f);
        preparedFood.getEffects().forEach(arg_0 -> ((LivingEntity)entity).func_195064_c(arg_0));
        CompoundNBT tag = stack.func_196082_o();
        if (!(entity instanceof PlayerEntity) || !((PlayerEntity)entity).field_71075_bZ.field_75098_d) {
            preparedFood.use();
            if (preparedFood.getUses() <= 0) {
                stack.func_190918_g(1);
            } else {
                tag.func_74768_a("Uses", preparedFood.getUses());
            }
        }
        FoodPrepUtils.causeInstability(preparedFood, entity);
        return stack;
    }

    public boolean func_219971_r() {
        return false;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return FoodPrepUtils.getUses(stack) < FoodPrepUtils.getMaxUses(stack);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        double durability = ((double)FoodPrepUtils.getMaxUses(stack) - (double)FoodPrepUtils.getUses(stack)) / (double)FoodPrepUtils.getMaxUses(stack);
        return durability;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        PreparedFood preparedFood = FoodPrepUtils.deserialize(stack.func_77978_p());
        preparedFood.getIngredients().forEach(i -> tooltip.add((ITextComponent)new StringTextComponent("- ").func_230529_a_(i.func_200301_q()).func_240699_a_(TextFormatting.GRAY)));
        if (BlueSkies.IDE && Screen.func_231173_s_()) {
            tooltip.add((ITextComponent)new StringTextComponent(""));
            tooltip.add((ITextComponent)new StringTextComponent("Developer Info").func_240699_a_(TextFormatting.UNDERLINE));
            tooltip.add((ITextComponent)new StringTextComponent("Uses: " + preparedFood.getUses() + "/" + preparedFood.getMaxUses()).func_240699_a_(TextFormatting.GRAY));
            tooltip.add((ITextComponent)new StringTextComponent("Hunger: " + preparedFood.getHungerPerBite()).func_240699_a_(TextFormatting.GRAY));
            tooltip.add((ITextComponent)new StringTextComponent("Total Hunger: " + preparedFood.getTotalHunger()).func_240699_a_(TextFormatting.GRAY));
            tooltip.add((ITextComponent)new StringTextComponent("Saturation: " + preparedFood.getSaturation()).func_240699_a_(TextFormatting.GRAY));
            if (preparedFood.getEffects().size() > 0) {
                tooltip.add((ITextComponent)new StringTextComponent("Effects:").func_240699_a_(TextFormatting.GRAY));
                preparedFood.getEffects().forEach(i -> tooltip.add((ITextComponent)new StringTextComponent("- ").func_240702_b_(String.format("%s x%d %d:%d", i.func_188419_a().func_199286_c().getString(), i.func_76458_c() + 1, (int)((float)i.func_76459_b() / 20.0f) / 60, (int)((float)i.func_76459_b() / 20.0f) % 60)).func_240699_a_(TextFormatting.GRAY)));
            }
        }
    }
}

