/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.events;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.structure_gel.SGRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SkiesMappingChanges {
    @SubscribeEvent
    protected static void blockMapping(RegistryEvent.MissingMappings<Block> event) {
        HashMap<ResourceLocation, Block> blocks = new HashMap<ResourceLocation, Block>(){
            private static final long serialVersionUID = 4431458256986938918L;
            {
                this.put("poison_slab", SkiesBlocks.poison_stone_slab);
                this.put("poison_stairs", SkiesBlocks.poison_stone_stairs);
                this.put("poison_wall", SkiesBlocks.poison_stonebrick_wall);
                this.put("glowing_poison_slab", SkiesBlocks.glowing_poison_stone_slab);
                this.put("glowing_poison_stairs", SkiesBlocks.glowing_poison_stone_stairs);
                this.put("glowing_poison_wall", SkiesBlocks.poison_stonebrick_wall);
                this.put("nature_slab", SkiesBlocks.nature_stone_slab);
                this.put("nature_stairs", SkiesBlocks.nature_stone_stairs);
                this.put("nature_wall", SkiesBlocks.nature_stonebrick_wall);
                this.put("glowing_nature_slab", SkiesBlocks.glowing_nature_stone_slab);
                this.put("glowing_nature_stairs", SkiesBlocks.glowing_nature_stone_stairs);
                this.put("glowing_nature_wall", SkiesBlocks.glowing_nature_stonebrick_wall);
                this.put("structure_filler", (Block)SGRegistry.GelBlocks.RED_GEL);
                this.put("corn", SkiesBlocks.pine_fruits);
                this.put("cabbage", SkiesBlocks.winter_leaves);
                this.put("raspberry_bush", SkiesBlocks.brewberry_bush);
                this.put("potted_raspberry_bush", SkiesBlocks.potted_brewberry_bush);
                this.put("tomatoes", SkiesBlocks.scalefruits);
                this.put("green_beans", SkiesBlocks.fiery_beans);
                this.put("peanuts", SkiesBlocks.solnuts);
                this.put("nectarine_fruit", SkiesBlocks.crescent_fruit);
                this.put("nectarine_leaves", (Block)SkiesBlocks.crescent_fruit_leaves);
                this.put("nectarine_sapling", SkiesBlocks.crescent_fruit_sapling);
                this.put("potted_nectarine_sapling", SkiesBlocks.potted_crescent_fruit_sapling);
                this.put("turquoise_block", SkiesBlocks.aquite_block);
                this.put("everbright_turquoise_ore", (Block)SkiesBlocks.everbright_aquite_ore);
                this.put("everdawn_turquoise_ore", (Block)SkiesBlocks.everdawn_aquite_ore);
            }

            @Override
            public void put(String key, Block value) {
                this.put(BlueSkies.locate(key), value);
            }
        };
        SkiesMappingChanges.handleRemap(event, "Found missing block mappings. Attempting to replace them...", m -> SkiesMappingChanges.remap(m, blocks));
    }

    @SubscribeEvent
    protected static void itemMapping(RegistryEvent.MissingMappings<Item> event) {
        HashMap<ResourceLocation, Item> items = new HashMap<ResourceLocation, Item>(){
            private static final long serialVersionUID = -7164982842679092263L;
            {
                this.put("poison_slab", SkiesBlocks.poison_stone_slab);
                this.put("poison_stairs", SkiesBlocks.poison_stone_stairs);
                this.put("poison_wall", SkiesBlocks.poison_stonebrick_wall);
                this.put("glowing_poison_slab", SkiesBlocks.glowing_poison_stone_slab);
                this.put("glowing_poison_stairs", SkiesBlocks.glowing_poison_stone_stairs);
                this.put("glowing_poison_wall", SkiesBlocks.poison_stonebrick_wall);
                this.put("nature_slab", SkiesBlocks.nature_stone_slab);
                this.put("nature_stairs", SkiesBlocks.nature_stone_stairs);
                this.put("nature_wall", SkiesBlocks.nature_stonebrick_wall);
                this.put("glowing_nature_slab", SkiesBlocks.glowing_nature_stone_slab);
                this.put("glowing_nature_stairs", SkiesBlocks.glowing_nature_stone_stairs);
                this.put("glowing_nature_wall", SkiesBlocks.glowing_nature_stonebrick_wall);
                this.put("structure_filler", (Block)SGRegistry.GelBlocks.RED_GEL);
                this.put("corn", SkiesItems.pine_fruit);
                this.put("cabbage", SkiesItems.winter_leaves);
                this.put("raspberry_bush", SkiesBlocks.brewberry_bush);
                this.put("raspberry", SkiesItems.brewberry);
                this.put("pink_raspberry", SkiesItems.pink_brewberry);
                this.put("black_raspberry", SkiesItems.black_brewberry);
                this.put("tomato", SkiesItems.scalefruit);
                this.put("green_bean", SkiesItems.fiery_beans);
                this.put("peanut", SkiesItems.solnut);
                this.put("nectarine", SkiesItems.crescent_fruit);
                this.put("nectarine_leaves", (Block)SkiesBlocks.crescent_fruit_leaves);
                this.put("nectarine_sapling", SkiesBlocks.crescent_fruit_sapling);
                this.put("corn_seeds", SkiesItems.pine_fruit_seeds);
                this.put("cabbage_seeds", SkiesItems.winter_leaf_seeds);
                this.put("tomato_seeds", SkiesItems.scalefruit_seeds);
                this.put("green_bean_seeds", SkiesItems.fiery_bean_seeds);
                this.put("hellfire_arc", SkiesItems.life_arc);
                this.put("blue_lore", SkiesItems.blue_journal);
                this.put("turquoise_gem", SkiesItems.aquite_gem);
                this.put("turquoise_sword", SkiesItems.aquite_sword);
                this.put("turquoise_pickaxe", SkiesItems.aquite_pickaxe);
                this.put("turquoise_axe", SkiesItems.aquite_axe);
                this.put("turquoise_shovel", SkiesItems.aquite_shovel);
                this.put("turquoise_hoe", SkiesItems.aquite_hoe);
                this.put("turquoise_helmet", SkiesItems.aquite_helmet);
                this.put("turquoise_chestplate", SkiesItems.aquite_chestplate);
                this.put("turquoise_leggings", SkiesItems.aquite_leggings);
                this.put("turquoise_boots", SkiesItems.aquite_boots);
                this.put("mudkipz_sword", SkiesItems.debug_sword);
                this.put("turquoise_block", SkiesBlocks.aquite_block);
                this.put("everbright_turquoise_ore", (Block)SkiesBlocks.everbright_aquite_ore);
                this.put("everdawn_turquoise_ore", (Block)SkiesBlocks.everdawn_aquite_ore);
                this.put("raw_azulfo_beef", SkiesItems.carabeef);
                this.put("azulfo_steak", SkiesItems.cooked_carabeef);
                this.put("raw_venison", SkiesItems.venison);
                this.put("venison_steak", SkiesItems.cooked_venison);
            }

            @Override
            public void put(String key, Item value) {
                this.put(BlueSkies.locate(key), value);
            }

            @Override
            public void put(String key, Block value) {
                this.put(BlueSkies.locate(key), value.func_199767_j());
            }
        };
        SkiesMappingChanges.handleRemap(event, "Found missing item mappings. Attempting to replace them...", m -> SkiesMappingChanges.remap(m, items));
    }

    @SubscribeEvent
    protected static void soundMapping(RegistryEvent.MissingMappings<SoundEvent> event) {
        SkiesMappingChanges.handleRemap(event, "Found missing sound event mappings. Ignoring them, as they do not need to be remapped.", m -> m.ignore());
    }

    private static <T extends IForgeRegistryEntry<T>> void handleRemap(RegistryEvent.MissingMappings<T> event, String logMessage, Consumer<? super RegistryEvent.MissingMappings.Mapping<T>> action) {
        if (event.getAllMappings().stream().filter(m -> m.key.func_110624_b().equals("blue_skies")).findAny().isPresent()) {
            BlueSkies.LOGGER.warn(logMessage);
            event.getAllMappings().stream().filter(m -> m.key.func_110624_b().equals("blue_skies")).forEach(action);
        }
    }

    private static <T extends IForgeRegistryEntry<T>> void remap(RegistryEvent.MissingMappings.Mapping<T> mapping, Map<ResourceLocation, T> remappings) {
        ResourceLocation key = mapping.key;
        if (remappings.containsKey(key)) {
            mapping.remap((IForgeRegistryEntry)remappings.get(key));
            BlueSkies.LOGGER.warn("Replaced " + key + " with " + ((IForgeRegistryEntry)remappings.get(key)).getRegistryName());
        } else {
            mapping.ignore();
            BlueSkies.LOGGER.warn("Could not find a mapping replacement for " + key + ". It was likely intentionally removed in an update.");
        }
    }
}

