/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.events;

import com.google.common.collect.ImmutableList;
import com.legacy.blue_skies.blocks.construction.TroughBlock;
import com.legacy.blue_skies.capability.SkiesPlayer;
import com.legacy.blue_skies.entities.SupporterPetEntity;
import com.legacy.blue_skies.entities.ai.NightwatcherRobGoal;
import com.legacy.blue_skies.entities.ai.ShovelSnowGoal;
import com.legacy.blue_skies.entities.ai.VillagerWanderAtWorkGoal;
import com.legacy.blue_skies.entities.hostile.ArmoredFrostSpiritEntity;
import com.legacy.blue_skies.entities.hostile.StoneletEntity;
import com.legacy.blue_skies.entities.hostile.VenomSpiderEntity;
import com.legacy.blue_skies.entities.hostile.boss.AlchemistEntity;
import com.legacy.blue_skies.entities.hostile.boss.SummonerEntity;
import com.legacy.blue_skies.entities.util.SkiesEntityHooks;
import com.legacy.blue_skies.entities.util.base.SkiesIllagerBossEntity;
import com.legacy.blue_skies.entities.util.interfaces.ISkyBoss;
import com.legacy.blue_skies.entities.villager.SkiesVillagerTrades;
import com.legacy.blue_skies.items.util.FurnaceFuels;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesDimensions;
import com.legacy.blue_skies.registries.SkiesEffects;
import com.legacy.blue_skies.registries.SkiesPointsOfInterest;
import com.legacy.blue_skies.registries.SkiesStructures;
import com.legacy.blue_skies.util.EntityUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.monster.CaveSpiderEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.village.PointOfInterest;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SkiesEvents {
    private static final ImmutableList<ResourceLocation> SPAWN_EXCEPTIONS = ImmutableList.of((Object)EntityType.field_200756_av.getRegistryName(), (Object)EntityType.field_200757_aw.getRegistryName(), (Object)EntityType.field_220360_g.getRegistryName(), (Object)EntityType.field_200794_h.getRegistryName());

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof VillagerEntity) {
            VillagerEntity villager = (VillagerEntity)event.getEntity();
            villager.field_70714_bg.func_75776_a(1, (Goal)new ShovelSnowGoal(villager, 0.5));
            villager.field_70714_bg.func_75776_a(1, (Goal)new NightwatcherRobGoal(villager, 0.4));
            villager.field_70714_bg.func_75776_a(5, (Goal)new VillagerWanderAtWorkGoal(villager, 0.6));
            villager.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)villager, SummonerEntity.class, 8.0f, 0.6, 0.6));
            villager.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)villager, AlchemistEntity.class, 8.0f, 0.6, 0.6));
            villager.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)villager, ArmoredFrostSpiritEntity.class, 8.0f, 0.6, 0.6));
        }
    }

    @SubscribeEvent
    public static void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity() instanceof PlayerEntity) {
            SkiesPlayer.ifPresent((PlayerEntity)event.getEntityLiving(), skyPlayer -> skyPlayer.serverTick());
        }
        if (event.getEntity() instanceof LivingEntity) {
            BlockState trough;
            int radius;
            Stream<PointOfInterest> poi;
            Optional<PointOfInterest> optional;
            AnimalEntity animal;
            LivingEntity entity = (LivingEntity)event.getEntity();
            if (event.getEntityLiving().func_70660_b(SkiesEffects.DEADLY_VENOM) != null) {
                boolean canDeadlyVenomHurt;
                EffectInstance effect = event.getEntityLiving().func_70660_b(SkiesEffects.DEADLY_VENOM);
                int difficultyTimePerHit = effect.func_76458_c() == 0 ? 12 : (effect.func_76458_c() == 1 ? 11 : 2);
                boolean bl = canDeadlyVenomHurt = entity.field_70173_aa % difficultyTimePerHit == 0;
                if (canDeadlyVenomHurt) {
                    entity.func_70097_a(EntityUtil.DamageSources.DEADLY_VENOM, 2.0f);
                }
            }
            if (entity.field_70170_p instanceof ServerWorld && entity instanceof AnimalEntity && (animal = (AnimalEntity)entity).func_70631_g_() && animal.field_70170_p.field_73012_v.nextFloat() < 0.3f && animal.field_70173_aa % (200 + animal.func_70681_au().nextInt(50)) == 0 && (optional = (poi = EntityUtil.getPoisInCircle((Entity)animal, SkiesPointsOfInterest.TROUGH, radius = 7)).findAny()).isPresent() && TroughBlock.canConsume(trough = entity.field_70170_p.func_180495_p(optional.get().func_218261_f()), (IWorld)entity.field_70170_p)) {
                animal.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
                if (animal.field_70170_p.field_73012_v.nextFloat() < 0.3f) {
                    TroughBlock.attemptConsume(trough, (IWorld)entity.field_70170_p, optional.get().func_218261_f());
                    animal.func_175501_a(30 + animal.field_70170_p.field_73012_v.nextInt(10), true);
                } else {
                    animal.func_175501_a(10 + animal.field_70170_p.field_73012_v.nextInt(10), true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K && event.getEntity() instanceof ISkyBoss) {
            AxisAlignedBB radiusCheck = new AxisAlignedBB(event.getEntity().func_233580_cy_()).func_72314_b(25.0, 15.0, 25.0);
            List playerList = event.getEntity().field_70170_p.func_217357_a(PlayerEntity.class, radiusCheck);
            ISkyBoss boss = (ISkyBoss)event.getEntity();
            for (PlayerEntity player : playerList) {
                SkiesPlayer.ifPresent(player, skiesPlayer -> {
                    if (boss.isEverbrightBoss() && skiesPlayer.getBrightProgression() == boss.getProgression() - 1) {
                        EntityUtil.sendJournalToast(player);
                        skiesPlayer.setBrightProgression((byte)boss.getProgression());
                    } else if (!boss.isEverbrightBoss() && skiesPlayer.getDawnProgression() == boss.getProgression() - 1) {
                        EntityUtil.sendJournalToast(player);
                        skiesPlayer.setDawnProgression((byte)boss.getProgression());
                    }
                    skiesPlayer.syncDataToClient();
                });
            }
        }
    }

    @SubscribeEvent
    public static void onEntityCheckSpawn(LivingSpawnEvent.CheckSpawn event) {
        Stream<PointOfInterest> stream;
        Optional<PointOfInterest> poi;
        LivingEntity entity = event.getEntityLiving();
        if (SkiesDimensions.inSkyDimension((Entity)entity)) {
            if (event.getSpawnReason() == SpawnReason.NATURAL) {
                if (entity.func_200600_R().getRegistryName() == null || entity.func_200600_R().getRegistryName() != null && !entity.func_200600_R().getRegistryName().func_110624_b().equals("blue_skies") && !(entity instanceof AbstractFishEntity) && !SPAWN_EXCEPTIONS.contains((Object)entity.func_200600_R().getRegistryName())) {
                    event.setResult(Event.Result.DENY);
                }
                if (entity instanceof CaveSpiderEntity && (event.getWorld().func_175710_j(entity.func_233580_cy_()) || entity.func_233580_cy_().func_177956_o() > 50 || EntityUtil.isPosInStructure(entity.field_70170_p, entity.func_233580_cy_(), SkiesStructures.POISON_DUNGEON.getStructure()) && (entity.field_70170_p.field_73012_v.nextInt(7) != 0 || entity.func_233580_cy_().func_177956_o() < 15 || entity.func_233580_cy_().func_177956_o() > 50))) {
                    System.out.println("denined");
                    event.setResult(Event.Result.DENY);
                }
                if (entity instanceof VenomSpiderEntity && entity.func_233580_cy_().func_177956_o() < 15 && EntityUtil.isPosInStructure(entity.field_70170_p, entity.func_233580_cy_(), SkiesStructures.POISON_DUNGEON.getStructure())) {
                    event.setResult(Event.Result.DENY);
                }
            }
            if (entity instanceof StoneletEntity && EntityUtil.isPosInStructure(entity.field_70170_p, entity.func_233580_cy_(), SkiesStructures.NATURE_DUNGEON.getStructure()) && (event.getSpawnReason() == SpawnReason.NATURAL || event.getSpawnReason() == SpawnReason.SPAWNER)) {
                boolean flag = EntityUtil.canSpawnWithoutFlooding(entity);
                if (!(entity.func_233580_cy_().func_177956_o() <= 145 || entity.field_70170_p.func_226660_f_(entity.func_233580_cy_()) && entity.field_70170_p.func_180495_p(entity.func_233580_cy_().func_177977_b()).func_177230_c() == SkiesBlocks.turquoise_cherry_grass_block)) {
                    event.setResult(Event.Result.DENY);
                }
                if (flag) {
                    event.setResult(Event.Result.ALLOW);
                } else {
                    event.setResult(Event.Result.DENY);
                }
            }
        }
        if (entity.func_200600_R().func_220339_d() == EntityClassification.MONSTER && (event.getSpawnReason() == SpawnReason.NATURAL || event.getSpawnReason() == SpawnReason.SPAWNER) && entity.field_70170_p instanceof ServerWorld && (poi = (stream = EntityUtil.getPoisInCircle((Entity)entity, SkiesPointsOfInterest.WARDING_PEARL, 25)).findAny()).isPresent()) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onVillagerTradesAssigned(VillagerTradesEvent event) {
        try {
            if (event.getType() == VillagerProfession.field_221154_d) {
                ((List)event.getTrades().get(2)).add(SkiesVillagerTrades.EVERBRIGHT_BLINDING_DUNGEON_OFFER);
                ((List)event.getTrades().get(2)).add(SkiesVillagerTrades.EVERDAWN_BLINDING_DUNGEON_OFFER);
                ((List)event.getTrades().get(3)).add(SkiesVillagerTrades.NATURE_DUNGEON_OFFER);
                ((List)event.getTrades().get(3)).add(SkiesVillagerTrades.POISON_DUNGEON_OFFER);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public static void onLivingSetTarget(LivingSetAttackTargetEvent event) {
        if (event.getTarget() instanceof SupporterPetEntity && event.getEntityLiving() instanceof MobEntity) {
            ((MobEntity)event.getEntityLiving()).func_70624_b(null);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void nerfReachAttacks(LivingDamageEvent event) {
        float maxDist;
        double dist;
        DamageSource source;
        if (event.getEntityLiving() instanceof ISkyBoss && ((ISkyBoss)event.getEntityLiving()).getMaxReach() >= 0.0f && !event.getSource().func_180136_u() && (source = event.getSource()).func_76364_f() instanceof PlayerEntity && (dist = (double)source.func_76364_f().func_70032_d((Entity)event.getEntityLiving())) > (double)(maxDist = ((ISkyBoss)event.getEntityLiving()).getMaxReach())) {
            event.setAmount(0.0f);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingDamageEvent event) {
        DamageSource source = event.getSource();
        if (source.func_76364_f() != null && SkiesDimensions.inSkyDimension(source.func_76364_f())) {
            if (source.func_76364_f() instanceof PlayerEntity) {
                event.setAmount(SkiesEntityHooks.nerfDamage(source, event.getAmount()));
            } else if (source.func_76352_a() || source instanceof IndirectEntityDamageSource) {
                event.setAmount(source.func_76346_g() == null ? Math.min(5.0f, event.getAmount()) : SkiesEntityHooks.nerfIndirectDamage(source, event.getAmount()));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void capBossDamage(LivingDamageEvent event) {
        if (event.getEntityLiving() instanceof ISkyBoss && event.getAmount() > (float)((ISkyBoss)event.getEntityLiving()).getDamageCap() && !event.getSource().func_180136_u() && event.getSource() != DamageSource.field_76380_i) {
            event.setAmount(20.0f);
        }
    }

    @SubscribeEvent
    public static void onLivingKnockBack(LivingKnockBackEvent event) {
        if (event.getEntityLiving() instanceof ISkyBoss && !(event.getEntityLiving() instanceof SkiesIllagerBossEntity)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onExplosionStart(ExplosionEvent.Start event) {
        if (EntityUtil.isInDungeon(event.getWorld(), new BlockPos(event.getExplosion().getPosition()))) {
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public static void onExplosionDetonate(ExplosionEvent.Detonate event) {
        ArrayList blocks = new ArrayList(event.getAffectedBlocks());
        blocks.forEach(positions -> {
            if (EntityUtil.isInDungeon(event.getWorld(), positions)) {
                event.getAffectedBlocks().remove(positions);
            }
        });
    }

    @SubscribeEvent
    public static void getBurnTime(FurnaceFuelBurnTimeEvent event) {
        Item item = event.getItemStack().func_77973_b();
        if (item.getRegistryName().func_110624_b().equals("blue_skies")) {
            event.setBurnTime(FurnaceFuels.getBurnTime(item));
        }
    }
}

