/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.villager;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.legacy.blue_skies.items.util.IFalsiteItem;
import com.legacy.blue_skies.items.util.ToolUtils;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesDimensions;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.registries.SkiesStructures;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;

public class SkiesVillagerTrades {
    private static final List<Item> EVERBRIGHT_STICKS = Lists.newArrayList((Object[])new Item[]{SkiesItems.bluebright_stick, SkiesItems.starlit_stick, SkiesItems.frostbright_stick, SkiesItems.cherry_stick});
    private static final List<Item> EVERDAWN_STICKS = Lists.newArrayList((Object[])new Item[]{SkiesItems.lunar_stick, SkiesItems.dusk_stick, SkiesItems.maple_stick, SkiesItems.cherry_stick});
    private static final Item EMERALD = Items.field_151166_bC;
    public static final Int2ObjectMap<VillagerTrades.ITrade[]> STARGAZER_OFFERS = SkiesVillagerTrades.getAsIntMap((ImmutableMap<Integer, VillagerTrades.ITrade[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ITrade[]{new DoubleTrade.Builder().firstItem((IItemProvider)SkiesItems.falsite_ingot, 4).secondItem((IItemProvider)SkiesItems.moonstone_shard, 1).result((IItemProvider)Items.field_151113_aN, 1).build(), new SingleTrade.Builder().item((IItemProvider)SkiesBlocks.star_flare, 32).result((IItemProvider)EMERALD, 1).maxUses(10).build()}, (Object)2, (Object)new VillagerTrades.ITrade[]{new DoubleTrade.Builder().firstItem((IItemProvider)SkiesItems.ventium_ingot, 4).secondItem((IItemProvider)SkiesItems.moonstone_shard, 1).result((IItemProvider)Items.field_151111_aL, 1).givenXP(10).build(), new SingleTrade.Builder().item((IItemProvider)Blocks.field_150359_w, 16).result((IItemProvider)EMERALD, 1).maxUses(10).givenXP(7).build()}, (Object)3, (Object)new VillagerTrades.ITrade[]{new SingleTrade.Builder().item((IItemProvider)Items.field_151042_j, 5).result((IItemProvider)EMERALD, 1).givenXP(15).build(), new EmeraldForMapTrade(7, SkiesStructures.BUNKER.getStructure(), MapDecoration.Type.TARGET_POINT, 12, 20)}, (Object)4, (Object)new VillagerTrades.ITrade[]{new DoubleTrade.Builder().firstItem((IItemProvider)SkiesBlocks.moonstone, 6).secondItem((IItemProvider)Blocks.field_150411_aY, 8).result((IItemProvider)SkiesBlocks.moonstone_lantern, 3).maxUses(15).givenXP(25).build()}, (Object)5, (Object)new VillagerTrades.ITrade[]{new SingleTrade.Builder().item((IItemProvider)EMERALD, 10).result((IItemProvider)SkiesItems.astrolabe, 1).givenXP(30).build()}));
    public static final Int2ObjectMap<VillagerTrades.ITrade[]> WRANGLER_OFFERS = SkiesVillagerTrades.getAsIntMap((ImmutableMap<Integer, VillagerTrades.ITrade[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ITrade[]{new SingleTrade.Builder().item((IItemProvider)EMERALD, 1).result((IItemProvider)SkiesItems.cooked_charscale_moki, 4).build(), new SingleTrade.Builder().item((IItemProvider)EMERALD, 1).result((IItemProvider)Items.field_151058_ca, 4).build()}, (Object)2, (Object)new VillagerTrades.ITrade[]{new DoubleTrade.Builder().firstItem((IItemProvider)EMERALD, 1).secondItem((IItemProvider)Items.field_151116_aA, 4).result((IItemProvider)Items.field_151141_av, 1).maxUses(15).givenXP(10).build(), new SingleTrade.Builder().item((IItemProvider)SkiesItems.azulfo_horn, 16).result((IItemProvider)EMERALD, 1).maxUses(10).givenXP(7).build(), new SingleTrade.Builder().item((IItemProvider)EMERALD, 1).result((IItemProvider)SkiesItems.cooked_monitor_tail, 3).build()}, (Object)3, (Object)new VillagerTrades.ITrade[]{new SingleTrade.Builder().item((IItemProvider)EMERALD, 2).result((IItemProvider)SkiesItems.cooked_grittle_flatfish, 6).maxUses(10).givenXP(15).build(), new SingleTrade.Builder().item((IItemProvider)EMERALD, 2).result((IItemProvider)Items.field_179557_bn, 8).maxUses(10).givenXP(13).build()}, (Object)4, (Object)new VillagerTrades.ITrade[]{new DoubleTrade.Builder().firstItem((IItemProvider)SkiesItems.cherry, 6).secondItem((IItemProvider)EMERALD, 1).result((IItemProvider)SkiesBlocks.cherry_pie, 1).givenXP(20).build(), new SingleTrade.Builder().item((IItemProvider)Items.field_151007_F, 26).result((IItemProvider)EMERALD, 1).maxUses(10).givenXP(16).build()}, (Object)5, (Object)new VillagerTrades.ITrade[]{new SingleTrade.Builder().item((IItemProvider)EMERALD, 2).result((IItemProvider)SkiesItems.cooked_carabeef, 4).maxUses(10).givenXP(25).build(), new SingleTrade.Builder().item((IItemProvider)EMERALD, 2).result((IItemProvider)SkiesItems.cooked_venison, 4).maxUses(10).givenXP(25).build()}));
    public static final Int2ObjectMap<VillagerTrades.ITrade[]> SHOVELER_OFFERS = SkiesVillagerTrades.getAsIntMap((ImmutableMap<Integer, VillagerTrades.ITrade[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ITrade[]{new ToolWithFalsiteTrade(1, SkiesItems.pyrope_gem, SkiesItems.pyrope_shovel, 5, 7), new SingleTrade.Builder().item((IItemProvider)SkiesItems.falsite_ingot, 8).result((IItemProvider)EMERALD, 1).maxUses(8).givenXP(8).build(), new SingleTrade.Builder().item((IItemProvider)SkiesItems.falsite_ingot, 4).result((IItemProvider)Blocks.field_196604_cC, 16).givenXP(5).build()}, (Object)2, (Object)new VillagerTrades.ITrade[]{new ToolWithFalsiteTrade(2, SkiesItems.aquite_gem, SkiesItems.aquite_shovel, 5, 10), new DoubleTrade.Builder().firstItem((IItemProvider)SkiesItems.falsite_ingot, 3).secondItem((IItemProvider)SkiesItems.aquite_gem, 5).result((IItemProvider)EMERALD, 1).givenXP(10).build()}, (Object)3, (Object)new VillagerTrades.ITrade[]{new ToolWithFalsiteTrade(3, SkiesItems.horizonite_ingot, SkiesItems.horizonite_shovel, 15, 15, 5), new StickForFalsiteTrade(1, 5, 10)}, (Object)4, (Object)new VillagerTrades.ITrade[]{new ToolWithFalsiteTrade(5, SkiesItems.diopside_gem, SkiesItems.diopside_shovel, 5, 20, 12)}, (Object)5, (Object)new VillagerTrades.ITrade[]{new ToolWithFalsiteTrade(10, SkiesItems.charoite, SkiesItems.charoite_shovel, 5, 25, 17)}));
    public static final Int2ObjectMap<VillagerTrades.ITrade[]> NIGHTWATCHER_OFFERS = SkiesVillagerTrades.getAsIntMap((ImmutableMap<Integer, VillagerTrades.ITrade[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ITrade[]{new SingleTrade.Builder().item((IItemProvider)EMERALD, 1).result((IItemProvider)Items.field_151007_F, 16).build(), new SingleTrade.Builder().item((IItemProvider)EMERALD, 1).result((IItemProvider)Items.field_151014_N, 32).build(), new SingleTrade.Builder().item((IItemProvider)EMERALD, 1).result((IItemProvider)Items.field_151025_P, 8).givenXP(5).build()}, (Object)2, (Object)new VillagerTrades.ITrade[]{new SingleTrade.Builder().item((IItemProvider)EMERALD, 1).result((IItemProvider)SkiesItems.cooked_charscale_moki, 6).givenXP(10).build(), new SingleTrade.Builder().item((IItemProvider)EMERALD, 1).result((IItemProvider)Items.field_196102_ba, 6).givenXP(10).build(), new SingleTrade.Builder().item((IItemProvider)EMERALD, 1).result((IItemProvider)SkiesItems.cooked_horizofin_tunid, 6).givenXP(10).build(), new SingleTrade.Builder().item((IItemProvider)EMERALD, 1).result((IItemProvider)SkiesItems.cooked_municipal_monkfish, 6).givenXP(10).build()}, (Object)3, (Object)new VillagerTrades.ITrade[]{new SingleTrade.Builder().item((IItemProvider)EMERALD, 3).result((IItemProvider)SkiesItems.aquite_helmet, 1).givenXP(15).build(), new SingleTrade.Builder().item((IItemProvider)EMERALD, 5).result((IItemProvider)SkiesItems.aquite_chestplate, 1).givenXP(15).build(), new SingleTrade.Builder().item((IItemProvider)EMERALD, 4).result((IItemProvider)SkiesItems.aquite_leggings, 1).givenXP(15).build(), new SingleTrade.Builder().item((IItemProvider)EMERALD, 3).result((IItemProvider)SkiesItems.aquite_boots, 1).givenXP(15).build(), new SingleTrade.Builder().item((IItemProvider)EMERALD, 1).result((IItemProvider)SkiesItems.aquite_gem, 6).givenXP(15).build(), new SingleTrade.Builder().item((IItemProvider)EMERALD, 4).result((IItemProvider)Items.field_151148_bJ, 1).givenXP(15).build()}, (Object)4, (Object)new VillagerTrades.ITrade[]{new SingleTrade.Builder().item((IItemProvider)EMERALD, 10).result((IItemProvider)Items.field_151057_cb, 1).givenXP(20).build(), new SingleTrade.Builder().item((IItemProvider)EMERALD, 6).result((IItemProvider)Items.field_151141_av, 1).givenXP(20).build(), new SingleTrade.Builder().item((IItemProvider)EMERALD, 1).result((IItemProvider)Items.field_151043_k, 6).givenXP(20).build()}, (Object)5, (Object)new VillagerTrades.ITrade[]{new SingleTrade.Builder().item((IItemProvider)EMERALD, 8).result((IItemProvider)SkiesBlocks.bag_of_spoils, 1).givenXP(25).build()}));
    public static final Int2ObjectMap<VillagerTrades.ITrade[]> SUMMONER_OFFERS = SkiesVillagerTrades.getAsIntMap((ImmutableMap<Integer, VillagerTrades.ITrade[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ITrade[]{new SingleTrade.Builder().item((IItemProvider)EMERALD, 1).result((IItemProvider)Items.field_151122_aG, 8).givenXP(5).build(), new SingleTrade.Builder().item((IItemProvider)SkiesItems.bug_guts, 32).result((IItemProvider)EMERALD, 1).build()}, (Object)2, (Object)new VillagerTrades.ITrade[]{new SingleTrade.Builder().item((IItemProvider)EMERALD, 1).result((IItemProvider)SkiesItems.pearl, 3).givenXP(13).build(), new SingleTrade.Builder().item((IItemProvider)SkiesItems.soul_fragment, 22).result((IItemProvider)EMERALD, 1).givenXP(10).build()}, (Object)3, (Object)new VillagerTrades.ITrade[]{new SingleTrade.Builder().item((IItemProvider)Items.field_151070_bp, 26).result((IItemProvider)EMERALD, 1).givenXP(15).build(), new SingleTrade.Builder().item((IItemProvider)Items.field_151078_bh, 46).result((IItemProvider)EMERALD, 1).givenXP(15).build()}, (Object)4, (Object)new VillagerTrades.ITrade[]{new SingleTrade.Builder().item((IItemProvider)Items.field_179556_br, 6).result((IItemProvider)EMERALD, 1).givenXP(25).build(), new SingleTrade.Builder().item((IItemProvider)SkiesItems.fox_pelt, 22).result((IItemProvider)EMERALD, 1).givenXP(20).build()}, (Object)5, (Object)new VillagerTrades.ITrade[]{new SingleTrade.Builder().item((IItemProvider)SkiesItems.summoning_tome, 1).result((IItemProvider)EMERALD, 6).givenXP(25).build()}));
    public static final Int2ObjectMap<VillagerTrades.ITrade[]> ALCHEMIST_OFFERS = SkiesVillagerTrades.getAsIntMap((ImmutableMap<Integer, VillagerTrades.ITrade[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ITrade[]{new DoubleTrade.Builder().firstItem((IItemProvider)EMERALD, 1).secondItem((IItemProvider)Items.field_151064_bs, 3).result((IItemProvider)Items.field_151123_aH, 3).build(), new SingleTrade.Builder().item((IItemProvider)Items.field_151043_k, 8).result((IItemProvider)EMERALD, 1).givenXP(5).maxUses(5).build(), new SingleTrade.Builder().item((IItemProvider)EMERALD, 1).result((IItemProvider)Items.field_151072_bj, 3).givenXP(5).build(), new DoubleTrade.Builder().firstItem((IItemProvider)EMERALD, 1).secondItem((IItemProvider)SkiesBlocks.midnight_sandstone, 16).result((IItemProvider)SkiesBlocks.crystal_sandstone, 16).build(), new DoubleTrade.Builder().firstItem((IItemProvider)EMERALD, 1).secondItem((IItemProvider)SkiesBlocks.crystal_sandstone, 16).result((IItemProvider)SkiesBlocks.midnight_sandstone, 16).build()}, (Object)2, (Object)new VillagerTrades.ITrade[]{new DoubleTrade.Builder().firstItem((IItemProvider)SkiesBlocks.lunar_sapling, 1).secondItem((IItemProvider)SkiesItems.crescent_fruit, 3).result((IItemProvider)SkiesBlocks.crescent_fruit_sapling, 1).givenXP(10).build(), new DoubleTrade.Builder().firstItem((IItemProvider)SkiesBlocks.lunar_dirt, 6).secondItem((IItemProvider)SkiesItems.ventium_water_bucket, 1).result((IItemProvider)SkiesBlocks.lunar_mud, 6).givenXP(5).build(), new DoubleTrade.Builder().firstItem((IItemProvider)SkiesItems.camel_saddle, 1).secondItem((IItemProvider)EMERALD, 1).result((IItemProvider)Items.field_151141_av, 1).givenXP(10).build(), new DoubleTrade.Builder().firstItem((IItemProvider)SkiesItems.horizonite_ingot, 3).secondItem((IItemProvider)SkiesItems.ventium_water_bucket, 1).result((IItemProvider)Items.field_151042_j, 3).givenXP(10).maxUses(15).build()}, (Object)3, (Object)new VillagerTrades.ITrade[]{new SingleTrade.Builder().item((IItemProvider)Items.field_151133_ar, 1).result((IItemProvider)SkiesItems.ventium_bucket, 1).maxUses(3).givenXP(10).build(), new DoubleTrade.Builder().firstItem((IItemProvider)SkiesBlocks.lunar_planks, 16).secondItem((IItemProvider)SkiesBlocks.moonstone_crystal, 4).result((IItemProvider)SkiesBlocks.crystallized_planks, 16).givenXP(17).build()}, (Object)4, (Object)new VillagerTrades.ITrade[]{new DoubleTrade.Builder().firstItem((IItemProvider)SkiesBlocks.lunar_grass, 12).secondItem((IItemProvider)SkiesItems.moonstone_shard, 6).result((IItemProvider)SkiesBlocks.crystallized_grass, 12).givenXP(15).build(), new DoubleTrade.Builder().firstItem((IItemProvider)EMERALD, 15).secondItem((IItemProvider)SkiesItems.ventium_water_bucket, 1).result((IItemProvider)SkiesItems.ventium_lava_bucket, 1).givenXP(15).build()}, (Object)5, (Object)new VillagerTrades.ITrade[]{new SingleTrade.Builder().item((IItemProvider)SkiesItems.alchemy_scroll, 1).result((IItemProvider)EMERALD, 6).givenXP(25).build()}));
    public static final VillagerTrades.ITrade EVERBRIGHT_BLINDING_DUNGEON_OFFER = new EmeraldForMapTrade(8, SkiesStructures.EVERBRIGHT_BLINDING_DUNGEON.getStructure(), MapDecoration.Type.RED_X, 15, 5);
    public static final VillagerTrades.ITrade EVERDAWN_BLINDING_DUNGEON_OFFER = new EmeraldForMapTrade(8, SkiesStructures.EVERDAWN_BLINDING_DUNGEON.getStructure(), MapDecoration.Type.RED_X, 15, 5);
    public static final VillagerTrades.ITrade NATURE_DUNGEON_OFFER = new EmeraldForMapTrade(12, SkiesStructures.NATURE_DUNGEON.getStructure(), MapDecoration.Type.RED_X, 15, 5);
    public static final VillagerTrades.ITrade POISON_DUNGEON_OFFER = new EmeraldForMapTrade(12, SkiesStructures.POISON_DUNGEON.getStructure(), MapDecoration.Type.RED_X, 15, 5);

    public static Int2ObjectMap<VillagerTrades.ITrade[]> getAsIntMap(ImmutableMap<Integer, VillagerTrades.ITrade[]> tradeList) {
        return new Int2ObjectOpenHashMap(tradeList);
    }

    static /* synthetic */ Item access$000() {
        return EMERALD;
    }

    public static class KeyTrade
    extends DoubleTrade {
        public KeyTrade(Item itemGiven1, int itemGiven1Count, Item itemGiven2, int itemGiven2Count, Item key) {
            super(itemGiven1, itemGiven1Count, itemGiven2, itemGiven2Count, key, 1, 4, 1, null);
        }
    }

    static class StickForFalsiteTrade
    implements VillagerTrades.ITrade {
        private final int count;
        private final int maxUses;
        private final int xpValue;

        public StickForFalsiteTrade(int falsiteCount, int maxUses, int xpValue) {
            this.count = falsiteCount;
            this.maxUses = maxUses;
            this.xpValue = xpValue;
        }

        @Nullable
        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            List stickList = trader.field_70170_p.func_234923_W_().equals(SkiesDimensions.everbrightKey()) ? EVERBRIGHT_STICKS : (trader.field_70170_p.func_234923_W_().equals(SkiesDimensions.everdawnKey()) ? EVERDAWN_STICKS : Lists.newArrayList((Object[])new Item[]{Items.field_151055_y}));
            return new MerchantOffer(new ItemStack((IItemProvider)stickList.get(rand.nextInt(stickList.size())), 32), new ItemStack((IItemProvider)SkiesItems.falsite_ingot, this.count), this.maxUses, this.xpValue, 0.2f);
        }
    }

    static class ToolWithFalsiteTrade
    implements VillagerTrades.ITrade {
        private final int count;
        private final Item toolMaterial;
        private final Item toolItem;
        private final int maxUses;
        private final int xpValue;
        private final int enchantLevel;

        public ToolWithFalsiteTrade(int emeraldCount, Item toolMaterial, Item toolItem, int maxUses, int xpValue, int enchantLevel) {
            this.count = emeraldCount;
            this.toolMaterial = toolMaterial;
            this.toolItem = toolItem;
            this.maxUses = maxUses;
            this.xpValue = xpValue;
            this.enchantLevel = enchantLevel;
        }

        public ToolWithFalsiteTrade(int emeraldCount, Item toolMaterial, Item toolItem, int maxUses, int xpValue) {
            this(emeraldCount, toolMaterial, toolItem, maxUses, xpValue, 0);
        }

        @Nullable
        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            ItemStack itemstack = new ItemStack((IItemProvider)this.toolItem);
            List stickList = trader.field_70170_p.func_234923_W_().equals(SkiesDimensions.everbrightKey()) ? EVERBRIGHT_STICKS : (trader.field_70170_p.func_234923_W_().equals(SkiesDimensions.everdawnKey()) ? EVERDAWN_STICKS : Lists.newArrayList((Object[])new Item[]{Items.field_151055_y}));
            ToolUtils.setStickType(itemstack, (Item)stickList.get(rand.nextInt(stickList.size())));
            IFalsiteItem.applyFalsite(itemstack);
            if (this.enchantLevel > 0) {
                EnchantmentHelper.func_77504_a((Random)rand, (ItemStack)itemstack, (int)this.enchantLevel, (boolean)false);
            }
            return new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, this.count), new ItemStack((IItemProvider)this.toolMaterial), itemstack, this.maxUses, this.xpValue, 0.2f);
        }
    }

    static class EmeraldForMapTrade
    implements VillagerTrades.ITrade {
        private final int count;
        private final Structure<?> structureName;
        private final MapDecoration.Type mapDecorationType;
        private final int maxUses;
        private final int xpValue;

        public EmeraldForMapTrade(int count, Structure<?> structureName, MapDecoration.Type mapDecorationType, int maxUses, int xpValue) {
            this.count = count;
            this.structureName = structureName;
            this.mapDecorationType = mapDecorationType;
            this.maxUses = maxUses;
            this.xpValue = xpValue;
        }

        @Nullable
        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            if (!(trader.field_70170_p instanceof ServerWorld)) {
                return null;
            }
            ServerWorld serverworld = (ServerWorld)trader.field_70170_p;
            BlockPos blockpos = serverworld.func_241117_a_(this.structureName, trader.func_233580_cy_(), 100, true);
            if (blockpos != null) {
                ItemStack itemstack = FilledMapItem.func_195952_a((World)serverworld, (int)blockpos.func_177958_n(), (int)blockpos.func_177952_p(), (byte)2, (boolean)true, (boolean)true);
                FilledMapItem.func_226642_a_((ServerWorld)serverworld, (ItemStack)itemstack);
                MapData.func_191094_a((ItemStack)itemstack, (BlockPos)blockpos, (String)"+", (MapDecoration.Type)this.mapDecorationType);
                itemstack.func_200302_a((ITextComponent)new TranslationTextComponent("filled_map." + this.structureName.func_143025_a().toLowerCase(Locale.ROOT)));
                return new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, this.count), new ItemStack((IItemProvider)Items.field_151111_aL), itemstack, this.maxUses, this.xpValue, 0.2f);
            }
            return null;
        }
    }

    public static class DoubleTrade
    implements VillagerTrades.ITrade {
        private final ItemStack itemGiven1;
        private final int itemGiven1Count;
        private final ItemStack itemGiven2;
        private final int itemGiven2Count;
        private final ItemStack itemSold;
        private final int soldItemCount;
        private final int maxUses;
        private final int givenXP;
        private final float priceMultiplier;
        private final ResourceLocation allowedDim;

        public DoubleTrade(Item itemGiven1, int itemGiven1Count, Item itemGiven2, int itemGiven2Count, Item soldItem, int soldItemCount, int maxUsesIn, int givenXPIn, ResourceLocation allowedDim) {
            this(new ItemStack((IItemProvider)itemGiven1), itemGiven1Count, new ItemStack((IItemProvider)itemGiven2), itemGiven2Count, new ItemStack((IItemProvider)soldItem), soldItemCount, maxUsesIn, givenXPIn, allowedDim);
        }

        public DoubleTrade(ItemStack itemGiven1In, int itemGiven1CountIn, ItemStack itemGiven2In, int itemGiven2CountIn, ItemStack itemSoldIn, int itemSoldCountIn, int maxUsesIn, int givenXPIn, ResourceLocation allowedDim) {
            this.itemGiven1 = itemGiven1In;
            this.itemGiven1Count = itemGiven1CountIn;
            this.itemGiven2 = itemGiven2In;
            this.itemGiven2Count = itemGiven2CountIn;
            this.itemSold = itemSoldIn;
            this.soldItemCount = itemSoldCountIn;
            this.maxUses = maxUsesIn;
            this.givenXP = givenXPIn;
            this.priceMultiplier = 0.05f;
            this.allowedDim = allowedDim;
        }

        public MerchantOffer func_221182_a(Entity entity, Random rand) {
            if (this.allowedDim != null && !entity.field_70170_p.func_234923_W_().func_240901_a_().equals((Object)this.allowedDim)) {
                return null;
            }
            return new MerchantOffer(new ItemStack((IItemProvider)this.itemGiven1.func_77973_b(), this.itemGiven1Count), new ItemStack((IItemProvider)this.itemGiven2.func_77973_b(), this.itemGiven2Count), new ItemStack((IItemProvider)this.itemSold.func_77973_b(), this.soldItemCount), this.maxUses, this.givenXP, this.priceMultiplier);
        }

        public static class Builder {
            private Item itemGiven1 = Items.field_151015_O;
            private int itemGiven1Count = 1;
            private Item itemGiven2 = SkiesVillagerTrades.access$000();
            private int itemGiven2Count = 1;
            private Item itemSold = Items.field_151025_P;
            private int itemSoldCount = 1;
            private int maxUses = 12;
            private int givenXP = 3;
            private ResourceLocation allowedDim = null;

            public Builder firstItem(IItemProvider item, int count) {
                this.itemGiven1 = item.func_199767_j();
                this.itemGiven1Count = count;
                return this;
            }

            public Builder secondItem(IItemProvider item, int count) {
                this.itemGiven2 = item.func_199767_j();
                this.itemGiven2Count = count;
                return this;
            }

            public Builder result(IItemProvider item, int count) {
                this.itemSold = item.func_199767_j();
                this.itemSoldCount = count;
                return this;
            }

            public Builder maxUses(int maxUses) {
                this.maxUses = maxUses;
                return this;
            }

            public Builder givenXP(int givenXp) {
                this.givenXP = givenXp;
                return this;
            }

            public Builder allowedDim(ResourceLocation dim) {
                this.allowedDim = dim;
                return this;
            }

            public DoubleTrade build() {
                return new DoubleTrade(this.itemGiven1, this.itemGiven1Count, this.itemGiven2, this.itemGiven2Count, this.itemSold, this.itemSoldCount, this.maxUses, this.givenXP, this.allowedDim);
            }
        }
    }

    public static class SingleTrade
    implements VillagerTrades.ITrade {
        private final ItemStack itemGiven1;
        private final int itemGiven1Count;
        private final ItemStack itemSold;
        private final int soldItemCount;
        private final int maxUses;
        private final int givenXP;
        private final float priceMultiplier;
        private final ResourceLocation allowedDim;

        public SingleTrade(Item itemGiven1, int itemGiven1Count, Item soldItem, int soldItemCount, int maxUses, int givenXP, ResourceLocation allowedDim) {
            this(new ItemStack((IItemProvider)itemGiven1), itemGiven1Count, new ItemStack((IItemProvider)soldItem), soldItemCount, maxUses, givenXP, allowedDim);
        }

        public SingleTrade(ItemStack itemGiven1In, int itemGiven1CountIn, ItemStack itemSoldIn, int itemSoldCountIn, int maxUsesIn, int givenXPIn, ResourceLocation allowedDim) {
            this.itemGiven1 = itemGiven1In;
            this.itemGiven1Count = itemGiven1CountIn;
            this.itemSold = itemSoldIn;
            this.soldItemCount = itemSoldCountIn;
            this.maxUses = maxUsesIn;
            this.givenXP = givenXPIn;
            this.priceMultiplier = 0.05f;
            this.allowedDim = allowedDim;
        }

        public MerchantOffer func_221182_a(Entity entity, Random rand) {
            if (this.allowedDim != null && !entity.field_70170_p.func_234923_W_().func_240901_a_().equals((Object)this.allowedDim)) {
                return null;
            }
            return new MerchantOffer(new ItemStack((IItemProvider)this.itemGiven1.func_77973_b(), this.itemGiven1Count), new ItemStack((IItemProvider)this.itemSold.func_77973_b(), this.soldItemCount), this.maxUses, this.givenXP, this.priceMultiplier);
        }

        public static class Builder {
            private Item itemGiven1 = SkiesVillagerTrades.access$000();
            private int itemGiven1Count = 1;
            private Item itemSold = Items.field_151025_P;
            private int itemSoldCount = 1;
            private int maxUses = 12;
            private int givenXP = 3;
            private ResourceLocation allowedDim = null;

            public Builder item(IItemProvider item, int count) {
                this.itemGiven1 = item.func_199767_j();
                this.itemGiven1Count = count;
                return this;
            }

            public Builder result(IItemProvider item, int count) {
                this.itemSold = item.func_199767_j();
                this.itemSoldCount = count;
                return this;
            }

            public Builder maxUses(int maxUses) {
                this.maxUses = maxUses;
                return this;
            }

            public Builder givenXP(int givenXp) {
                this.givenXP = givenXp;
                return this;
            }

            public Builder allowedDim(ResourceLocation dim) {
                this.allowedDim = dim;
                return this;
            }

            public SingleTrade build() {
                return new SingleTrade(this.itemGiven1, this.itemGiven1Count, this.itemSold, this.itemSoldCount, this.maxUses, this.givenXP, this.allowedDim);
            }
        }
    }
}

