/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.util.base;

import com.legacy.blue_skies.data.objects.SkiesBlockTags;
import com.legacy.blue_skies.entities.hostile.boss.summons.ArtificialGolemEntity;
import com.legacy.blue_skies.entities.hostile.boss.summons.DecayingSpikeEntity;
import com.legacy.blue_skies.entities.util.interfaces.ISkyBoss;
import com.legacy.blue_skies.network.PacketHandler;
import com.legacy.blue_skies.network.s_to_c.BossTypePacket;
import com.legacy.blue_skies.network.s_to_c.IllagerTeleportPacket;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.tile_entity.KeystoneTileEntity;
import com.legacy.blue_skies.util.EntityUtil;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SpellcastingIllagerEntity;
import net.minecraft.entity.monster.VexEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.FireworkRocketEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IExtensibleEnum;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.apache.commons.lang3.tuple.Pair;

public abstract class SkiesIllagerBossEntity
extends SpellcastingIllagerEntity
implements ISkyBoss {
    public static final DataParameter<Boolean> DUNGEON_SPAWNED = EntityDataManager.func_187226_a(SkiesIllagerBossEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> INVULNERABILITY_TIME = EntityDataManager.func_187226_a(SkiesIllagerBossEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> BOSS_SPELL_ID = EntityDataManager.func_187226_a(SkiesIllagerBossEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Boolean> RESPAWNED = EntityDataManager.func_187226_a(SkiesIllagerBossEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Byte> DIFFICULTY_ID = EntityDataManager.func_187226_a(SkiesIllagerBossEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private BossSpellColor activeBossSpell = BossSpellColor.NONE;
    private final ServerBossInfo bossInfo = this.getNewBossInfo();
    protected BlockPos homePos;
    private int teleportCooldown;
    private static final Vector3i RANGED_GOLEM_SPELL_COLOR = new Vector3i(155, 225, 156);
    private static final Vector3i GOLEM_SPELL_COLOR = new Vector3i(146, 244, 244);
    private static final Vector3i SPHERE_SPELL_COLOR = new Vector3i(51, 53, 94);
    private static final Vector3i ROCKS_SPELL_COLOR = new Vector3i(183, 119, 255);
    private static final Vector3i ARROW_SPELL_COLOR = new Vector3i(177, 157, 106);
    private static final Vector3i POISON_SPELL_COLOR = new Vector3i(59, 123, 49);
    private static final Vector3i HARMING_SPELL_COLOR = new Vector3i(67, 10, 9);
    private static final Vector3i WATER_SPELL_COLOR = new Vector3i(88, 123, 176);
    private static final Vector3i LAVA_SPELL_COLOR = new Vector3i(216, 118, 33);
    private static final Vector3i BLINDNESS_SPELL_COLOR = new Vector3i(31, 31, 35);
    public static final Vector3i REGEN_SPELL_COLOR = new Vector3i(255, 162, 224);

    public SkiesIllagerBossEntity(EntityType<? extends SkiesIllagerBossEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 30;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new DoNothingGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new CastingSpellGoal());
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DUNGEON_SPAWNED, (Object)false);
        this.field_70180_af.func_187214_a(INVULNERABILITY_TIME, (Object)0);
        this.field_70180_af.func_187214_a(BOSS_SPELL_ID, (Object)0);
        this.field_70180_af.func_187214_a(RESPAWNED, (Object)false);
        this.field_70180_af.func_187214_a(DIFFICULTY_ID, (Object)1);
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        ILivingEntityData flag = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setBossCanJoinRaid(reason == SpawnReason.SPAWN_EGG || reason == SpawnReason.COMMAND);
        if (reason == SpawnReason.TRIGGERED) {
            this.field_70170_p.func_175655_b(this.func_233580_cy_(), false);
            this.field_70170_p.func_175655_b(this.func_233580_cy_().func_177984_a(), false);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.defaultSpawningRoutine(difficultyIn);
        }
        return flag;
    }

    @Override
    public ServerBossInfo getBossInfo() {
        return this.bossInfo;
    }

    public abstract BlockState getFloorState();

    @OnlyIn(value=Dist.CLIENT)
    public abstract void healthParticles();

    @Override
    public float getMaxReach() {
        return 3.5f;
    }

    public void func_70020_e(CompoundNBT compound) {
        super.func_70020_e(compound);
        this.readDefaultBossNBT(compound);
        this.setBossSpellID(compound.func_74762_e("BossSpellId"));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        this.writeDefaultBossNBT(compound);
        compound.func_74768_a("BossSpellId", this.getBossSpellID());
    }

    public void func_213315_a(MoverType type, Vector3d vec) {
        super.func_213315_a(type, this.getInvulTime() > 0 ? new Vector3d(0.0, vec.field_72448_b, 0.0) : vec);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.bossTick();
        this.func_174829_m();
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70146_Z.nextDouble() > 0.7) {
                this.healthParticles();
            }
            if (this.func_193082_dl()) {
                float f = this.field_70761_aq * ((float)Math.PI / 180) + MathHelper.func_76134_b((float)((float)this.field_70173_aa * 0.6662f)) * 0.25f;
                float f1 = MathHelper.func_76134_b((float)f);
                float f2 = MathHelper.func_76126_a((float)f);
                double d0 = (double)this.getBossSpellType().colorVec.func_177958_n() / 255.0;
                double d1 = (double)this.getBossSpellType().colorVec.func_177956_o() / 255.0;
                double d2 = (double)this.getBossSpellType().colorVec.func_177952_p() / 255.0;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, this.func_226277_ct_() + (double)f1 * 0.6, this.func_226278_cu_() + 1.8, this.func_226281_cx_() + (double)f2 * 0.6, d0, d1, d2);
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, this.func_226277_ct_() - (double)f1 * 0.6, this.func_226278_cu_() + 1.8, this.func_226281_cx_() - (double)f2 * 0.6, d0, d1, d2);
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            List playerCount;
            if (this.func_70090_H() || this.func_180799_ab()) {
                this.teleportAround();
                this.teleportCooldown = 0;
            }
            if (this.isDungeonSpawned() && !this.func_175446_cd()) {
                PlayerEntity player;
                if (this.getHome() != null) {
                    this.checkIfHome();
                }
                if (this.func_70638_az() instanceof PlayerEntity && !(player = (PlayerEntity)this.func_70638_az()).func_70089_S()) {
                    this.func_70634_a(this.getHome().func_177958_n(), this.getHome().func_177956_o(), this.getHome().func_177952_p());
                }
                ++this.teleportCooldown;
            }
            if (this.func_70638_az() != null && ((playerCount = this.field_70170_p.func_217357_a(PlayerEntity.class, this.func_174813_aQ().func_186662_g(4.0))).size() > 0 && this.func_70638_az() instanceof PlayerEntity || (double)this.func_70032_d((Entity)this.func_70638_az()) <= 5.0)) {
                this.teleportAround();
            }
        }
    }

    public void func_70645_a(DamageSource source) {
        super.func_70645_a(source);
        this.onBossDeath(source);
        if (!this.field_70170_p.field_72995_K && this.isDungeonSpawned() && this.getHome() != null) {
            this.field_70170_p.func_180501_a(this.getHome().func_177984_a(), this.isEverbrightBoss() ? SkiesBlocks.bright_blinding_keystone.func_176223_P() : SkiesBlocks.dawn_blinding_keystone.func_176223_P(), 2);
            this.field_70170_p.func_175656_a(this.getHome(), SkiesBlocks.blinding_stone.func_176223_P());
            TileEntity keystone = this.field_70170_p.func_175625_s(this.getHome().func_177984_a());
            if (keystone instanceof KeystoneTileEntity) {
                ((KeystoneTileEntity)keystone).setTeleportOffset(new BlockPos(0, -9, 5));
                ((KeystoneTileEntity)keystone).setSpawnsBoss(false);
                ((KeystoneTileEntity)keystone).setKeysRequired(false);
            }
        }
        FireworkRocketEntity fireworkrocketentity = new FireworkRocketEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), EntityUtil.makeFirework((DyeColor)this.getFireworkColors().getLeft(), 0, (DyeColor)this.getFireworkColors().getRight()));
        this.field_70170_p.func_217376_c((Entity)fireworkrocketentity);
    }

    public abstract Pair<DyeColor, DyeColor> getFireworkColors();

    protected void func_70619_bc() {
        if (this.getInvulTime() <= 0) {
            super.func_70619_bc();
            if (this.func_70638_az() == null && this.isDungeonSpawned() && this.teleportCooldown >= 40 && this.field_70146_Z.nextFloat() * 120.0f < 4.6f) {
                this.teleportAround();
                this.teleportCooldown = 0;
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source) || this.getInvulTime() > 0 && source != DamageSource.field_76380_i || source == DamageSource.field_180137_b || source.func_76352_a() && source.func_76346_g() == this) {
            return false;
        }
        if (source.func_76352_a() && (source.func_76346_g() instanceof SpellcastingIllagerEntity || source.func_76346_g() instanceof ArtificialGolemEntity) || source.func_76352_a() && !this.func_193082_dl()) {
            if (this.field_70170_p.field_72995_K) {
                return false;
            }
            this.teleportAround();
            return false;
        }
        if (source.func_76364_f() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)source.func_76364_f();
            ItemStack stack = player.field_71071_by.func_70448_g();
            if (source.func_180136_u()) {
                return super.func_70097_a(source, amount);
            }
            if (stack.func_77973_b() == SkiesItems.debug_sword) {
                return false;
            }
            if ((source.func_76352_a() || source.func_82725_o()) && source.func_76346_g() == null || !source.func_76352_a() && source.func_76346_g() != null && source.func_76346_g().func_70032_d((Entity)this) > 3.55f) {
                return false;
            }
            return super.func_70097_a(source, Math.min((float)this.getDamageCap(), amount));
        }
        return super.func_70097_a(source, amount);
    }

    public void teleportAround() {
        this.field_70133_I = true;
        if (this.field_70170_p.field_72995_K || this.func_193082_dl()) {
            return;
        }
        if (this.getInvulTime() <= 0) {
            double d0 = this.func_226277_ct_();
            double d1 = this.func_226278_cu_();
            double d2 = this.func_226281_cx_();
            double teleportStartX = this.isDungeonSpawned() ? (double)this.getHome().func_177958_n() : this.func_226277_ct_();
            double teleportStartY = this.isDungeonSpawned() ? (double)this.getHome().func_177956_o() : this.func_226278_cu_();
            double teleportStartZ = this.isDungeonSpawned() ? (double)this.getHome().func_177952_p() : this.func_226281_cx_();
            for (int i = 0; i < 24; ++i) {
                boolean canTeleport;
                double d3 = teleportStartX + (this.func_70681_au().nextDouble() - 0.5) * 15.0;
                double d4 = MathHelper.func_151237_a((double)(teleportStartY + (double)(this.func_70681_au().nextInt(16) - 8)), (double)0.0, (double)(this.field_70170_p.func_217301_I() - 1));
                double d5 = teleportStartZ + (this.func_70681_au().nextDouble() - 0.5) * 15.0;
                if (this.func_184187_bx() != null) {
                    this.func_184210_p();
                }
                boolean bl = canTeleport = this.isDungeonSpawned() ? this.attemptDungeonTeleport(d3, Math.floor(d4), d5) : this.func_213373_a(d3, Math.floor(d4), d5, true);
                if (!canTeleport) continue;
                this.field_70170_p.func_184148_a((PlayerEntity)null, d0, d1, d2, SoundEvents.field_187544_ad, SoundCategory.HOSTILE, 1.0f, 1.0f);
                this.func_184185_a(SoundEvents.field_187544_ad, 1.0f, 1.0f);
                this.func_70656_aK();
                this.func_233577_ch_();
                this.field_70133_I = true;
                break;
            }
        }
    }

    public boolean attemptDungeonTeleport(double x, double y, double z) {
        double d0 = this.func_226277_ct_();
        double d1 = this.func_226278_cu_();
        double d2 = this.func_226281_cx_();
        double d3 = y;
        boolean flag = false;
        World world = this.field_70170_p;
        BlockPos blockpos = new BlockPos(x, y, z);
        if (world.func_175667_e(blockpos)) {
            boolean shouldCompleteTeleport = false;
            while (!shouldCompleteTeleport && blockpos.func_177956_o() > 0) {
                BlockPos blockpos1 = blockpos.func_177977_b();
                BlockState blockstate = world.func_180495_p(blockpos1);
                AxisAlignedBB bounds = new AxisAlignedBB(blockpos).func_72314_b(0.5, 0.0, 0.5);
                if (SkiesBlockTags.ILLAGER_TELEPORTABLE.func_230235_a_((Object)blockstate.func_177230_c()) && this.field_70170_p.func_217366_a((double)blockpos1.func_177958_n(), (double)blockpos1.func_177956_o(), (double)blockpos1.func_177952_p(), 6.0, true) == null && blockstate.func_185904_a().func_76230_c() && this.field_70170_p.func_226664_a_(bounds) && !world.func_72953_d(bounds)) {
                    shouldCompleteTeleport = true;
                    continue;
                }
                d3 -= 1.0;
                blockpos = blockpos1;
            }
            if (shouldCompleteTeleport) {
                BlockPos teleportationPos = new BlockPos(x, d3, z);
                this.func_70634_a(teleportationPos.func_177958_n(), teleportationPos.func_177956_o(), teleportationPos.func_177952_p());
                flag = true;
                if (flag) {
                    this.getPlayersInDungeonArea().forEach(player -> {
                        if (player instanceof ServerPlayerEntity) {
                            PacketHandler.sendToClient(new IllagerTeleportPacket(this.func_145782_y(), teleportationPos), (ServerPlayerEntity)player);
                        }
                    });
                }
                this.func_233577_ch_();
                this.field_70133_I = true;
                ObfuscationReflectionHelper.setPrivateValue(Entity.class, (Object)this, (Object)true, (String)"field_184237_aG");
                this.func_213315_a(MoverType.SELF, Vector3d.field_186680_a);
            }
        }
        if (!flag) {
            this.func_70634_a(d0, d1, d2);
            return false;
        }
        for (int j = 0; j < 128; ++j) {
            double d6 = (double)j / 127.0;
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            double d7 = d0 + (this.func_226277_ct_() - d0) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf() * 2.0;
            double d8 = d1 + (this.func_226278_cu_() - d1) * d6 + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg();
            double d9 = d2 + (this.func_226281_cx_() - d2) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf() * 2.0;
            world.func_195594_a((IParticleData)ParticleTypes.field_197613_f, d7, d8, d9, (double)f, (double)f1, (double)f2);
        }
        if (this instanceof CreatureEntity) {
            this.func_70661_as().func_75499_g();
        }
        return true;
    }

    public boolean func_184191_r(Entity entityIn) {
        if (entityIn == null) {
            return false;
        }
        if (entityIn instanceof VexEntity) {
            return this.func_184191_r((Entity)((VexEntity)entityIn).func_190645_o());
        }
        if (entityIn instanceof DecayingSpikeEntity) {
            return this.func_184191_r((Entity)((DecayingSpikeEntity)entityIn).getCaster());
        }
        if (entityIn instanceof ArtificialGolemEntity) {
            return this.func_184191_r((Entity)((ArtificialGolemEntity)entityIn).getCaster());
        }
        if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).func_70668_bt() == CreatureAttribute.field_223225_d_) {
            return this.func_96124_cp() == null && entityIn.func_96124_cp() == null;
        }
        return super.func_184191_r(entityIn) || entityIn == this;
    }

    public void checkIfHome() {
        int distance = 17;
        if (EntityUtil.getDistanceToPos((Vector3i)this.func_233580_cy_(), (Vector3i)this.getHome()) >= (float)distance) {
            this.func_70634_a(this.getHome().func_177958_n(), this.getHome().func_177956_o(), this.getHome().func_177952_p());
            this.func_184185_a(SoundEvents.field_193788_dg, 1.0f, 1.0f);
            this.func_70656_aK();
            this.field_70170_p.func_175656_a(this.getHome().func_177977_b(), this.getFloorState());
        }
    }

    public void setBossSpellType(BossSpellColor spellType) {
        this.activeBossSpell = spellType;
        this.setBossSpellID(spellType.id);
    }

    protected BossSpellColor getBossSpellType() {
        return !this.field_70170_p.field_72995_K ? this.activeBossSpell : BossSpellColor.getFromId((Integer)this.field_70180_af.func_187225_a(BOSS_SPELL_ID));
    }

    public void func_213644_t(boolean canJoinIn) {
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    public void func_213660_a(int p_213660_1_, boolean p_213660_2_) {
    }

    public void setBossCanJoinRaid(boolean canJoinIn) {
        super.func_213644_t(canJoinIn);
    }

    public boolean func_213392_I() {
        return true;
    }

    public boolean secondPhaseHealth() {
        return this.func_110143_aJ() <= this.func_110138_aP() / 2.0f;
    }

    @Override
    public int getExtraPlayers() {
        return Math.max(0, this.getPlayersInDungeonArea().size() - 1);
    }

    public void func_200203_b(ITextComponent name) {
        super.func_200203_b(name);
        this.getBossInfo().func_186739_a((ITextComponent)this.func_145748_c_().func_230531_f_().func_230529_a_(ISkyBoss.getDifficultyDecoration(this.getDifficultyID())));
    }

    @Override
    public BlockPos getHome() {
        if (this.homePos != null && !this.homePos.equals((Object)BlockPos.field_177992_a)) {
            return this.homePos;
        }
        return this.func_233580_cy_();
    }

    @Override
    public boolean isDungeonSpawned() {
        return (Boolean)this.field_70180_af.func_187225_a(DUNGEON_SPAWNED);
    }

    @Override
    public void setDungeonSpawned(boolean isDungeonSpawned) {
        this.field_70180_af.func_187227_b(DUNGEON_SPAWNED, (Object)isDungeonSpawned);
    }

    @Override
    public void setHome(BlockPos pos) {
        this.homePos = pos;
    }

    @Override
    public int getInvulTime() {
        return (Integer)this.field_70180_af.func_187225_a(INVULNERABILITY_TIME);
    }

    @Override
    public void setInvulTime(int time) {
        this.field_70180_af.func_187227_b(INVULNERABILITY_TIME, (Object)time);
    }

    public int getBossSpellID() {
        return (Integer)this.field_70180_af.func_187225_a(BOSS_SPELL_ID);
    }

    public void setBossSpellID(int id) {
        this.field_70180_af.func_187227_b(BOSS_SPELL_ID, (Object)id);
    }

    @Override
    public byte getDifficultyID() {
        return (Byte)this.field_70180_af.func_187225_a(DIFFICULTY_ID);
    }

    @Override
    public void setDifficultyID(byte id) {
        this.field_70180_af.func_187227_b(DIFFICULTY_ID, (Object)((byte)Math.min(3, id)));
    }

    @Override
    public boolean isBossRespawned() {
        return (Boolean)this.field_70180_af.func_187225_a(RESPAWNED);
    }

    @Override
    public void setBossRespawned(boolean isRespawned) {
        this.field_70180_af.func_187227_b(RESPAWNED, (Object)isRespawned);
    }

    public void func_184178_b(ServerPlayerEntity player) {
        PacketHandler.sendToClient(new BossTypePacket((byte)this.getBossType().getId()), player);
        super.func_184178_b(player);
        this.getBossInfo().func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.getBossInfo().func_186761_b(player);
    }

    public boolean isAwayFromPlayers() {
        PlayerEntity player = this.field_70170_p.func_217366_a((double)this.func_233580_cy_().func_177958_n(), (double)this.func_233580_cy_().func_177956_o(), (double)this.func_233580_cy_().func_177952_p(), 5.0, true);
        return this.func_70638_az() != null && (double)this.func_70032_d((Entity)this.func_70638_az()) >= 5.0 && player == null || player == null;
    }

    public boolean func_213630_eb() {
        return super.func_213630_eb() && !this.isDungeonSpawned();
    }

    @Override
    public MonsterEntity getBoss() {
        return this;
    }

    static /* synthetic */ Vector3i access$200() {
        return GOLEM_SPELL_COLOR;
    }

    static /* synthetic */ Vector3i access$300() {
        return RANGED_GOLEM_SPELL_COLOR;
    }

    static /* synthetic */ Vector3i access$400() {
        return SPHERE_SPELL_COLOR;
    }

    static /* synthetic */ Vector3i access$500() {
        return ROCKS_SPELL_COLOR;
    }

    static /* synthetic */ Vector3i access$600() {
        return ARROW_SPELL_COLOR;
    }

    static /* synthetic */ Vector3i access$700() {
        return POISON_SPELL_COLOR;
    }

    static /* synthetic */ Vector3i access$800() {
        return HARMING_SPELL_COLOR;
    }

    static /* synthetic */ Vector3i access$900() {
        return WATER_SPELL_COLOR;
    }

    static /* synthetic */ Vector3i access$1000() {
        return LAVA_SPELL_COLOR;
    }

    static /* synthetic */ Vector3i access$1100() {
        return BLINDNESS_SPELL_COLOR;
    }

    public static enum BossSpellColor implements IExtensibleEnum
    {
        NONE(0, Vector3i.field_177959_e),
        REGENERATION(1, REGEN_SPELL_COLOR),
        SUMMON_GOLEM(2, SkiesIllagerBossEntity.access$200()),
        SUMMON_RANGED_GOLEM(3, SkiesIllagerBossEntity.access$300()),
        SPHERE(4, SkiesIllagerBossEntity.access$400()),
        ROCKS(5, SkiesIllagerBossEntity.access$500()),
        ARROW_BUNDLE(6, SkiesIllagerBossEntity.access$600()),
        POISON_CLOUD(7, SkiesIllagerBossEntity.access$700()),
        HARMING_CLOUD(8, SkiesIllagerBossEntity.access$800()),
        WATER(9, SkiesIllagerBossEntity.access$900()),
        LAVA(10, SkiesIllagerBossEntity.access$1000()),
        BLINDNESS(11, SkiesIllagerBossEntity.access$1100());

        public final Vector3i colorVec;
        public final int id;

        private BossSpellColor(int id, Vector3i colorVec) {
            this.colorVec = colorVec;
            this.id = id;
        }

        public static BossSpellColor getFromId(int idIn) {
            for (BossSpellColor bossTypes : BossSpellColor.values()) {
                if (idIn != bossTypes.id) continue;
                return bossTypes;
            }
            return NONE;
        }

        public static BossSpellColor create(String enumName, int id, Vector3i colorVec) {
            throw new IllegalStateException("Enum not extended");
        }
    }

    public abstract class UseBossSpellGoal
    extends SpellcastingIllagerEntity.UseSpellGoal {
        protected UseBossSpellGoal() {
            super((SpellcastingIllagerEntity)SkiesIllagerBossEntity.this);
        }

        protected abstract BossSpellColor getSpellColor();

        public void func_75249_e() {
            super.func_75249_e();
            SkiesIllagerBossEntity.this.setBossSpellType(this.getSpellColor());
        }

        protected SpellcastingIllagerEntity.SpellType func_193320_l() {
            return SpellcastingIllagerEntity.SpellType.FANGS;
        }
    }

    class CastingSpellGoal
    extends SpellcastingIllagerEntity.CastingASpellGoal {
        private CastingSpellGoal() {
            super((SpellcastingIllagerEntity)SkiesIllagerBossEntity.this);
        }

        public void func_75249_e() {
            super.func_75249_e();
            List playersInDungeon = SkiesIllagerBossEntity.this.getPlayersInDungeonArea();
            for (PlayerEntity players : playersInDungeon) {
                if (players == SkiesIllagerBossEntity.this.func_70638_az() || !SkiesIllagerBossEntity.this.field_70146_Z.nextBoolean() || playersInDungeon.size() <= 1 || players.func_184812_l_() || players.func_175149_v()) continue;
                SkiesIllagerBossEntity.this.func_70624_b((LivingEntity)players);
            }
        }

        public void func_75246_d() {
            if (SkiesIllagerBossEntity.this.func_70638_az() != null) {
                SkiesIllagerBossEntity.this.func_70671_ap().func_75651_a((Entity)SkiesIllagerBossEntity.this.func_70638_az(), (float)SkiesIllagerBossEntity.this.func_184649_cE(), (float)SkiesIllagerBossEntity.this.func_70646_bf());
            }
        }
    }

    class DoNothingGoal
    extends Goal {
        public DoNothingGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return SkiesIllagerBossEntity.this.getInvulTime() > 0;
        }
    }
}

