/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.passive;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.registries.SkiesSounds;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.pattern.BlockStateMatcher;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class StardustRamEntity
extends SheepEntity {
    private EatSkyGrassGoal eatGrassGoal;

    public StardustRamEntity(EntityType<? extends StardustRamEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.eatGrassGoal = new EatSkyGrassGoal((MobEntity)this);
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 1.25, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{SkiesItems.pine_fruit}), false));
        this.field_70714_bg.func_75776_a(5, (Goal)this.eatGrassGoal);
    }

    protected void func_70619_bc() {
        this.setSheepTimer(this.eatGrassGoal.getEatAnimationTick());
        super.func_70619_bc();
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 16.0).func_233815_a_(Attributes.field_233821_d_, 0.23);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_70894_j(float partialTicks) {
        return super.func_70894_j(partialTicks);
    }

    public void setSheepTimer(int timer) {
        ObfuscationReflectionHelper.setPrivateValue(SheepEntity.class, (Object)((Object)this), (Object)timer, (String)"field_70899_e");
    }

    public int getSheepTimer() {
        return (Integer)ObfuscationReflectionHelper.getPrivateValue(SheepEntity.class, (Object)((Object)this), (String)"field_70899_e");
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == SkiesItems.pine_fruit;
    }

    protected SoundEvent func_184639_G() {
        return SkiesSounds.ENTITY_STARDUST_RAM_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SkiesSounds.ENTITY_STARDUST_RAM_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SkiesSounds.ENTITY_STARDUST_RAM_DEATH;
    }

    protected float func_70647_i() {
        return this.func_70631_g_() ? (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.3f : (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 0.8f;
    }

    public SheepEntity func_241840_a(ServerWorld worldIn, AgeableEntity ageable) {
        return (SheepEntity)SkiesEntityTypes.STARDUST_RAM.func_200721_a(this.field_70170_p);
    }

    public ResourceLocation func_184647_J() {
        if (this.func_70892_o()) {
            return this.func_200600_R().func_220348_g();
        }
        return BlueSkies.locate("entities/stardust_ram/" + this.func_175509_cj().toString());
    }

    static class EatSkyGrassGoal
    extends Goal {
        private static final Predicate<BlockState> IS_TALL_GRASS = BlockStateMatcher.func_177638_a((Block)SkiesBlocks.turquoise_grass);
        private final MobEntity mob;
        private final World level;
        private int eatAnimationTick;

        public EatSkyGrassGoal(MobEntity ram) {
            this.mob = ram;
            this.level = ram.field_70170_p;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean func_75250_a() {
            if (this.mob.func_70681_au().nextInt(this.mob.func_70631_g_() ? 50 : 1000) != 0) {
                return false;
            }
            BlockPos blockpos = this.mob.func_233580_cy_();
            if (IS_TALL_GRASS.test(this.level.func_180495_p(blockpos))) {
                return true;
            }
            return this.level.func_180495_p(blockpos.func_177977_b()).func_203425_a(SkiesBlocks.turquoise_grass_block);
        }

        public void func_75249_e() {
            this.eatAnimationTick = 40;
            this.level.func_72960_a((Entity)this.mob, (byte)10);
            this.mob.func_70661_as().func_75499_g();
        }

        public void func_75251_c() {
            this.eatAnimationTick = 0;
        }

        public boolean func_75253_b() {
            return this.eatAnimationTick > 0;
        }

        public int getEatAnimationTick() {
            return this.eatAnimationTick;
        }

        public void func_75246_d() {
            this.eatAnimationTick = Math.max(0, this.eatAnimationTick - 1);
            if (this.eatAnimationTick == 4) {
                BlockPos blockpos = this.mob.func_233580_cy_();
                if (IS_TALL_GRASS.test(this.level.func_180495_p(blockpos))) {
                    if (ForgeEventFactory.getMobGriefingEvent((World)this.level, (Entity)this.mob)) {
                        this.level.func_175655_b(blockpos, false);
                    }
                    this.mob.func_70615_aA();
                } else {
                    BlockPos blockpos1 = blockpos.func_177977_b();
                    if (this.level.func_180495_p(blockpos1).func_203425_a(SkiesBlocks.turquoise_grass_block)) {
                        if (ForgeEventFactory.getMobGriefingEvent((World)this.level, (Entity)this.mob)) {
                            this.level.func_217379_c(2001, blockpos1, Block.func_196246_j((BlockState)SkiesBlocks.turquoise_grass_block.func_176223_P()));
                            this.level.func_180501_a(blockpos1, SkiesBlocks.turquoise_dirt.func_176223_P(), 2);
                        }
                        this.mob.func_70615_aA();
                    }
                }
            }
        }
    }
}

