/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.passive;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.entities.util.base.SkiesAnimalEntity;
import com.legacy.blue_skies.registries.SkiesBiomes;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.util.BiomeUtil;
import com.legacy.structure_gel.util.GelCollectors;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class ShadeMonitorEntity
extends SkiesAnimalEntity {
    public static final Map<ResourceLocation, Biomes> EXISTING_BIOME_MAP = GelCollectors.mapOf(ResourceLocation.class, Biomes.class, (Object[])new Object[]{SkiesBiomes.SEARING_GRASSLAND.getName(), Biomes.SUNSET_MAPLE_FOREST, SkiesBiomes.CRYSTAL_DUNES_SPIKES.getName(), Biomes.CRYSTAL_DUNES});
    private static final DataParameter<Byte> BIOME = EntityDataManager.func_187226_a(ShadeMonitorEntity.class, (IDataSerializer)DataSerializers.field_187191_a);

    public ShadeMonitorEntity(EntityType<? extends ShadeMonitorEntity> type, World world) {
        super(type, world);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70714_bg.func_75776_a(1, (Goal)new LeapAtTargetGoal((MobEntity)this, 0.4f));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.5, true));
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 1.25, Ingredient.func_199805_a((ITag)ItemTags.field_206964_G), false));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 16.0).func_233815_a_(Attributes.field_233821_d_, (double)0.3f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BIOME, (Object)0);
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setBiome(Biomes.get(this.getBiomeKey()).getId());
        return spawnDataIn;
    }

    public ResourceLocation getBiomeKey() {
        return BiomeUtil.getKeyFromBiome((IWorld)this.field_70170_p, this.field_70170_p.func_226691_t_(this.func_233580_cy_())).func_240901_a_();
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74774_a("Biome", this.getBiome());
    }

    public void func_70020_e(CompoundNBT compound) {
        super.func_70020_e(compound);
        this.setBiome(compound.func_74771_c("Biome"));
    }

    public byte getBiome() {
        return (Byte)this.field_70180_af.func_187225_a(BIOME);
    }

    public void setBiome(byte biome) {
        this.field_70180_af.func_187227_b(BIOME, (Object)biome);
    }

    protected SoundEvent func_184639_G() {
        return SkiesSounds.ENTITY_SHADE_MONITOR_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SkiesSounds.ENTITY_SHADE_MONITOR_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SkiesSounds.ENTITY_SHADE_MONITOR_DEATH;
    }

    protected float func_70599_aP() {
        return 1.0f;
    }

    @Override
    public boolean func_70877_b(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item.func_219971_r() && item.func_219967_s().func_221467_c() || item.func_206844_a((ITag)ItemTags.field_206964_G);
    }

    public ShadeMonitorEntity createChild(AgeableEntity ageable) {
        byte biome = (double)this.field_70146_Z.nextFloat() < 0.05 ? Biomes.get(this.getBiomeKey()).getId() : (this.field_70146_Z.nextBoolean() ? ((ShadeMonitorEntity)ageable).getBiome() : this.getBiome());
        ShadeMonitorEntity child = (ShadeMonitorEntity)SkiesEntityTypes.SHADE_MONITOR.func_200721_a(this.field_70170_p);
        child.setBiome(biome);
        return child;
    }

    protected float func_213348_b(Pose pose, EntitySize size) {
        return this.func_70631_g_() ? 0.3f : 0.6f;
    }

    public boolean func_70652_k(Entity entityIn) {
        entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 2.0f);
        return true;
    }

    public static enum Biomes {
        OVERWORLD("overworld"),
        EVERBRIGHT("everbright"),
        UNORTHODOX_VALLEY(SkiesBiomes.UNORTHODOX_VALLEY.getName()),
        CRYSTAL_DUNES(SkiesBiomes.CRYSTAL_DUNES.getName()),
        CRYSTAL_ROUGHS(SkiesBiomes.CRYSTAL_ROUGHS.getName()),
        SUNSET_MAPLE_FOREST(SkiesBiomes.SUNSET_MAPLE_FOREST.getName()),
        SHADED_WOODLANDS(SkiesBiomes.SHADED_WOODLANDS.getName()),
        MOONLIT_RESERVOIR(SkiesBiomes.MOONLIT_RESERVOIR.getName());

        private final ResourceLocation biome;
        private final ResourceLocation texture;

        private Biomes(ResourceLocation biome) {
            this.biome = biome;
            this.texture = BlueSkies.locate(String.format("textures/entity/shade_monitor/shade_monitor_%s.png", this.biome.func_110623_a()));
        }

        private Biomes(String biome) {
            this.biome = null;
            this.texture = BlueSkies.locate(String.format("textures/entity/shade_monitor/shade_monitor_%s.png", biome));
        }

        public byte getId() {
            return (byte)this.ordinal();
        }

        @Nullable
        public ResourceLocation getBiome() {
            return this.biome;
        }

        public ResourceLocation getTexture() {
            return this.texture;
        }

        public static Biomes get(ResourceLocation biome) {
            for (Biomes b : Biomes.values()) {
                if (b.biome != biome) continue;
                return b;
            }
            if (EXISTING_BIOME_MAP.containsKey(biome)) {
                return EXISTING_BIOME_MAP.get(biome);
            }
            if (SkiesBiomes.EVERBRIGHT_LOCATIONS.contains(biome)) {
                return EVERBRIGHT;
            }
            if (SkiesBiomes.EVERDAWN_LOCATIONS.contains(biome)) {
                return UNORTHODOX_VALLEY;
            }
            return OVERWORLD;
        }

        public static Biomes byId(int id) {
            if (id < 0 || id >= Biomes.values().length) {
                id = 0;
            }
            return Biomes.values()[id];
        }
    }
}

