/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.passive;

import com.legacy.blue_skies.entities.util.base.SkiesMountEntity;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.util.EntityUtil;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class CrogreEntity
extends SkiesMountEntity {
    private float prevJumpAnim;
    private float jumpAnim;
    private float prevSwimAnim;
    private float swimAnim;
    private boolean playSwimAnim;

    public CrogreEntity(EntityType<? extends CrogreEntity> type, World worldIn) {
        super((EntityType<? extends SkiesMountEntity>)type, worldIn);
        this.field_70765_h = new MoveHelperController(this);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 1.25, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{this.getTameItem()}), false));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0){

            protected Vector3d func_190864_f() {
                return RandomPositionGenerator.func_191377_b((CreatureEntity)this.field_75457_a, (int)(this.field_75457_a.func_203005_aq() ? 60 : 40), (int)10);
            }
        });
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233821_d_, (double)0.3f);
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        return worldIn.func_226691_t_(pos) != null && worldIn.func_226691_t_(pos).func_201851_b() == Biome.RainType.RAIN ? 0.5f : 0.0f;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        if (distance > 10.0f) {
            return super.func_225503_b_(distance - 10.0f, damageMultiplier);
        }
        return false;
    }

    public double func_70042_X() {
        return (double)this.func_213302_cg() * 0.45;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.prevJumpAnim = this.jumpAnim;
            this.prevSwimAnim = this.swimAnim;
            this.jumpAnim = !this.func_175446_cd() && !this.func_203005_aq() && this.field_70703_bu && (this.func_213322_ci().func_82617_b() > 0.0 || this.func_184207_aI()) ? MathHelper.func_76131_a((float)(this.jumpAnim + 1.0f), (float)0.0f, (float)6.0f) : MathHelper.func_76131_a((float)(this.jumpAnim - 1.0f), (float)0.0f, (float)6.0f);
            this.swimAnim = this.playSwimAnim ? MathHelper.func_76131_a((float)(this.swimAnim + 1.0f), (float)0.0f, (float)6.0f) : MathHelper.func_76131_a((float)(this.swimAnim - 1.0f), (float)0.0f, (float)6.0f);
        } else if (!this.func_70661_as().func_75500_f()) {
            PathPoint path = this.func_70661_as().func_75505_d().func_75870_c();
            double d1 = (double)path.field_75839_a - this.func_226277_ct_();
            double d2 = (double)path.field_75838_c - this.func_226281_cx_();
            this.field_70177_z = -((float)MathHelper.func_181159_b((double)d1, (double)d2)) * 57.295776f;
        }
        if (!this.func_203005_aq()) {
            if (this.field_70122_E || this.func_184207_aI() && this.func_213322_ci().func_82617_b() < 0.0) {
                this.func_70637_d(false);
                this.field_70170_p.func_72960_a((Entity)this, (byte)5);
            } else {
                this.field_70170_p.func_72960_a((Entity)this, (byte)4);
            }
        }
        if (this.field_70173_aa % 20 == 10) {
            if (this.field_70703_bu && this.field_70122_E) {
                this.func_70637_d(false);
                this.field_70170_p.func_72960_a((Entity)this, (byte)5);
            }
            if (!this.func_203005_aq() || this.swimAnim >= 6.0f && this.prevSwimAnim >= 6.0f) {
                this.setCrogreSwimming(false);
            }
        }
    }

    public void func_70637_d(boolean jumping) {
        super.func_70637_d(jumping);
        if (jumping && !this.func_203005_aq() && !this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)10);
        }
    }

    public void setCrogreSwimming(boolean swimming) {
        if (swimming) {
            this.playSwimAnim = true;
            this.field_70170_p.func_72960_a((Entity)this, (byte)8);
        } else {
            this.playSwimAnim = false;
            this.field_70170_p.func_72960_a((Entity)this, (byte)9);
        }
    }

    protected SoundEvent func_184639_G() {
        return this.field_70170_p.func_175727_C(this.func_233580_cy_()) ? SkiesSounds.ENTITY_CROGRE_IDLE_HAPPY : SkiesSounds.ENTITY_CROGRE_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SkiesSounds.ENTITY_CROGRE_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SkiesSounds.ENTITY_CROGRE_DEATH;
    }

    @Override
    public AgeableEntity createChild(AgeableEntity ageable) {
        return (AgeableEntity)SkiesEntityTypes.CROGRE.func_200721_a(this.field_70170_p);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getJumpingAnimationScale(float pctIn) {
        return MathHelper.func_219799_g((float)pctIn, (float)this.prevJumpAnim, (float)this.jumpAnim) / 4.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getSwimmingAnimationScale(float pctIn) {
        return MathHelper.func_219799_g((float)pctIn, (float)this.prevSwimAnim, (float)this.swimAnim) / 5.0f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        switch (id) {
            case 4: {
                this.func_70637_d(true);
                break;
            }
            case 5: {
                this.func_70637_d(false);
                break;
            }
            case 8: {
                this.playSwimAnim = true;
                break;
            }
            case 9: {
                this.playSwimAnim = false;
                break;
            }
            case 10: {
                if (!this.field_70170_p.field_72995_K) break;
                EntityUtil.playMovingSound(SkiesSounds.ENTITY_CROGRE_JUMP, (LivingEntity)this, this.func_70599_aP(), this.func_70647_i());
                break;
            }
            default: {
                super.func_70103_a(id);
            }
        }
    }

    public void onMove(MoveHelperController helper, double distanceIn) {
        if (!this.func_70661_as().func_75500_f()) {
            double motion;
            PathPoint path = this.func_70661_as().func_75505_d().func_75870_c();
            BlockPos finalPos = new BlockPos(path.field_75839_a, path.field_75837_b, path.field_75838_c);
            Vector3d vector3d = this.func_70676_i(1.0f);
            double distanceToFinal = EntityUtil.getDistanceToPos((Vector3i)this.func_233580_cy_(), (Vector3i)finalPos);
            double newMotion = 1.5 * distanceToFinal / 8.5;
            double d = motion = this.func_70631_g_() ? Math.min(newMotion, 0.5) : Math.min(newMotion, 1.5);
            if (!this.func_203005_aq() && this.field_70122_E) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)4);
                this.func_70637_d(true);
                helper.func_75642_a(path.field_75839_a, path.field_75837_b, path.field_75838_c, 1.0);
                Vector3d currentMotion = this.func_213322_ci();
                Vector3d motionTowardsTarget = new Vector3d(this.func_226277_ct_() - (double)path.field_75839_a, 0.0, this.func_226281_cx_() - (double)path.field_75838_c);
                if (motionTowardsTarget.func_189985_c() > 1.0E-7) {
                    motionTowardsTarget = motionTowardsTarget.func_72432_b().func_186678_a(-motion).func_178787_e(currentMotion);
                }
                this.func_213317_d(new Vector3d(motionTowardsTarget.field_72450_a, this.func_70631_g_() ? 0.5 : Math.min(1.0 * distanceToFinal / 5.0, 1.0), motionTowardsTarget.field_72449_c));
                if (distanceToFinal <= 3.0) {
                    this.field_70699_by.func_75499_g();
                }
            }
            if (this.func_203005_aq() && this.func_184188_bt().isEmpty()) {
                if (distanceToFinal <= 2.0) {
                    this.field_70699_by.func_75499_g();
                }
                if (this.field_70173_aa % 20 == 0) {
                    this.setCrogreSwimming(true);
                    this.func_213317_d(new Vector3d(vector3d.field_72450_a * 0.5, !this.field_70170_p.func_226664_a_(this.func_174813_aQ().func_72314_b(0.5, 0.0, 0.5)) ? (double)0.2f : 0.0, vector3d.field_72449_c * 0.5));
                } else if (this.field_70173_aa % 20 == 10) {
                    this.setCrogreSwimming(false);
                }
            }
        }
    }

    @Override
    public void func_213352_e(Vector3d travelVectorIn) {
        if (this.func_70089_S()) {
            Entity entity;
            Entity entity2 = entity = this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
            if (this.func_82171_bF() && entity instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)entity;
                this.field_70126_B = this.field_70177_z = entity.field_70177_z;
                this.field_70125_A = entity.field_70125_A * 0.5f;
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                this.field_70761_aq = this.field_70177_z;
                this.field_70759_as = this.field_70177_z;
                this.field_70138_W = 1.0f;
                this.field_70747_aH = this.func_70689_ay() * 0.1f;
                float forward = player.field_191988_bg;
                if (forward <= 0.0f) {
                    forward = 0.0f;
                }
                if (this.func_184186_bw()) {
                    float f = (float)this.func_110148_a(Attributes.field_233821_d_).func_111126_e() * 0.225f;
                    this.func_70659_e(f);
                    Vector3d vector3d = this.func_70676_i(1.0f);
                    if (forward > 0.0f) {
                        if (!this.func_203005_aq() && this.field_70122_E) {
                            this.field_70170_p.func_72960_a((Entity)this, (byte)4);
                            this.func_70637_d(true);
                            this.func_213317_d(new Vector3d(vector3d.field_72450_a * 1.0, 1.0, vector3d.field_72449_c * 1.0));
                        } else if (this.func_203005_aq()) {
                            if (this.field_70173_aa % 20 == 0) {
                                this.setCrogreSwimming(true);
                                this.func_213317_d(new Vector3d(vector3d.field_72450_a * 0.5, !this.field_70170_p.func_226664_a_(this.func_174813_aQ().func_72314_b(0.5, 0.0, 0.5)) ? (double)0.2f : 0.0, vector3d.field_72449_c * 0.5));
                            } else if (this.field_70173_aa % 20 == 10) {
                                this.setCrogreSwimming(false);
                            }
                        }
                    }
                    super.func_213352_e(new Vector3d(0.0, 0.0, (double)forward));
                } else {
                    this.func_213317_d(Vector3d.field_186680_a);
                }
                this.field_184618_aE = this.field_70721_aZ;
                double d1 = this.func_226277_ct_() - this.field_70169_q;
                double d0 = this.func_226281_cx_() - this.field_70166_s;
                float f1 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
                if (f1 > 1.0f) {
                    f1 = 1.0f;
                }
                this.field_70721_aZ += (f1 - this.field_70721_aZ) * 0.4f;
                this.field_184619_aG += this.field_70721_aZ;
            } else {
                this.field_70138_W = 0.5f;
                this.field_70747_aH = 0.02f;
                super.func_213352_e(travelVectorIn);
            }
        }
    }

    @Override
    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (!super.func_230254_b_(player, hand).func_226246_a_() && itemstack.func_77973_b() == this.getTameItem() && !this.isTamed()) {
            if (!player.func_184812_l_()) {
                itemstack.func_190918_g(1);
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70146_Z.nextInt(3) == 0 && !ForgeEventFactory.onAnimalTame((AnimalEntity)this, (PlayerEntity)player)) {
                    this.field_70699_by.func_75499_g();
                    this.func_70624_b(null);
                    this.playTameEffect(true);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                    this.setTamed(true);
                } else {
                    this.playTameEffect(false);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(player, hand);
    }

    @Override
    public Item getSaddleItem() {
        return Items.field_151141_av;
    }

    @Override
    public Item getTameItem() {
        return SkiesItems.bug_guts;
    }

    @Override
    public boolean useTraditionalTravel() {
        return true;
    }

    @Override
    public int getMaxInventorySlots() {
        return 1;
    }

    class MoveHelperController
    extends MovementController {
        private final CrogreEntity frog;

        public MoveHelperController(CrogreEntity frogIn) {
            super((MobEntity)frogIn);
            this.frog = frogIn;
        }

        public void func_75641_c() {
            double d0 = this.field_75646_b - this.field_75648_a.func_226277_ct_();
            double d1 = this.field_75644_d - this.field_75648_a.func_226281_cx_();
            double d3 = d0 * d0 + d1 * d1;
            this.frog.onMove(this, MathHelper.func_76133_a((double)d3));
            if (!this.frog.func_70781_l()) {
                this.field_188491_h = MovementController.Action.WAIT;
            }
        }

        public MovementController.Action getAction() {
            return this.field_188491_h;
        }
    }
}

