/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile.boss.summons.ent;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.entities.hostile.SpewterEntity;
import com.legacy.blue_skies.entities.hostile.boss.StarlitCrusherEntity;
import com.legacy.blue_skies.entities.hostile.boss.summons.ent.EntWallEntity;
import com.legacy.blue_skies.entities.util.interfaces.ISkyBoss;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntRootEntity
extends Entity {
    protected static final DataParameter<Boolean> LARGE = EntityDataManager.func_187226_a(EntRootEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public int warmupDelayTicks;
    public int lifeTicks = this.isLarge() ? 80 : 50;
    public int downwardTranslateAmount = 0;
    private boolean sentSpikeEvent;
    private LivingEntity caster;
    private UUID casterUuid;

    public EntRootEntity(EntityType<? extends EntRootEntity> typeIn, World worldIn) {
        super(typeIn, worldIn);
    }

    public EntRootEntity(World worldIn, double x, double y, double z, float rotation, int warmupDelay, LivingEntity casterIn, boolean isRootLarge) {
        this(SkiesEntityTypes.ENT_ROOT, worldIn);
        this.warmupDelayTicks = warmupDelay;
        this.setCaster(casterIn);
        this.field_70177_z = rotation * 57.295776f;
        this.func_70107_b(x, y, z);
        this.lifeTicks = this.isLarge() ? 80 : 50;
        this.setRootIsLarge(isRootLarge);
    }

    public EntRootEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this(SkiesEntityTypes.ENT_ROOT, world);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(LARGE, (Object)false);
    }

    public void func_213315_a(MoverType type, Vector3d vec) {
        super.func_213315_a(type, Vector3d.field_186680_a);
    }

    public void setCaster(LivingEntity livingIn) {
        this.caster = livingIn;
        this.casterUuid = livingIn == null ? null : livingIn.func_110124_au();
    }

    @Nullable
    public LivingEntity getCaster() {
        Entity entity;
        if (this.caster == null && this.casterUuid != null && this.field_70170_p instanceof ServerWorld && (entity = ((ServerWorld)this.field_70170_p).func_217461_a(this.casterUuid)) instanceof LivingEntity) {
            this.caster = (LivingEntity)entity;
        }
        return this.caster;
    }

    public void func_70037_a(CompoundNBT compound) {
        this.setRootIsLarge(compound.func_74767_n("Large"));
        this.warmupDelayTicks = compound.func_74762_e("Warmup");
        if (compound.func_186855_b("OwnerUUID")) {
            this.casterUuid = compound.func_186857_a("OwnerUUID");
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        compound.func_74757_a("Large", this.isLarge());
        compound.func_74768_a("Warmup", this.warmupDelayTicks);
        if (this.casterUuid != null) {
            compound.func_186854_a("OwnerUUID", this.casterUuid);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (this.lifeTicks <= 5) {
                --this.downwardTranslateAmount;
            }
            --this.lifeTicks;
        } else if (--this.warmupDelayTicks < 0) {
            if (this.warmupDelayTicks <= -2 && this.lifeTicks > 5) {
                for (LivingEntity livingentity : this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ().func_72314_b(0.2, 0.0, 0.2))) {
                    if (livingentity instanceof EntWallEntity || livingentity instanceof SpewterEntity) continue;
                    this.damage(livingentity);
                }
            }
            if (!this.sentSpikeEvent) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)4);
                this.sentSpikeEvent = true;
            }
            if (--this.lifeTicks < 0) {
                this.func_70106_y();
            }
        }
        if (!this.field_70170_p.func_180495_p(this.func_233580_cy_()).func_196952_d((IBlockReader)this.field_70170_p, this.func_233580_cy_()).func_197766_b() || this.getCaster() != null && !this.getCaster().func_70089_S()) {
            this.func_70106_y();
        }
        if (this.field_70173_aa == 1) {
            this.func_184185_a(SoundEvents.field_219625_by, 1.0f, this.field_70146_Z.nextFloat() * 0.2f + 0.85f);
        }
    }

    private void damage(LivingEntity target) {
        LivingEntity caster = this.getCaster();
        int timeUntilHit = 0;
        if (caster instanceof StarlitCrusherEntity) {
            StarlitCrusherEntity crusher = (StarlitCrusherEntity)caster;
            int n = crusher.getDifficultyID() == ISkyBoss.Level.SILVER.getId() ? 8 : (crusher.getDifficultyID() == ISkyBoss.Level.GOLD.getId() ? 10 : (timeUntilHit = crusher.getDifficultyID() >= ISkyBoss.Level.PLATINUM.getId() ? 14 : 0));
        }
        if (target.func_70089_S() && !target.func_190530_aW() && target != caster && target.field_70172_ad <= timeUntilHit) {
            float damage;
            float f = damage = this.isLarge() ? 5.0f : 3.0f;
            if (caster == null) {
                target.func_70097_a(new DamageSource(BlueSkies.find("root")), damage);
            } else {
                if (caster.func_184191_r((Entity)target)) {
                    return;
                }
                target.func_70097_a(DamageSource.func_188403_a((Entity)this, (LivingEntity)caster), damage);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        super.func_70103_a(id);
        if (id == 4) {
            this.func_184185_a(SoundEvents.field_187542_ac, 1.0f, this.field_70146_Z.nextFloat() * 0.2f + 0.85f);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == DamageSource.field_76368_d) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getLifeTicks() {
        return this.lifeTicks;
    }

    public boolean isLarge() {
        return (Boolean)this.field_70180_af.func_187225_a(LARGE);
    }

    public void setRootIsLarge(boolean staticIn) {
        this.field_70180_af.func_187227_b(LARGE, (Object)staticIn);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

