/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile.boss;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.legacy.blue_skies.blocks.dungeon.SkyDecayingSpikeBlock;
import com.legacy.blue_skies.blocks.misc.TrophyBlock;
import com.legacy.blue_skies.entities.hostile.boss.summons.DecayingSpikeEntity;
import com.legacy.blue_skies.entities.util.SkiesDungeonType;
import com.legacy.blue_skies.entities.util.base.SkiesIllagerBossEntity;
import com.legacy.blue_skies.entities.util.interfaces.ISkyBoss;
import com.legacy.blue_skies.items.LootBagItem;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.registries.SkiesParticles;
import com.legacy.blue_skies.registries.SkiesSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.item.BowItem;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.Potions;
import net.minecraft.state.Property;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.BossInfo;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;

public class AlchemistEntity
extends SkiesIllagerBossEntity {
    private static final Set<Effect> IMMUNE_EFFECTS = ImmutableSet.of((Object)Effects.field_76436_u, (Object)Effects.field_76433_i, (Object)Effects.field_82731_v, (Object)Effects.field_188424_y, (Object)Effects.field_76421_d);
    protected List<BlockPos> fluidConversionList = new ArrayList<BlockPos>();
    protected boolean isConvertingToWater = true;

    public AlchemistEntity(EntityType<? extends AlchemistEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 8.0f, 0.6, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new RegenGoal());
        this.field_70714_bg.func_75776_a(4, (Goal)new LiquidConversionGoal());
        this.field_70714_bg.func_75776_a(5, (Goal)new FireArrowBundleGoal());
        this.field_70714_bg.func_75776_a(5, (Goal)new DecayingSpikeGoal());
        this.field_70714_bg.func_75776_a(5, (Goal)new PotionCloudGoal());
        this.field_70714_bg.func_75776_a(5, (Goal)new BlindlessGoal());
        this.field_70714_bg.func_75776_a(8, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{AbstractRaiderEntity.class}).func_220794_a(new Class[0]));
        this.field_70714_bg.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true).func_190882_b(300));
        this.field_70714_bg.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, false).func_190882_b(300));
        this.field_70714_bg.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, false));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 500.0).func_233815_a_(Attributes.field_233819_b_, 30.0).func_233815_a_(Attributes.field_233821_d_, 0.5);
    }

    @Override
    public double getBossHealth() {
        return 500.0 + (double)this.getExtraPlayers() * 150.0;
    }

    @Override
    public float getHealAmount() {
        return 40.0f;
    }

    @Override
    public LootBagItem getLootBag() {
        return SkiesItems.loot_bag_alchemist;
    }

    @Override
    public TrophyBlock getTrophy() {
        return SkiesBlocks.alchemist_trophy;
    }

    @Override
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    public Pair<DyeColor, DyeColor> getFireworkColors() {
        return Pair.of((Object)DyeColor.RED, (Object)DyeColor.YELLOW);
    }

    public boolean func_70687_e(EffectInstance effect) {
        return IMMUNE_EFFECTS.contains(effect.func_188419_a()) ? false : super.func_70687_e(effect);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76364_f() instanceof AreaEffectCloudEntity || source.func_76364_f() instanceof PotionEntity) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void healthParticles() {
        if (this.secondPhaseHealth()) {
            double dx = this.field_70146_Z.nextGaussian() * 0.02;
            double dy = this.field_70146_Z.nextGaussian() * 0.02;
            double dz = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_195594_a((IParticleData)SkiesParticles.BLACK_FLAME, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), dx, dy, dz);
        } else {
            this.spawnParticles((IParticleData)ParticleTypes.field_197624_q);
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
    }

    @Override
    public void invulnerableTick() {
        if (this.field_70170_p.field_72995_K) {
            double d0 = 0.05;
            this.field_70170_p.func_195590_a((IParticleData)ParticleTypes.field_197624_q, true, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.5, 0.0);
            this.field_70170_p.func_195590_a((IParticleData)ParticleTypes.field_197624_q, true, this.func_226277_ct_(), this.func_226278_cu_() + 4.0, this.func_226281_cx_(), d0, -0.4, d0);
            this.field_70170_p.func_195590_a((IParticleData)ParticleTypes.field_197624_q, true, this.func_226277_ct_(), this.func_226278_cu_() + 4.0, this.func_226281_cx_(), d0, -0.4, -d0);
            this.field_70170_p.func_195590_a((IParticleData)ParticleTypes.field_197624_q, true, this.func_226277_ct_(), this.func_226278_cu_() + 4.0, this.func_226281_cx_(), -d0, -0.4, d0);
            this.field_70170_p.func_195590_a((IParticleData)ParticleTypes.field_197624_q, true, this.func_226277_ct_(), this.func_226278_cu_() + 4.0, this.func_226281_cx_(), -d0, -0.4, -d0);
        }
    }

    public void attackEntityWithRangedAttack(LivingEntity target, float distanceFactor) {
        double d3;
        double d2;
        double d1;
        double d0;
        ArrowEntity entityarrow;
        int i;
        for (i = 0; i < 3; ++i) {
            entityarrow = this.createArrowEntity(distanceFactor);
            d0 = target.func_226277_ct_() - this.func_226277_ct_();
            d1 = target.func_174813_aQ().field_72338_b + (double)(target.func_213302_cg() / 3.0f) - entityarrow.func_226278_cu_();
            d2 = target.func_226281_cx_() - this.func_226281_cx_();
            d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
            entityarrow.func_70186_c(d0, d1 + d3 * (double)0.2f, d2 + (double)(4 * i - 4), 1.6f, (float)(14 - this.getDifficultyID() * 4));
            this.func_184185_a(SoundEvents.field_187737_v, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            this.field_70170_p.func_217376_c((Entity)entityarrow);
        }
        if (this.secondPhaseHealth()) {
            for (i = 0; i < 3; ++i) {
                entityarrow = this.createArrowEntity(distanceFactor);
                entityarrow.func_70015_d(7);
                d0 = target.func_226277_ct_() - this.func_226277_ct_();
                d1 = target.func_174813_aQ().field_72338_b + (double)(target.func_213302_cg() / 3.0f) - entityarrow.func_226278_cu_() - 1.0;
                d2 = target.func_226281_cx_() - this.func_226281_cx_();
                d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                entityarrow.func_70186_c(d0, d1 + d3 * (double)0.2f, d2 + (double)(4 * i - 4), 1.6f, (float)(14 - this.getDifficultyID() * 4));
                this.func_184185_a(SoundEvents.field_187737_v, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
                this.field_70170_p.func_217376_c((Entity)entityarrow);
            }
        }
    }

    protected ArrowEntity createArrowEntity(float distanceFactor) {
        ArrowEntity arrow = new ArrowEntity(this.field_70170_p, (LivingEntity)this);
        arrow.func_190547_a((LivingEntity)this, distanceFactor);
        arrow.func_70239_b(3.0);
        if (this.secondPhaseHealth()) {
            if (this.getDifficultyID() >= ISkyBoss.Level.GOLD.getId() && this.field_70146_Z.nextInt(5) == 0) {
                arrow.func_184558_a(new EffectInstance(Effects.field_76421_d, 100));
            }
            arrow.func_70239_b(5.0);
        } else {
            arrow.func_70239_b(3.0);
        }
        arrow.func_70240_a(1);
        return arrow;
    }

    protected SoundEvent func_184639_G() {
        return SkiesSounds.ENTITY_ALCHEMIST_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SkiesSounds.ENTITY_ALCHEMIST_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SkiesSounds.ENTITY_ALCHEMIST_DEATH;
    }

    protected float func_70599_aP() {
        return 1.5f;
    }

    protected float func_70647_i() {
        return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f + 1.0f;
    }

    @Override
    public BlockState getFloorState() {
        return SkiesBlocks.lunar_stonebrick.func_176223_P();
    }

    public SoundEvent func_213654_dW() {
        return SkiesSounds.ENTITY_ALCHEMIST_CELEBRATE;
    }

    protected SoundEvent func_193086_dk() {
        return SkiesSounds.ENTITY_ALCHEMIST_CAST_SPELL;
    }

    @Override
    public SkiesDungeonType getBossType() {
        return SkiesDungeonType.BLINDING;
    }

    @Override
    public int getProgression() {
        return 1;
    }

    @Override
    public boolean isEverbrightBoss() {
        return false;
    }

    @Override
    public BossInfo.Color getBossBarColor() {
        return BossInfo.Color.RED;
    }

    class FireArrowBundleGoal
    extends SkiesIllagerBossEntity.UseBossSpellGoal {
        private AlchemistEntity boss;

        private FireArrowBundleGoal() {
            super(AlchemistEntity.this);
            this.boss = AlchemistEntity.this;
        }

        protected int func_190869_f() {
            return this.boss.getDifficultyID() == ISkyBoss.Level.BRONZE.getId() ? 50 : 40;
        }

        protected int func_190872_i() {
            return 200;
        }

        protected int func_190867_m() {
            return this.boss.getDifficultyID() == ISkyBoss.Level.BRONZE.getId() ? 25 : 20;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && this.boss.isAwayFromPlayers() && this.boss.getInvulTime() <= 0;
        }

        protected void func_190868_j() {
            LivingEntity entitylivingbase = this.boss.func_70638_az();
            if (entitylivingbase != null) {
                this.boss.attackEntityWithRangedAttack(entitylivingbase, BowItem.func_185059_b((int)40));
            }
        }

        protected SoundEvent func_190871_k() {
            return SkiesSounds.ENTITY_ALCHEMIST_PREPARE_ATTACK;
        }

        @Override
        protected SkiesIllagerBossEntity.BossSpellColor getSpellColor() {
            return SkiesIllagerBossEntity.BossSpellColor.ARROW_BUNDLE;
        }
    }

    class PotionCloudGoal
    extends SkiesIllagerBossEntity.UseBossSpellGoal {
        private AlchemistEntity boss;

        private PotionCloudGoal() {
            super(AlchemistEntity.this);
            this.boss = AlchemistEntity.this;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && AlchemistEntity.this.isAwayFromPlayers() && AlchemistEntity.this.getInvulTime() <= 0 && this.boss.field_70146_Z.nextBoolean();
        }

        protected int func_190869_f() {
            return this.boss.getDifficultyID() == ISkyBoss.Level.BRONZE.getId() ? 85 : 70;
        }

        protected int func_190872_i() {
            return 300;
        }

        protected void func_190868_j() {
            if (this.boss.func_70638_az() != null) {
                this.spawnClouds();
            }
        }

        private void spawnClouds() {
            BlockPos pos = this.boss.isDungeonSpawned() ? this.boss.getHome() : this.boss.func_233580_cy_();
            AreaEffectCloudEntity potionCloudPX = new AreaEffectCloudEntity(this.boss.field_70170_p, (double)(pos.func_177958_n() + 5), (double)pos.func_177956_o(), (double)(pos.func_177952_p() + 5));
            AreaEffectCloudEntity potionCloudPZ = new AreaEffectCloudEntity(this.boss.field_70170_p, (double)(pos.func_177958_n() + 5), (double)pos.func_177956_o(), (double)(pos.func_177952_p() - 5));
            AreaEffectCloudEntity potionCloudNX = new AreaEffectCloudEntity(this.boss.field_70170_p, (double)(pos.func_177958_n() - 5), (double)pos.func_177956_o(), (double)(pos.func_177952_p() + 5));
            AreaEffectCloudEntity potionCloudNZ = new AreaEffectCloudEntity(this.boss.field_70170_p, (double)(pos.func_177958_n() - 5), (double)pos.func_177956_o(), (double)(pos.func_177952_p() - 5));
            Potion potiontype = this.boss.secondPhaseHealth() ? Potions.field_185252_x : Potions.field_185254_z;
            ImmutableList clouds = ImmutableList.of((Object)potionCloudPX, (Object)potionCloudPZ, (Object)potionCloudNX, (Object)potionCloudNZ);
            clouds.forEach(cloud -> {
                cloud.func_184484_a(potiontype);
                cloud.func_184486_b(200 + (this.boss.getDifficultyID() > ISkyBoss.Level.SILVER.getId() ? this.boss.getDifficultyID() * 40 : 0));
                cloud.func_184481_a((LivingEntity)this.boss);
                this.boss.field_70170_p.func_217376_c((Entity)cloud);
            });
        }

        protected SoundEvent func_190871_k() {
            return SkiesSounds.ENTITY_ALCHEMIST_PREPARE_POTIONS;
        }

        @Override
        protected SkiesIllagerBossEntity.BossSpellColor getSpellColor() {
            return this.boss.secondPhaseHealth() ? SkiesIllagerBossEntity.BossSpellColor.HARMING_CLOUD : SkiesIllagerBossEntity.BossSpellColor.POISON_CLOUD;
        }
    }

    class DecayingSpikeGoal
    extends SkiesIllagerBossEntity.UseBossSpellGoal {
        private AlchemistEntity boss;

        private DecayingSpikeGoal() {
            super(AlchemistEntity.this);
            this.boss = AlchemistEntity.this;
        }

        protected int func_190867_m() {
            return this.boss.getDifficultyID() == ISkyBoss.Level.GOLD.getId() ? 15 : (this.boss.getDifficultyID() >= ISkyBoss.Level.PLATINUM.getId() ? 10 : 20);
        }

        protected int func_190869_f() {
            return 60;
        }

        protected int func_190872_i() {
            return 270;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && this.boss.isAwayFromPlayers() && this.boss.getInvulTime() <= 0;
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
        }

        protected void func_190868_j() {
            LivingEntity target = this.boss.func_70638_az();
            double d0 = Math.min(target.func_226278_cu_(), this.boss.func_226278_cu_());
            double d1 = Math.max(target.func_226278_cu_(), this.boss.func_226278_cu_()) + 1.0;
            float f = (float)MathHelper.func_181159_b((double)(target.func_226281_cx_() - this.boss.func_226281_cx_()), (double)(target.func_226277_ct_() - this.boss.func_226277_ct_()));
            if ((double)this.boss.func_70032_d((Entity)target) < 5.0 || this.boss.field_70170_p.func_217366_a(this.boss.func_226277_ct_(), this.boss.func_226278_cu_(), this.boss.func_226281_cx_(), 5.0, true) != null && (double)this.boss.func_70032_d((Entity)this.boss.field_70170_p.func_217366_a(this.boss.func_226277_ct_(), this.boss.func_226278_cu_(), this.boss.func_226281_cx_(), 5.0, true)) < 5.0) {
                for (int k = 0; k < 8; ++k) {
                    float f2 = f + (float)k * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                    this.playSpikeParticles(this.boss.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f2) * 2.0, this.boss.func_226278_cu_() + 0.2, this.boss.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f2) * 2.0, this.boss.func_213311_cf() / 4.0f, this.boss.func_213302_cg() / 4.0f, this.boss.func_213311_cf() / 4.0f);
                    this.spawnSpikeCircle(this.boss.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f2) * 2.0, this.boss.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f2) * 2.0, d0, d1);
                }
            } else {
                for (int l = 0; l < 16; ++l) {
                    double d2 = 1.25 * (double)(l + 1);
                    this.playSpikeParticles(this.boss.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f) * d2, this.boss.func_226278_cu_() + 5.0, this.boss.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f) * d2, this.boss.func_213311_cf() / 4.0f, this.boss.func_213302_cg() / 4.0f, this.boss.func_213311_cf() / 4.0f);
                    this.spawnSpikeLine(this.boss.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f) * d2, this.boss.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f) * d2, d0, d1);
                }
            }
        }

        private void spawnSpikeLine(double posX, double posZ, double maxY, double posY) {
            BlockPos blockpos = new BlockPos(posX, posY, posZ);
            boolean flag = false;
            double d0 = 0.0;
            do {
                BlockState iblockstate;
                VoxelShape voxelshape;
                if (!this.boss.field_70170_p.func_175623_d(blockpos) || this.boss.field_70170_p.func_175623_d(blockpos.func_177977_b())) continue;
                if (!this.boss.field_70170_p.func_175623_d(blockpos) && (voxelshape = (iblockstate = this.boss.field_70170_p.func_180495_p(blockpos)).func_196952_d((IBlockReader)this.boss.field_70170_p, blockpos)) != null) {
                    d0 = voxelshape.func_197758_c(Direction.Axis.Y);
                }
                flag = true;
                break;
            } while ((blockpos = blockpos.func_177977_b()).func_177956_o() >= MathHelper.func_76128_c((double)maxY) - 1);
            if (flag) {
                BlockPos blockpos2 = new BlockPos(posX, (double)blockpos.func_177956_o() + d0 + 5.0, posZ);
                DecayingSpikeEntity block = new DecayingSpikeEntity(this.boss.field_70170_p, blockpos2, SkiesBlocks.decaying_spike.func_176223_P(), (LivingEntity)this.boss);
                block.setDownwards(true);
                block.field_145812_b = 200;
                block.field_145813_c = false;
                this.boss.field_70170_p.func_217376_c((Entity)block);
            }
        }

        private void spawnSpikeCircle(double posX, double posZ, double maxY, double posY) {
            BlockPos blockpos = new BlockPos(posX, posY, posZ);
            boolean flag = false;
            double d0 = 0.0;
            do {
                BlockState iblockstate;
                VoxelShape voxelshape;
                if (!this.boss.field_70170_p.func_175623_d(blockpos) || this.boss.field_70170_p.func_175623_d(blockpos.func_177977_b())) continue;
                if (!this.boss.field_70170_p.func_175623_d(blockpos) && (voxelshape = (iblockstate = this.boss.field_70170_p.func_180495_p(blockpos)).func_196952_d((IBlockReader)this.boss.field_70170_p, blockpos)) != null) {
                    d0 = voxelshape.func_197758_c(Direction.Axis.Y);
                }
                flag = true;
                break;
            } while ((blockpos = blockpos.func_177977_b()).func_177956_o() >= MathHelper.func_76128_c((double)maxY) - 1);
            if (flag) {
                BlockPos blockpos2 = new BlockPos((double)blockpos.func_177958_n() + d0, (double)blockpos.func_177956_o() + d0, (double)blockpos.func_177952_p() + d0);
                DecayingSpikeEntity block = new DecayingSpikeEntity(this.boss.field_70170_p, blockpos2, (BlockState)SkiesBlocks.decaying_spike.func_176223_P().func_206870_a((Property)SkyDecayingSpikeBlock.DOWNWARD, (Comparable)Boolean.valueOf(false)), (LivingEntity)this.boss);
                block.setDownwards(false);
                block.func_70107_b((double)blockpos2.func_177958_n() + 0.5, blockpos2.func_177956_o(), (double)blockpos2.func_177952_p() + 0.5);
                block.field_145812_b = 200;
                block.func_213293_j(0.0, 0.7, 0.0);
                block.field_145813_c = false;
                this.boss.field_70170_p.func_217376_c((Entity)block);
            }
        }

        public void func_75246_d() {
            block4: {
                super.func_75246_d();
                LivingEntity target = this.boss.func_70638_az();
                if (target == null || this.boss.field_70173_aa % 5 != 0) break block4;
                float f = (float)MathHelper.func_181159_b((double)(target.func_226281_cx_() - this.boss.func_226281_cx_()), (double)(target.func_226277_ct_() - this.boss.func_226277_ct_()));
                if ((double)this.boss.func_70032_d((Entity)target) < 5.0 || this.boss.field_70170_p.func_217366_a(this.boss.func_226277_ct_(), this.boss.func_226278_cu_(), this.boss.func_226281_cx_(), 5.0, true) != null && (double)this.boss.func_70032_d((Entity)this.boss.field_70170_p.func_217366_a(this.boss.func_226277_ct_(), this.boss.func_226278_cu_(), this.boss.func_226281_cx_(), 5.0, true)) < 5.0) {
                    for (int k = 0; k < 8; ++k) {
                        float f2 = f + (float)k * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                        this.playSpikeParticles(this.boss.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f2) * 2.0, this.boss.func_226278_cu_() + 0.2, this.boss.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f2) * 2.0, this.boss.func_213311_cf() / 4.0f, this.boss.func_213302_cg() / 4.0f, this.boss.func_213311_cf() / 4.0f);
                    }
                } else {
                    for (int l = 0; l < 16; ++l) {
                        double d2 = 1.25 * (double)(l + 1);
                        this.playSpikeParticles(this.boss.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f) * d2, this.boss.func_226278_cu_() + 5.0, this.boss.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f) * d2, this.boss.func_213311_cf() / 4.0f, this.boss.func_213302_cg() / 4.0f, this.boss.func_213311_cf() / 4.0f);
                    }
                }
            }
        }

        private void playSpikeParticles(double posX, double posY, double posZ, double offsetX, double offsetY, double offsetZ) {
            int count = 20;
            if (this.boss.field_70170_p instanceof ServerWorld) {
                ((ServerWorld)this.boss.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, SkiesBlocks.decaying_spike.func_176223_P()), posX, posY, posZ, count, offsetX, offsetY, offsetZ, 0.05);
            }
        }

        protected SoundEvent func_190871_k() {
            return SkiesSounds.ENTITY_ALCHEMIST_PREPARE_ROCKS;
        }

        @Override
        protected SkiesIllagerBossEntity.BossSpellColor getSpellColor() {
            return SkiesIllagerBossEntity.BossSpellColor.ROCKS;
        }
    }

    public class BlindlessGoal
    extends SkiesIllagerBossEntity.UseBossSpellGoal {
        private AlchemistEntity boss;

        public BlindlessGoal() {
            super(AlchemistEntity.this);
            this.boss = AlchemistEntity.this;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && this.boss.isAwayFromPlayers() && this.boss.getInvulTime() <= 0 && this.boss.field_70146_Z.nextBoolean();
        }

        public void func_75251_c() {
            super.func_75251_c();
        }

        protected void func_190868_j() {
            for (PlayerEntity players : this.boss.getPlayersInDungeonArea()) {
                if (players.func_184812_l_() || players.func_175149_v()) continue;
                players.func_195064_c(new EffectInstance(Effects.field_76440_q, 100, 0));
            }
        }

        protected int func_190867_m() {
            return 20;
        }

        protected int func_190869_f() {
            return 60;
        }

        protected int func_190872_i() {
            return 300;
        }

        protected SoundEvent func_190871_k() {
            return SkiesSounds.ENTITY_ALCHEMIST_PREPARE_BLINDNESS;
        }

        @Override
        protected SkiesIllagerBossEntity.BossSpellColor getSpellColor() {
            return SkiesIllagerBossEntity.BossSpellColor.BLINDNESS;
        }
    }

    public class LiquidConversionGoal
    extends SkiesIllagerBossEntity.UseBossSpellGoal {
        private AlchemistEntity boss;
        public boolean shouldPlaceWater;
        private int waterAmount;
        private int lavaAmount;

        public LiquidConversionGoal() {
            super(AlchemistEntity.this);
            this.boss = AlchemistEntity.this;
            this.waterAmount = 0;
            this.lavaAmount = 0;
        }

        public boolean func_75250_a() {
            return this.boss.secondPhaseHealth() && this.boss.isAwayFromPlayers() && this.boss.getInvulTime() <= 0 && super.func_75250_a() && (this.boss.field_70146_Z.nextBoolean() || this.boss.func_70638_az() != null && this.boss.func_70638_az().func_223314_ad() > 0);
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            int radius = 15;
            BlockPos pos = this.boss.getHome();
            BlockPos min = pos.func_177982_a(-radius, -radius, -radius);
            BlockPos max = pos.func_177982_a(radius, radius, radius);
            for (BlockPos posAround : BlockPos.func_218278_a((BlockPos)min, (BlockPos)max)) {
                BlockState state = this.boss.field_70170_p.func_180495_p(posAround);
                if (state.func_177230_c() != Blocks.field_150343_Z && (state.func_177230_c() != Blocks.field_150353_l && state.func_177230_c() != Blocks.field_150355_j || (Integer)state.func_177229_b((Property)FlowingFluidBlock.field_176367_b) != 0)) continue;
                this.boss.fluidConversionList.add(new BlockPos((Vector3i)posAround));
                if (state.func_177230_c() == Blocks.field_150353_l) {
                    ++this.lavaAmount;
                    continue;
                }
                if (state.func_177230_c() != Blocks.field_150355_j) continue;
                ++this.waterAmount;
            }
            if (this.waterAmount > this.lavaAmount) {
                this.boss.setBossSpellType(SkiesIllagerBossEntity.BossSpellColor.LAVA);
            } else {
                this.boss.setBossSpellType(SkiesIllagerBossEntity.BossSpellColor.WATER);
            }
        }

        public void func_75251_c() {
            super.func_75251_c();
            this.waterAmount = 0;
            this.lavaAmount = 0;
            this.boss.fluidConversionList.clear();
        }

        protected void func_190868_j() {
            if (!this.boss.fluidConversionList.isEmpty()) {
                this.boss.fluidConversionList.forEach(fluidPos -> {
                    if (this.waterAmount > this.lavaAmount) {
                        this.boss.field_70170_p.func_175656_a(fluidPos, Blocks.field_150353_l.func_176223_P());
                    } else {
                        this.boss.field_70170_p.func_175656_a(fluidPos, Blocks.field_150355_j.func_176223_P());
                    }
                });
                this.waterAmount = 0;
                this.lavaAmount = 0;
                this.boss.fluidConversionList.clear();
            }
        }

        public void func_75246_d() {
            if (this.field_193321_c == 1) {
                int radius = 15;
                BlockPos pos = this.boss.getHome();
                BlockPos min = pos.func_177982_a(-radius, -radius, -radius);
                BlockPos max = pos.func_177982_a(radius, radius, radius);
                for (BlockPos posAround : BlockPos.Mutable.func_218278_a((BlockPos)min, (BlockPos)max)) {
                    BlockState state = this.boss.field_70170_p.func_180495_p(posAround);
                    if (state.func_177230_c() != Blocks.field_150353_l && state.func_177230_c() != Blocks.field_150355_j) continue;
                    this.boss.field_70170_p.func_175656_a(posAround, Blocks.field_150350_a.func_176223_P());
                }
            }
            super.func_75246_d();
        }

        protected int func_190867_m() {
            return 30;
        }

        protected int func_190869_f() {
            return this.boss.getDifficultyID() == ISkyBoss.Level.BRONZE.getId() ? 70 : 60;
        }

        protected int func_190872_i() {
            return 90;
        }

        protected SoundEvent func_190871_k() {
            return SkiesSounds.ENTITY_ALCHEMIST_PREPARE_CONVERSION;
        }

        @Override
        protected SkiesIllagerBossEntity.BossSpellColor getSpellColor() {
            if (this.waterAmount > this.lavaAmount) {
                return SkiesIllagerBossEntity.BossSpellColor.LAVA;
            }
            return SkiesIllagerBossEntity.BossSpellColor.WATER;
        }
    }

    public class RegenGoal
    extends SkiesIllagerBossEntity.UseBossSpellGoal {
        private AlchemistEntity boss;

        public RegenGoal() {
            super(AlchemistEntity.this);
            this.boss = AlchemistEntity.this;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && this.boss.isAwayFromPlayers() && this.boss.secondPhaseHealth() && this.boss.getInvulTime() <= 0;
        }

        public void func_75251_c() {
            super.func_75251_c();
        }

        protected void func_190868_j() {
            int extraPlayers = Math.min(4, this.boss.getExtraPlayers());
            this.boss.func_195064_c(new EffectInstance(Effects.field_76428_l, (this.boss.getDifficultyID() == ISkyBoss.Level.BRONZE.getId() ? 18 : 20) + extraPlayers * 5, 5, false, false));
        }

        protected int func_190867_m() {
            return 20;
        }

        protected int func_190869_f() {
            return this.boss.getDifficultyID() >= ISkyBoss.Level.GOLD.getId() ? 60 : 70;
        }

        protected int func_190872_i() {
            int extraPlayers = Math.min(7, this.boss.getExtraPlayers());
            return 360 + extraPlayers * 20;
        }

        protected SoundEvent func_190871_k() {
            return SkiesSounds.ENTITY_ALCHEMIST_PREPARE_REGEN;
        }

        @Override
        protected SkiesIllagerBossEntity.BossSpellColor getSpellColor() {
            return SkiesIllagerBossEntity.BossSpellColor.REGENERATION;
        }
    }
}

