/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile;

import com.legacy.blue_skies.data.objects.SkiesEntityTags;
import com.legacy.blue_skies.entities.hostile.ArmoredFrostSpiritEntity;
import com.legacy.blue_skies.entities.hostile.boss.StarlitCrusherEntity;
import com.legacy.blue_skies.entities.hostile.boss.summons.ent.EntRootEntity;
import com.legacy.blue_skies.entities.projectile.SeedBombEntity;
import com.legacy.blue_skies.entities.util.base.SkiesMonsterEntity;
import com.legacy.blue_skies.entities.util.interfaces.ISkyBossMob;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesSounds;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SpewterEntity
extends SkiesMonsterEntity
implements ISkyBossMob,
IRangedAttackMob {
    protected static final DataParameter<Boolean> GROWN = EntityDataManager.func_187226_a(SpewterEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public int prevCounter;
    public int counter;
    public int spawnCounter;

    public SpewterEntity(EntityType<? extends SpewterEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 0;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(GROWN, (Object)false);
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return ArmoredFrostSpiritEntity.registerAttributes().func_233815_a_(Attributes.field_233818_a_, 28.0).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233819_b_, 7.5);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70714_bg.func_75776_a(3, (Goal)new RangedAttackGoal((IRangedAttackMob)this, 1.25, 20, 7.0f));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    public void func_213315_a(MoverType typeIn, Vector3d pos) {
        super.func_213315_a(typeIn, new Vector3d(0.0, pos.field_72448_b, 0.0));
    }

    @Override
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        if (!this.field_70170_p.field_72995_K) {
            double maxHealth = difficultyIn.func_203095_a() == Difficulty.HARD ? 32.0 : (difficultyIn.func_203095_a() == Difficulty.NORMAL ? 28.0 : 26.0);
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(maxHealth);
            this.func_70606_j((float)maxHealth);
        }
        return spawnDataIn;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.prevCounter = this.counter;
        if (this.spawnCounter > 0) {
            --this.spawnCounter;
        }
        if (this.spawnCounter < 0) {
            ++this.spawnCounter;
        }
        if (this.field_70725_aQ > 0 && this.counter < 20) {
            this.counter += 2;
        } else if (this.field_70725_aQ <= 0 && this.counter > 0) {
            --this.counter;
        }
        this.field_70759_as = 0.0f;
        this.field_70126_B = 0.0f;
        this.field_70127_C = 0.0f;
        this.field_70125_A = 0.0f;
        this.field_70759_as = 0.0f;
        this.field_70177_z = 0.0f;
    }

    protected SoundEvent func_184639_G() {
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SkiesSounds.ENTITY_SPEWTER_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SkiesSounds.ENTITY_SPEWTER_DEATH;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
    }

    protected float func_70599_aP() {
        return 1.0f;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean flag = super.func_70097_a(source, amount);
        if (flag && amount < this.func_110143_aJ() && !this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)5);
            this.counter = 17;
        }
        return flag;
    }

    protected float func_213348_b(Pose pose, EntitySize size) {
        return 1.0f;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    public boolean isGrown() {
        return (Boolean)this.field_70180_af.func_187225_a(GROWN);
    }

    public void setGrown(boolean grown) {
        if (grown) {
            this.spawnCounter = 15;
            this.field_70170_p.func_72960_a((Entity)this, (byte)6);
        }
        this.field_70180_af.func_187227_b(GROWN, (Object)grown);
    }

    protected void func_82167_n(Entity entityIn) {
        if (!(entityIn instanceof StarlitCrusherEntity)) {
            super.func_82167_n(entityIn);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        switch (id) {
            case 4: {
                this.counter = 15;
                break;
            }
            case 5: {
                this.counter = 17;
                break;
            }
            case 6: {
                this.spawnCounter = 30;
                break;
            }
            default: {
                super.func_70103_a(id);
            }
        }
    }

    public boolean func_184191_r(Entity entityIn) {
        if (entityIn instanceof EntRootEntity) {
            return this.func_184191_r((Entity)((EntRootEntity)entityIn).getCaster());
        }
        if (entityIn.func_200600_R().func_220341_a(SkiesEntityTags.NATURE_ALLIES)) {
            return this.func_96124_cp() == null && entityIn.func_96124_cp() == null;
        }
        return super.func_184191_r(entityIn) && entityIn != null && entityIn != this;
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return super.func_213380_a(worldIn, spawnReasonIn) && worldIn.func_226660_f_(this.func_233580_cy_()) && worldIn.func_180495_p(this.func_233580_cy_().func_177977_b()).func_177230_c() == SkiesBlocks.turquoise_cherry_grass_block;
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        if ((double)this.func_70032_d((Entity)target) >= 8.0) {
            return;
        }
        SeedBombEntity seedBomb = new SeedBombEntity(this.field_70170_p, this);
        double d0 = target.func_226277_ct_() - this.func_226277_ct_();
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.func_213302_cg() / 3.0f) - seedBomb.func_226278_cu_();
        double d2 = target.func_226281_cx_() - this.func_226281_cx_();
        float f = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2)) * 1.5f;
        seedBomb.func_70186_c(d0, d1 + (double)f, d2, 0.5f, 0.0f);
        this.func_184185_a(SkiesSounds.ENTITY_SPEWTER_SPIT, 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
        this.field_70170_p.func_217376_c((Entity)seedBomb);
        if (this.field_70737_aN > 0) {
            return;
        }
        this.counter = 15;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
    }
}

