/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile;

import com.legacy.blue_skies.entities.util.base.SkiesMonsterEntity;
import com.legacy.blue_skies.registries.SkiesSounds;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PolargeistEntity
extends SkiesMonsterEntity {
    private static final DataParameter<Boolean> STANDING = EntityDataManager.func_187226_a(PolargeistEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private float standTicks;
    private float prevStandTicks;

    public PolargeistEntity(EntityType<? extends PolargeistEntity> type, World world) {
        super(type, world);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70714_bg.func_75776_a(3, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.7f, true){

            protected void func_190102_a(LivingEntity enemy, double distToEnemySqr) {
                double d0 = this.func_179512_a(enemy);
                if (distToEnemySqr <= d0 && this.func_234040_h_()) {
                    this.func_234039_g_();
                    this.field_75441_b.func_70652_k((Entity)enemy);
                    PolargeistEntity.this.setStanding(false);
                } else if (distToEnemySqr <= d0 * 2.0) {
                    if (this.func_234040_h_()) {
                        PolargeistEntity.this.setStanding(false);
                        this.func_234039_g_();
                    }
                    if (this.func_234041_j_() <= 10) {
                        PolargeistEntity.this.setStanding(true);
                    }
                } else {
                    this.func_234039_g_();
                    PolargeistEntity.this.setStanding(false);
                }
            }
        });
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 26.0).func_233815_a_(Attributes.field_233821_d_, (double)0.23f).func_233815_a_(Attributes.field_233823_f_, 4.5);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STANDING, (Object)false);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
    }

    public void func_70020_e(CompoundNBT compound) {
        super.func_70020_e(compound);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!(this.func_70089_S() && this.func_70638_az() != null || !this.isStanding() || this.field_70170_p.field_72995_K)) {
            this.setStanding(false);
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.standTicks != this.prevStandTicks) {
                this.func_213323_x_();
            }
            this.prevStandTicks = this.standTicks;
            this.standTicks = this.isStanding() ? MathHelper.func_76131_a((float)(this.standTicks + 1.0f), (float)0.0f, (float)6.0f) : MathHelper.func_76131_a((float)(this.standTicks - 1.0f), (float)0.0f, (float)6.0f);
        }
    }

    public EntitySize func_213305_a(Pose poseIn) {
        if (this.standTicks > 0.0f) {
            float f = this.standTicks / 6.0f;
            float f1 = 1.0f + f;
            return super.func_213305_a(poseIn).func_220312_a(1.0f, f1);
        }
        return super.func_213305_a(poseIn);
    }

    public boolean isStanding() {
        return (Boolean)this.field_70180_af.func_187225_a(STANDING);
    }

    public void setStanding(boolean standing) {
        this.field_70180_af.func_187227_b(STANDING, (Object)standing);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getStandingAnimationScale(float p_189795_1_) {
        return MathHelper.func_219799_g((float)p_189795_1_, (float)this.prevStandTicks, (float)this.standTicks) / 6.0f;
    }

    protected SoundEvent func_184639_G() {
        return SkiesSounds.ENTITY_POLARGEIST_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SkiesSounds.ENTITY_POLARGEIST_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SkiesSounds.ENTITY_POLARGEIST_DEATH;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_190030_ev, 0.15f, 1.0f);
    }

    protected float func_70599_aP() {
        return 1.0f;
    }

    protected float func_213348_b(Pose pose, EntitySize size) {
        return 1.2f;
    }

    public boolean func_70652_k(Entity entityIn) {
        this.func_184185_a(SkiesSounds.ENTITY_POLARGEIST_ATTACK, this.func_70599_aP(), this.func_70647_i());
        return super.func_70652_k(entityIn);
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        boolean randomBoolean = this.field_70170_p.func_72896_J() ? true : this.field_70146_Z.nextBoolean();
        return randomBoolean && super.func_213380_a(worldIn, spawnReasonIn);
    }

    @Override
    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        return 0.0f;
    }

    public int func_70641_bl() {
        return 1;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }
}

