/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile;

import com.legacy.blue_skies.entities.util.base.SkiesMonsterEntity;
import com.legacy.blue_skies.registries.SkiesSounds;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DiophydeProwlerEntity
extends SkiesMonsterEntity {
    private float prevChargeAnim;
    private float chargeAnim;
    private boolean playChargeAnim;

    public DiophydeProwlerEntity(EntityType<? extends DiophydeProwlerEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 1.0f;
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 26.0).func_233815_a_(Attributes.field_233821_d_, 0.3);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70714_bg.func_75776_a(3, (Goal)new LungeAtTargetGoal());
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0){

            public boolean func_75250_a() {
                return DiophydeProwlerEntity.this.func_70638_az() == null && super.func_75250_a();
            }

            public boolean func_75253_b() {
                return DiophydeProwlerEntity.this.func_70638_az() == null && super.func_75253_b();
            }
        });
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.prevChargeAnim = this.chargeAnim;
            this.chargeAnim = this.playChargeAnim ? MathHelper.func_76131_a((float)(this.chargeAnim + 2.0f), (float)0.0f, (float)6.0f) : MathHelper.func_76131_a((float)(this.chargeAnim - 2.0f), (float)0.0f, (float)6.0f);
        } else if (this.func_70638_az() == null && this.playChargeAnim) {
            this.setCharging(false);
        }
    }

    public void setCharging(boolean chargingIn) {
        if (chargingIn) {
            this.playChargeAnim = true;
            this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        } else {
            this.playChargeAnim = false;
            this.field_70170_p.func_72960_a((Entity)this, (byte)5);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getChargingAnimationScale(float pctIn) {
        return MathHelper.func_219799_g((float)pctIn, (float)this.prevChargeAnim, (float)this.chargeAnim) / 6.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        switch (id) {
            case 4: {
                this.playChargeAnim = true;
                break;
            }
            case 5: {
                this.playChargeAnim = false;
                break;
            }
            default: {
                super.func_70103_a(id);
            }
        }
    }

    protected SoundEvent func_184639_G() {
        return SkiesSounds.ENTITY_DIOPHYDE_PROWLER_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SkiesSounds.ENTITY_DIOPHYDE_PROWLER_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SkiesSounds.ENTITY_DIOPHYDE_PROWLER_DEATH;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187869_gK, 0.35f, 1.0f);
    }

    protected float func_70599_aP() {
        return 1.0f;
    }

    public int func_70641_bl() {
        return 1;
    }

    class LungeAtTargetGoal
    extends Goal {
        private final DiophydeProwlerEntity attacker;
        private int chargeTime;

        public LungeAtTargetGoal() {
            this.attacker = DiophydeProwlerEntity.this;
        }

        public boolean func_75250_a() {
            return this.attacker.func_70638_az() != null;
        }

        public boolean func_75253_b() {
            return this.attacker.func_70638_az() != null && this.chargeTime > 0;
        }

        public void func_75249_e() {
            this.chargeTime = 60 + this.attacker.field_70146_Z.nextInt(40);
        }

        public void func_75246_d() {
            if (this.attacker.func_70638_az() == null) {
                return;
            }
            World world = this.attacker.field_70170_p;
            this.attacker.func_70671_ap().func_75651_a((Entity)this.attacker.func_70638_az(), 30.0f, 30.0f);
            if (this.attacker.func_70032_d((Entity)this.attacker.func_70638_az()) > 7.0f && !this.attacker.playChargeAnim) {
                this.attacker.setCharging(false);
                LivingEntity target = this.attacker.func_70638_az();
                this.attacker.func_70605_aq().func_75642_a(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), (double)1.3f);
            } else {
                if (this.chargeTime > 0) {
                    --this.chargeTime;
                }
                if (this.chargeTime > 30 && this.attacker.field_70122_E) {
                    this.attacker.func_213309_a(0.3f, new Vector3d(-0.1, 0.0, 0.5));
                } else if (this.chargeTime > 15 && this.chargeTime <= 30) {
                    this.attacker.setCharging(true);
                } else {
                    this.attacker.setCharging(false);
                }
                if (this.chargeTime == 20) {
                    Vector3d vec3d = this.attacker.func_213322_ci();
                    Vector3d vec3d1 = new Vector3d(this.attacker.func_70638_az().func_226277_ct_() - this.attacker.func_226277_ct_(), 0.0, this.attacker.func_70638_az().func_226281_cx_() - this.attacker.func_226281_cx_());
                    if (vec3d1.func_189985_c() > 1.0E-7) {
                        vec3d1 = vec3d1.func_72432_b().func_186678_a(1.5).func_178787_e(vec3d.func_186678_a(1.5));
                    }
                    this.attacker.func_213293_j(vec3d1.field_72450_a, 0.4, vec3d1.field_72449_c);
                    this.attacker.func_184185_a(SkiesSounds.ENTITY_DIOPHYDE_PROWLER_LUNGE, this.attacker.func_70599_aP(), this.attacker.func_70647_i());
                }
                int rotAmount = this.chargeTime > 20 ? 90 : 0;
                double d1 = this.attacker.func_70638_az().func_226277_ct_() - this.attacker.func_226277_ct_();
                double d2 = this.attacker.func_70638_az().func_226281_cx_() - this.attacker.func_226281_cx_();
                this.attacker.field_70177_z = -((float)MathHelper.func_181159_b((double)d1, (double)d2)) * 57.295776f - (float)rotAmount;
                if (rotAmount > 0) {
                    this.attacker.field_70761_aq = this.attacker.field_70177_z + 60.0f;
                    this.attacker.field_70759_as = this.attacker.field_70177_z + 60.0f;
                }
                List list = world.func_72839_b((Entity)this.attacker, this.attacker.func_174813_aQ());
                for (Entity entity : list) {
                    if (!(entity instanceof LivingEntity) || ((LivingEntity)entity).field_70172_ad > 0) continue;
                    LivingEntity living = (LivingEntity)entity;
                    boolean attack = this.chargeTime <= 20 && this.attacker.func_70652_k((Entity)living);
                    if (!attack) continue;
                    this.attacker.func_213317_d(Vector3d.field_186680_a);
                    return;
                }
            }
        }
    }
}

