/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.entities.hostile.FrostSpiritEntity;
import com.legacy.blue_skies.entities.util.base.SkiesMonsterEntity;
import com.legacy.blue_skies.items.tools.SkyPickaxeItem;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.registries.SkiesSounds;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.ZombifiedPiglinEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class ArmoredFrostSpiritEntity
extends SkiesMonsterEntity {
    public static final DataParameter<Integer> TYPE = EntityDataManager.func_187226_a(ArmoredFrostSpiritEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public ArmoredFrostSpiritEntity(EntityType<? extends ArmoredFrostSpiritEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.WATER_BORDER, -1.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.5, false));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[]{ZombifiedPiglinEntity.class}));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
        this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)this, TurtleEntity.class, 10, true, false, TurtleEntity.field_203029_bx));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233819_b_, 20.0).func_233815_a_(Attributes.field_233821_d_, (double)0.17f).func_233815_a_(Attributes.field_233823_f_, 3.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TYPE, (Object)0);
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficulty, reason, spawnDataIn, dataTag);
        this.determineTypeByDifficulty();
        float f = difficulty.func_180170_c();
        this.func_98053_h(this.field_70146_Z.nextFloat() < 0.55f * f);
        this.func_110148_a(Attributes.field_233820_c_).func_233769_c_(new AttributeModifier("Random spawn bonus", this.field_70146_Z.nextDouble() * (double)0.05f, AttributeModifier.Operation.ADDITION));
        if (this.getIceType() == 1) {
            this.func_110148_a(Attributes.field_233826_i_).func_233769_c_(new AttributeModifier("armor boost", 8.0, AttributeModifier.Operation.ADDITION));
        }
        if (this.field_70170_p.func_72896_J()) {
            double armorAmount = this.getIceType() == 1 ? 3.0 : 7.0;
            this.func_110148_a(Attributes.field_233826_i_).func_233769_c_(new AttributeModifier("weather armor boost", armorAmount, AttributeModifier.Operation.ADDITION));
            if (this.field_70170_p.func_175659_aa() == Difficulty.HARD) {
                this.func_110148_a(Attributes.field_233821_d_).func_233769_c_(new AttributeModifier("speed boost", 0.04, AttributeModifier.Operation.ADDITION));
                this.func_110148_a(Attributes.field_233823_f_).func_233769_c_(new AttributeModifier("attack nerf", -1.0, AttributeModifier.Operation.ADDITION));
            }
        }
        return spawnDataIn;
    }

    public void setIceType(int type) {
        this.field_70180_af.func_187227_b(TYPE, (Object)type);
    }

    public int getIceType() {
        return (Integer)this.field_70180_af.func_187225_a(TYPE);
    }

    @Override
    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        return 0.0f;
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        boolean randomBoolean = this.field_70170_p.func_72896_J() ? true : this.field_70146_Z.nextBoolean();
        return randomBoolean && super.func_213380_a(worldIn, spawnReasonIn);
    }

    public boolean func_70097_a(DamageSource ds, float amount) {
        if (ds == DamageSource.field_76370_b || ds == DamageSource.field_76372_a || ds == DamageSource.field_76369_e) {
            if ((ds == DamageSource.field_76370_b || ds == DamageSource.field_76372_a) && this.field_70737_aN <= 0) {
                this.func_184185_a(SoundEvents.field_187541_bC, 0.3f, 1.0f);
            } else {
                this.func_184185_a(SoundEvents.field_187917_gq, 0.8f, 1.0f);
            }
            if (this.field_70170_p instanceof ServerWorld) {
                ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_218422_X, this.func_226277_ct_(), this.func_226278_cu_() + (double)this.func_213302_cg() / 1.5, this.func_226281_cx_(), 20, (double)(this.func_213311_cf() / 4.0f), (double)(this.func_213302_cg() / 4.0f), (double)(this.func_213311_cf() / 4.0f), 0.05);
            }
            return super.func_70097_a(ds, amount * 2.0f);
        }
        if (ds.func_76346_g() instanceof LivingEntity && this.field_70737_aN <= 0) {
            if (this.field_70170_p instanceof ServerWorld) {
                for (int i = 0; i < 2; ++i) {
                    if (this.getIceType() == 1) {
                        this.spawnBlockParticles(Blocks.field_150403_cj.func_176223_P(), 20);
                        continue;
                    }
                    this.spawnBlockParticles(Blocks.field_150432_aD.func_176223_P(), 20);
                }
            }
            if (!this.func_174814_R()) {
                this.func_184185_a(SoundEvents.field_187561_bM, 0.5f, 1.0f);
            }
            if (ds.func_76364_f() instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)ds.func_76364_f();
                ItemStack stack = player.field_71071_by.func_70445_o();
                if (stack.func_77973_b() instanceof SkyPickaxeItem) {
                    return super.func_70097_a(ds, amount * 2.0f);
                }
            }
        }
        return super.func_70097_a(ds, amount);
    }

    protected SoundEvent func_184639_G() {
        return SkiesSounds.ENTITY_ARMORED_FROST_SPIRIT_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SkiesSounds.ENTITY_ARMORED_FROST_SPIRIT_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SkiesSounds.ENTITY_ARMORED_FROST_SPIRIT_DEATH;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        super.func_180429_a(pos, blockIn);
    }

    protected float func_70599_aP() {
        return 1.0f;
    }

    public int func_70627_aG() {
        return 120;
    }

    protected float func_70647_i() {
        return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f + 1.0f;
    }

    public void determineTypeByDifficulty() {
        switch (this.field_70170_p.func_175659_aa()) {
            case EASY: {
                this.setIceType(this.field_70146_Z.nextInt(4) == 0 ? 1 : 0);
                break;
            }
            case NORMAL: {
                this.setIceType(this.field_70146_Z.nextInt(2));
                break;
            }
            case HARD: {
                this.setIceType(this.field_70146_Z.nextInt(4) == 0 ? 0 : 1);
                break;
            }
        }
    }

    public static Item getSkyArmorByChance(EquipmentSlotType slotIn, int chance) {
        switch (slotIn) {
            case HEAD: {
                switch (chance) {
                    case 0: {
                        return Items.field_151024_Q;
                    }
                    case 1: {
                        return SkiesItems.pyrope_helmet;
                    }
                    case 2: {
                        return SkiesItems.aquite_helmet;
                    }
                    case 3: {
                        return SkiesItems.diopside_helmet;
                    }
                    case 4: {
                        return SkiesItems.charoite_helmet;
                    }
                }
                return null;
            }
            case CHEST: {
                switch (chance) {
                    case 0: {
                        return Items.field_151027_R;
                    }
                    case 1: {
                        return SkiesItems.pyrope_chestplate;
                    }
                    case 2: {
                        return SkiesItems.aquite_chestplate;
                    }
                    case 3: {
                        return SkiesItems.diopside_chestplate;
                    }
                    case 4: {
                        return SkiesItems.charoite_chestplate;
                    }
                }
                return null;
            }
            case LEGS: {
                switch (chance) {
                    case 0: {
                        return Items.field_151026_S;
                    }
                    case 1: {
                        return SkiesItems.pyrope_leggings;
                    }
                    case 2: {
                        return SkiesItems.aquite_leggings;
                    }
                    case 3: {
                        return SkiesItems.diopside_leggings;
                    }
                    case 4: {
                        return SkiesItems.charoite_leggings;
                    }
                }
                return null;
            }
            case FEET: {
                switch (chance) {
                    case 0: {
                        return Items.field_151021_T;
                    }
                    case 1: {
                        return SkiesItems.pyrope_boots;
                    }
                    case 2: {
                        return SkiesItems.aquite_boots;
                    }
                    case 3: {
                        return SkiesItems.diopside_boots;
                    }
                    case 4: {
                        return SkiesItems.charoite_boots;
                    }
                }
                return null;
            }
        }
        return null;
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        int i;
        if (this.field_70146_Z.nextFloat() < 0.15f * difficulty.func_180170_c()) {
            float f;
            i = this.field_70146_Z.nextInt(2);
            float f2 = f = this.field_70170_p.func_175659_aa() == Difficulty.HARD ? 0.1f : 0.25f;
            if (this.field_70146_Z.nextFloat() < 0.095f) {
                ++i;
            }
            if (this.field_70146_Z.nextFloat() < 0.095f) {
                ++i;
            }
            if (this.field_70146_Z.nextFloat() < 0.095f) {
                ++i;
            }
            boolean flag = true;
            for (EquipmentSlotType entityequipmentslot : EquipmentSlotType.values()) {
                Item item;
                if (entityequipmentslot.func_188453_a() != EquipmentSlotType.Group.ARMOR) continue;
                ItemStack itemstack = this.func_184582_a(entityequipmentslot);
                if (!flag && this.field_70146_Z.nextFloat() < f) break;
                flag = false;
                if (!itemstack.func_190926_b() || (item = ArmoredFrostSpiritEntity.getSkyArmorByChance(entityequipmentslot, i)) == null) continue;
                this.func_184201_a(entityequipmentslot, new ItemStack((IItemProvider)item));
            }
        }
        float f = this.field_70146_Z.nextFloat();
        float f3 = this.field_70170_p.func_175659_aa() == Difficulty.HARD ? 0.05f : 0.01f;
        if (f < f3) {
            i = this.field_70146_Z.nextInt(3);
            if (i == 0) {
                this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)SkiesItems.aquite_sword));
            } else {
                this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)SkiesItems.pyrope_sword));
            }
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("IceType", this.getIceType());
    }

    public void func_70020_e(CompoundNBT compound) {
        super.func_70020_e(compound);
        this.setIceType(compound.func_74762_e("IceType"));
    }

    public float func_213307_e(Pose pose) {
        float f = 1.74f;
        if (this.func_70631_g_()) {
            f = (float)((double)f - 0.81);
        }
        return f;
    }

    public double func_70033_W() {
        return this.func_70631_g_() ? 0.0 : -0.45;
    }

    protected void func_70619_bc() {
        if (this.field_70173_aa % 20 == 0) {
            if (this.func_203005_aq()) {
                this.func_70097_a(DamageSource.field_76369_e, 1.0f);
            } else if (this.func_70026_G() && this.field_70170_p instanceof ServerWorld) {
                ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_218422_X, this.func_226277_ct_(), this.func_226278_cu_() + (double)this.func_213302_cg() / 1.5, this.func_226281_cx_(), 20, (double)(this.func_213311_cf() / 4.0f), (double)(this.func_213302_cg() / 4.0f), (double)(this.func_213311_cf() / 4.0f), 0.05);
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            BlockPos blockpos = this.func_233580_cy_().func_177963_a(0.0, 1.5, 0.0);
            FrostSpiritEntity spirit = (FrostSpiritEntity)SkiesEntityTypes.FROST_SPIRIT.func_200721_a(this.field_70170_p);
            spirit.func_174828_a(blockpos, this.field_70177_z, this.field_70125_A);
            spirit.func_213293_j(0.0, 1.0, 0.0);
            spirit.func_174810_b(this.func_174814_R());
            spirit.func_200203_b(this.func_200201_e());
            spirit.func_174805_g(this.func_174833_aM());
            this.field_70170_p.func_217376_c((Entity)spirit);
            this.func_70656_aK();
            this.func_70106_y();
            spirit.func_184185_a(SkiesSounds.ENTITY_FROST_SPIRIT_FREE, spirit.func_70599_aP(), super.func_70647_i());
        }
    }

    public int func_70641_bl() {
        return 1;
    }

    public ResourceLocation func_184647_J() {
        if (this.getIceType() == 1) {
            return BlueSkies.locate("entities/" + this.func_200600_R().getRegistryName().func_110623_a() + "_packed");
        }
        return this.func_200600_R().func_220348_g();
    }
}

