/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.data.managers;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.BlueSkiesConfig;
import com.mojang.datafixers.util.Pair;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Logger;

public abstract class SkiesDataManager<K, V>
extends JsonReloadListener {
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final Logger LOGGER = BlueSkies.makeLogger(SkiesDataManager.class);
    protected final String name;
    protected Map<K, V> data = Maps.newHashMap();
    protected boolean hasOverrides = false;

    public SkiesDataManager(String name) {
        super(GSON, "blue_skies/" + name);
        this.name = name;
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsonMap, IResourceManager resourceManager, IProfiler profiler) {
        HashMap newDataMap = Maps.newHashMap();
        Set<Object> dataSet = new HashSet();
        if (this.hasOverrides) {
            HashSet newData = new HashSet();
            String string = "blue_skies/" + this.name;
            resourceManager.func_199003_a(string, fileName -> fileName.endsWith(".json")).forEach(fileName -> {
                try {
                    for (IResource iResource : resourceManager.func_199004_b(fileName)) {
                        ResourceLocation location = new ResourceLocation(fileName.func_110624_b(), fileName.func_110623_a().substring(folder.length() + 1, fileName.func_110623_a().length() - ".json".length()));
                        try {
                            InputStream inputStream = iResource.func_199027_b();
                            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                            JsonObject jsonObj = (JsonObject)JSONUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonObject.class);
                            if (jsonObj == null) continue;
                            newData.add(new AbstractMap.SimpleEntry<ResourceLocation, JsonObject>(location, jsonObj));
                        }
                        catch (Exception e) {
                            LOGGER.error("Failed to load {}", (Object)location.toString());
                        }
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Couldn't read {}", (Object)this.name, (Object)e);
                }
            });
            dataSet = newData;
        } else {
            dataSet = jsonMap.entrySet();
        }
        for (Map.Entry entry : dataSet) {
            ResourceLocation name = (ResourceLocation)entry.getKey();
            try {
                Pair<K, V> parsedData = this.parseJson(((JsonElement)entry.getValue()).getAsJsonObject(), name);
                this.registerData(newDataMap, parsedData.getFirst(), parsedData.getSecond());
            }
            catch (RegistryObjectNotFoundException e) {
                if (!BlueSkiesConfig.COMMON.shouldLogMissingRegistryObjectForDatapack()) continue;
                LOGGER.error((Object)e);
            }
            catch (Exception e) {
                LOGGER.error("Parsing error loading {}: {}", (Object)this.name, (Object)name, (Object)e);
            }
        }
        this.data = newDataMap;
        LOGGER.info("Loaded {} {}", (Object)newDataMap.size(), (Object)this.name);
    }

    protected abstract Pair<K, V> parseJson(JsonObject var1, ResourceLocation var2) throws RegistryObjectNotFoundException;

    protected void registerData(Map<K, V> activeData, K key, V value) {
        activeData.put(key, value);
    }

    public Map<K, V> getData() {
        return this.data;
    }

    public V getValue(K key) {
        return this.data.get(key);
    }

    @Nullable
    public static <R extends IForgeRegistryEntry<R>> R parseRegistry(JsonObject json, String key, IForgeRegistry<R> registry, @Nullable R defaultVal) throws RegistryObjectNotFoundException {
        String val = JSONUtils.func_151219_a((JsonObject)json, (String)key, null);
        if (val == null) {
            return defaultVal;
        }
        if (registry.containsKey(new ResourceLocation(val))) {
            return (R)registry.getValue(new ResourceLocation(val));
        }
        throw new RegistryObjectNotFoundException(String.format("The %s does not exist in the %s registry", val, registry.getRegistryName()));
    }

    public static <R extends IForgeRegistryEntry<R>> R parseRegistry(JsonObject json, String key, IForgeRegistry<R> registry) throws RegistryObjectNotFoundException {
        if (json.has(key)) {
            return SkiesDataManager.parseRegistry(json, key, registry, null);
        }
        throw new RegistryObjectNotFoundException(String.format("No value was stored under %s in the %s registry", key, registry.getRegistryName()));
    }

    public static Item parseItem(JsonObject json, String key) throws RegistryObjectNotFoundException {
        return (Item)SkiesDataManager.parseRegistry(json, key, ForgeRegistries.ITEMS);
    }

    public static Item parseItem(JsonObject json, String key, Item defaultVal) throws RegistryObjectNotFoundException {
        return SkiesDataManager.parseRegistry(json, key, ForgeRegistries.ITEMS, defaultVal);
    }

    public static Block parseBlock(JsonObject json, String key) throws RegistryObjectNotFoundException {
        return (Block)SkiesDataManager.parseRegistry(json, key, ForgeRegistries.BLOCKS);
    }

    public static Block parseBlock(JsonObject json, String key, Block defaultVal) throws RegistryObjectNotFoundException {
        return SkiesDataManager.parseRegistry(json, key, ForgeRegistries.BLOCKS, defaultVal);
    }

    public static EntityType<?> parseEntity(JsonObject json, String key) throws RegistryObjectNotFoundException {
        return (EntityType)SkiesDataManager.parseRegistry(json, key, ForgeRegistries.ENTITIES);
    }

    public static EntityType<?> parseEntity(JsonObject json, String key, EntityType<?> defaultVal) throws RegistryObjectNotFoundException {
        return SkiesDataManager.parseRegistry(json, key, ForgeRegistries.ENTITIES, defaultVal);
    }

    public static class RegistryObjectNotFoundException
    extends Exception {
        private static final long serialVersionUID = -3662308733522131159L;
        private final String msg;

        public RegistryObjectNotFoundException(String msg) {
            this.msg = msg;
        }

        @Override
        public String getMessage() {
            return this.msg;
        }
    }
}

