/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.particle.data;

import com.legacy.blue_skies.registries.SkiesParticles;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class PoisonData
implements IParticleData {
    public static final IParticleData.IDeserializer<PoisonData> DESERIALIZER = new IParticleData.IDeserializer<PoisonData>(){

        public PoisonData fromCommand(ParticleType<PoisonData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            boolean small = reader.readBoolean();
            return new PoisonData(small);
        }

        public PoisonData fromNetwork(ParticleType<PoisonData> particleTypeIn, PacketBuffer buffer) {
            return new PoisonData(buffer.readBoolean());
        }
    };
    public static final Codec<PoisonData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("small").forGetter(poisonData -> poisonData.isSmall())).apply((Applicative)instance, PoisonData::new));
    private final boolean small;

    public PoisonData(boolean small) {
        this.small = small;
    }

    public ParticleType<PoisonData> func_197554_b() {
        return SkiesParticles.POISON;
    }

    public void func_197553_a(PacketBuffer buffer) {
        buffer.writeBoolean(this.small);
    }

    public String func_197555_a() {
        return String.format(Locale.ROOT, "%s small=%s", ForgeRegistries.PARTICLE_TYPES.getKey(this.func_197554_b()), this.small ? "true" : "false");
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isSmall() {
        return this.small;
    }
}

