/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.particle;

import com.legacy.blue_skies.client.particle.CrusherDustParticle;
import com.legacy.blue_skies.registries.SkiesParticles;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.particles.BasicParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DustParticle
extends SpriteTexturedParticle {
    private final IAnimatedSprite spriteSet;

    protected DustParticle(ClientWorld world, double x, double y, double z, double dx, double dy, double dz, IAnimatedSprite spriteSet) {
        super(world, x, y, z, dx, dy, dz);
        this.spriteSet = spriteSet;
        this.field_187129_i *= (double)this.getBaseVelocityMultiplier();
        this.field_187130_j *= 0.1;
        this.field_187131_k *= (double)this.getBaseVelocityMultiplier();
        this.field_187126_f += (double)(this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 0.05;
        this.field_187127_g += (double)(this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 0.05;
        this.field_187128_h += (double)(this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 0.05;
        this.field_70544_f = (this.field_187136_p.nextFloat() + 0.5f) * 0.5f;
        this.func_217568_a(spriteSet);
    }

    public float getBaseVelocityMultiplier() {
        return 15.0f;
    }

    public float getTickVelocityMultiplier() {
        return 0.7f;
    }

    public void func_225606_a_(IVertexBuilder buffer, ActiveRenderInfo renderInfo, float partialTicks) {
        if (this.field_82339_as >= 0.0f) {
            super.func_225606_a_(buffer, renderInfo, partialTicks);
        }
    }

    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217603_c;
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (this.field_82339_as <= 0.0f) {
            this.func_187112_i();
        } else {
            this.func_217566_b(this.spriteSet);
            this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
            float multiplier = this.getTickVelocityMultiplier();
            this.field_187129_i *= (double)multiplier;
            this.field_187131_k *= (double)multiplier;
            this.field_187130_j *= (double)0.95f;
            if (this.field_82339_as >= 0.0f) {
                this.field_82339_as -= 0.01f;
                this.field_82339_as *= 0.96f;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite spriteSet;

        public Factory(IAnimatedSprite spriteSet) {
            this.spriteSet = spriteSet;
        }

        public DustParticle createParticle(BasicParticleType type, ClientWorld world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            if (type.getRegistryName().equals((Object)SkiesParticles.CRUSHER_DUST.getRegistryName())) {
                return new CrusherDustParticle(world, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
            }
            return new DustParticle(world, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
        }
    }
}

