/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.init;

import com.google.common.collect.ImmutableSet;
import com.legacy.blue_skies.blocks.misc.TrophyBlock;
import com.legacy.blue_skies.items.tools.AstrolabeItem;
import com.legacy.blue_skies.items.tools.weapons.InfusedArcSwordItem;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesItems;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class SkyItemModelPredicates {
    public static void init() {
        ImmutableSet spears = ImmutableSet.of((Object)SkiesItems.bluebright_spear, (Object)SkiesItems.starlit_spear, (Object)SkiesItems.frostbright_spear, (Object)SkiesItems.lunar_spear, (Object)SkiesItems.dusk_spear, (Object)SkiesItems.maple_spear, (Object[])new Item[]{SkiesItems.soulbound_spear});
        spears.forEach(spear -> SkyItemModelPredicates.createActivePredicate(spear, "throwing"));
        SkyItemModelPredicates.createActivePredicate(SkiesItems.moonstone_shield, "blocking");
        SkyItemModelPredicates.createActivePredicate(SkiesItems.spike_shield, "blocking");
        SkyItemModelPredicates.createActivePredicate(SkiesItems.venom_sac, "pulling");
        SkyItemModelPredicates.createUseDurationPredicate(SkiesItems.venom_sac, "pull", 20);
        SkyItemModelPredicates.createChargedPredicate(SkiesItems.crushing_hammer, "charged", 20);
        ImmutableSet arcs = ImmutableSet.of((Object)SkiesItems.ethereal_arc, (Object)SkiesItems.dusk_arc, (Object)SkiesItems.nature_arc, (Object)SkiesItems.poison_arc, (Object)SkiesItems.aquatic_arc, (Object)SkiesItems.life_arc, (Object[])new Item[]{SkiesItems.runic_arc});
        arcs.forEach(arc -> SkyItemModelPredicates.createCooldownPredicate(arc, "drained"));
        SkyItemModelPredicates.createInfusedArcSwordPredicate(SkiesItems.infused_arc_sword, "drained");
        SkyItemModelPredicates.createTrophyPredicate(new Block[]{SkiesBlocks.summoner_trophy, SkiesBlocks.alchemist_trophy, SkiesBlocks.starlit_crusher_trophy, SkiesBlocks.arachnarch_trophy});
        SkyItemModelPredicates.createAstrolabePredicate(SkiesItems.astrolabe, "can_use");
    }

    private static void createChargedPredicate(Item item, String predicateName, int maxUseTime) {
        ItemModelsProperties.func_239418_a_((Item)item, (ResourceLocation)new ResourceLocation(predicateName), (stack, world, entity) -> entity != null && entity.func_184607_cu() == stack && entity.func_184605_cv() <= stack.func_77988_m() - maxUseTime ? 1.0f : 0.0f);
    }

    private static void createUseDurationPredicate(Item item, String predicateName, int maxUseTime) {
        ItemModelsProperties.func_239418_a_((Item)item, (ResourceLocation)new ResourceLocation(predicateName), (stack, world, entity) -> entity != null && entity.func_184607_cu() == stack ? (float)(stack.func_77988_m() - entity.func_184605_cv()) / (float)maxUseTime : 0.0f);
    }

    private static void createActivePredicate(Item item, String predicateName) {
        ItemModelsProperties.func_239418_a_((Item)item, (ResourceLocation)new ResourceLocation(predicateName), (stack, world, entity) -> entity != null && entity.func_184587_cr() && entity.func_184607_cu() == stack ? 1.0f : 0.0f);
    }

    private static void createCooldownPredicate(Item item, String predicateName) {
        ItemModelsProperties.func_239418_a_((Item)item, (ResourceLocation)new ResourceLocation(predicateName), (stack, world, entity) -> entity != null && entity instanceof PlayerEntity && ((PlayerEntity)entity).func_184811_cZ().func_185141_a(stack.func_77973_b()) ? 1.0f : 0.0f);
    }

    private static void createInfusedArcSwordPredicate(Item item, String predicateName) {
        ItemModelsProperties.func_239418_a_((Item)item, (ResourceLocation)new ResourceLocation(predicateName), (stack, world, entity) -> stack.func_77973_b() instanceof InfusedArcSwordItem && InfusedArcSwordItem.getInfusedCooldown(stack) > 0 ? 1.0f : 0.0f);
    }

    private static void createTrophyPredicate(Block ... blocks) {
        for (Block b : blocks) {
            ItemModelsProperties.func_239418_a_((Item)b.func_199767_j(), (ResourceLocation)new ResourceLocation("tier"), (stack, world, entity) -> {
                CompoundNBT tag = stack.func_77978_p();
                if (tag != null) {
                    CompoundNBT states = tag.func_74775_l("BlockStateTag");
                    String tier = states.func_74779_i("tier");
                    return TrophyBlock.Tier.from(tier).ordinal();
                }
                return 0.0f;
            });
        }
    }

    private static void createAstrolabePredicate(Item item, String predicateName) {
        ItemModelsProperties.func_239418_a_((Item)item, (ResourceLocation)new ResourceLocation(predicateName), (stack, world, entity) -> AstrolabeItem.getTeleportCooldown(stack) == 0 && AstrolabeItem.isWithinDistance(stack, entity, (World)world) ? 1.0f : 0.0f);
    }
}

