/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.gui.toast;

import com.legacy.blue_skies.registries.SkiesItems;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.client.gui.toasts.ToastGui;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class SkiesToast
implements IToast {
    private final ResourceLocation backgroundTexture;
    private final ITextComponent desc;
    private final ITextComponent name;
    private final Item displayItem;
    private final TextFormatting defaultColor;
    private boolean hasPlayedSound;
    @Nullable
    private final SoundEvent sound;

    public SkiesToast(ITextComponent nameIn, ITextComponent description, @Nullable SoundEvent soundIn, ResourceLocation backgroundTextureIn, Item itemIn, TextFormatting defaultColorIn) {
        this.desc = description;
        this.name = nameIn;
        this.sound = soundIn;
        this.backgroundTexture = backgroundTextureIn;
        this.displayItem = itemIn;
        this.defaultColor = defaultColorIn;
    }

    public void beginDisplaying() {
        Minecraft.func_71410_x().func_193033_an().func_192988_a((IToast)this);
    }

    public IToast.Visibility func_230444_a_(MatrixStack matrix, ToastGui toast, long toastTime) {
        int color;
        toast.func_192989_b().func_110434_K().func_110577_a(this.backgroundTexture);
        toast.func_238474_b_(matrix, 0, 0, 0, 0, this.func_230445_a_(), this.func_238540_d_());
        List list = toast.func_192989_b().field_71466_p.func_238425_b_((ITextProperties)this.desc, 125);
        int n = color = this.desc.func_150256_b() != null && this.desc.func_150256_b().func_240711_a_() != null ? this.desc.func_150256_b().func_240711_a_().func_240742_a_() : this.defaultColor.func_211163_e().intValue();
        if (list.size() == 1) {
            toast.func_192989_b().field_71466_p.func_243248_b(matrix, this.name, 30.0f, 7.0f, color | 0xFF000000);
            toast.func_192989_b().field_71466_p.func_238422_b_(matrix, (IReorderingProcessor)list.get(0), 30.0f, 18.0f, -1);
        } else if (toastTime < 1500L) {
            int k = MathHelper.func_76141_d((float)(MathHelper.func_76131_a((float)((float)(1500L - toastTime) / 300.0f), (float)0.0f, (float)1.0f) * 255.0f)) << 24 | 0x4000000;
            toast.func_192989_b().field_71466_p.func_243248_b(matrix, this.name, 30.0f, 11.0f, color | k);
        } else {
            int i1 = MathHelper.func_76141_d((float)(MathHelper.func_76131_a((float)((float)(toastTime - 1500L) / 300.0f), (float)0.0f, (float)1.0f) * 252.0f)) << 24 | 0x4000000;
            int l = this.func_238540_d_() / 2 - list.size() * 9 / 2;
            for (IReorderingProcessor ireorderingprocessor : list) {
                toast.func_192989_b().field_71466_p.func_238422_b_(matrix, ireorderingprocessor, 30.0f, (float)l, 0xFFFFFF | i1);
                l += 9;
            }
        }
        if (!this.hasPlayedSound && toastTime > 0L) {
            this.hasPlayedSound = true;
            if (this.sound != null) {
                toast.func_192989_b().func_147118_V().func_147682_a((ISound)SimpleSound.func_194007_a((SoundEvent)this.sound, (float)1.0f, (float)1.0f));
            }
        }
        toast.func_192989_b().func_175599_af().func_239390_c_(new ItemStack((IItemProvider)this.displayItem), 8, 8);
        return toastTime >= 5000L ? IToast.Visibility.HIDE : IToast.Visibility.SHOW;
    }

    public static class Builder {
        private ResourceLocation backgroundTexture = IToast.field_193654_a;
        private ITextComponent desc = new StringTextComponent("");
        private ITextComponent name = new StringTextComponent("");
        private Item displayItem = SkiesItems.blue_journal;
        private SoundEvent sound = null;
        private TextFormatting defaultColor = TextFormatting.AQUA;

        public static Builder get() {
            return new Builder();
        }

        public Builder withTexture(ResourceLocation backgroundTexture) {
            this.backgroundTexture = backgroundTexture;
            return this;
        }

        public Builder withDesc(ITextComponent desc) {
            this.desc = desc;
            return this;
        }

        public Builder withTitle(ITextComponent name) {
            this.name = name;
            return this;
        }

        public Builder withDisplayItem(IItemProvider displayItem) {
            this.displayItem = displayItem.func_199767_j();
            return this;
        }

        public Builder withSound(SoundEvent sound) {
            this.sound = sound;
            return this;
        }

        public Builder withTitleColor(TextFormatting color) {
            this.defaultColor = color;
            return this;
        }

        public SkiesToast build() {
            return new SkiesToast(this.name, this.desc, this.sound, this.backgroundTexture, this.displayItem, this.defaultColor);
        }
    }
}

