/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.gui.screen.journal;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.client.gui.screen.journal.BlueJournalStartScreen;
import com.legacy.blue_skies.client.gui.screen.journal.widgets.JournalBackButton;
import com.legacy.blue_skies.client.gui.screen.journal.widgets.JournalPageButton;
import com.legacy.blue_skies.network.PacketHandler;
import com.legacy.blue_skies.network.c_to_s.OpenInventoryPacket;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class BlueJournalScreen
extends Screen {
    public static final ResourceLocation PAGE_LEFT = BlueSkies.locate("textures/gui/journal/page_left.png");
    public static final ResourceLocation PAGE_RIGHT = BlueSkies.locate("textures/gui/journal/page_right.png");
    public static final ResourceLocation WIDGETS = BlueSkies.locate("textures/gui/journal/widgets.png");
    public static final ResourceLocation DISPLAY_FRAME = BlueSkies.locate("textures/gui/journal/display_frame.png");
    private static final ITextComponent SCREEN_NAME = new TranslationTextComponent("");
    private static final int[] CODE = new int[]{265, 265, 264, 264, 263, 262, 263, 262, 66, 65};
    private int codeIndex = 0;
    private boolean showCode = false;
    private static int codeX = 0;
    private static int codeY = 0;
    private static int codeMotionX = 1;
    private static int codeMotionY = 1;
    public static BlueJournalScreen savedScreen = null;
    private static boolean openInventoryOnBackButton = false;
    protected final BlueJournalScreen previousScreen;
    protected int totalPages = 0;
    protected int page = 0;
    protected JournalBackButton backButton;
    protected JournalPageButton prevPageButton;
    protected JournalPageButton nextPageButton;

    public BlueJournalScreen(@Nullable BlueJournalScreen previousScreen) {
        super(SCREEN_NAME);
        this.previousScreen = previousScreen;
        this.codeIndex = previousScreen != null ? previousScreen.codeIndex : 0;
        this.showCode = previousScreen != null ? previousScreen.showCode : false;
    }

    protected void func_231160_c_() {
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        super.func_231160_c_();
        int middleX = this.field_230708_k_ / 2;
        int middleY = this.field_230709_l_ / 2;
        this.loadData();
        this.backButton = (JournalBackButton)this.func_230480_a_((Widget)new JournalBackButton(middleX - 30, middleY + 86, button -> this.goBack()));
        this.prevPageButton = (JournalPageButton)this.func_230480_a_((Widget)new JournalPageButton(middleX - 155, middleY + 86, false, button -> {
            if (this.page - 2 >= 0) {
                this.setPage(this.page - 2);
            }
        }));
        this.nextPageButton = (JournalPageButton)this.func_230480_a_((Widget)new JournalPageButton(middleX + 113, middleY + 86, true, button -> {
            if (this.page + 2 < this.totalPages) {
                this.setPage(this.page + 2);
            }
        }));
        this.onPageChange();
        NarratorChatListener.field_193643_a.func_193642_b();
    }

    protected void loadData() {
    }

    public boolean func_231047_b_(double mouseX, double mouseY) {
        if (this.showCode) {
            mouseX = this.offsetMouseX(mouseX);
            mouseY = this.offsetMouseY(mouseY);
        }
        return super.func_231047_b_(-mouseX, -mouseY);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int clickType) {
        if (this.showCode) {
            mouseX = this.offsetMouseX(mouseX);
            mouseY = this.offsetMouseY(mouseY);
        }
        return super.func_231044_a_(mouseX, mouseY, clickType);
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrix);
        if (this.showCode) {
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)(codeX - this.field_230708_k_ / 2 + 163), (double)(codeY - this.field_230709_l_ / 2 + 110), (double)0.0);
            mouseX = (int)this.offsetMouseX(mouseX);
            mouseY = (int)this.offsetMouseY(mouseY);
        }
        int bookHeight = 220;
        int yOffset = (this.field_230709_l_ - bookHeight) / 2;
        this.field_230706_i_.func_110434_K().func_110577_a(PAGE_LEFT);
        this.func_238474_b_(matrix, this.field_230708_k_ / 2 - 163, yOffset, 0, 0, 163, bookHeight);
        this.field_230706_i_.func_110434_K().func_110577_a(PAGE_RIGHT);
        this.func_238474_b_(matrix, this.field_230708_k_ / 2, yOffset, 0, 0, 153, bookHeight);
        this.renderExtra(matrix, mouseX, mouseY, partialTicks);
        for (Widget widget : this.field_230710_m_) {
            if (widget.func_230449_g_()) continue;
            widget.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        }
        for (Widget widget : this.field_230710_m_) {
            if (!widget.func_230449_g_()) continue;
            widget.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        }
        if (this.showCode) {
            RenderSystem.popMatrix();
        }
    }

    protected void renderExtra(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
    }

    protected void setPage(int page) {
        this.page = page;
        this.onPageChange();
    }

    protected void onPageChange() {
        this.nextPageButton.field_230694_p_ = this.page < this.totalPages - 2;
        this.prevPageButton.field_230694_p_ = this.page > 0;
    }

    public static void open(boolean openInventoryOnBackButton) {
        Minecraft.func_71410_x().func_147108_a((Screen)(savedScreen == null ? new BlueJournalStartScreen() : savedScreen));
        BlueJournalScreen.openInventoryOnBackButton = openInventoryOnBackButton;
    }

    public void func_231175_as__() {
        savedScreen = this;
        this.showCode = false;
        super.func_231175_as__();
    }

    protected void goBack() {
        ClientPlayerEntity player = this.field_230706_i_.field_71439_g;
        if (this.previousScreen == null) {
            savedScreen = null;
            if (openInventoryOnBackButton) {
                this.field_230706_i_.func_147108_a((Screen)new InventoryScreen((PlayerEntity)player));
                PacketHandler.sendToServer(new OpenInventoryPacket.Vanilla());
            } else {
                this.field_230706_i_.func_147108_a(null);
            }
        } else {
            this.field_230706_i_.func_147108_a((Screen)this.previousScreen);
            this.previousScreen.showCode = this.showCode;
        }
    }

    public boolean func_231046_a_(int key, int scancode, int modifier) {
        if (key == CODE[this.codeIndex]) {
            ++this.codeIndex;
            if (this.codeIndex >= CODE.length) {
                this.field_230706_i_.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SkiesSounds.ENTITY_FLUCTUANT_SPHERE_DISAPPEAR, (float)0.7f));
                this.showCode = !this.showCode;
                this.setCodeData();
                this.codeIndex = 0;
            }
        } else {
            this.codeIndex = 0;
        }
        switch (key) {
            case 259: {
                this.backButton.func_231044_a_(this.backButton.field_230690_l_, this.backButton.field_230691_m_, 0);
                return true;
            }
            case 263: {
                this.prevPageButton.func_231044_a_(this.prevPageButton.field_230690_l_, this.prevPageButton.field_230691_m_, 0);
                return true;
            }
            case 262: {
                this.nextPageButton.func_231044_a_(this.nextPageButton.field_230690_l_, this.nextPageButton.field_230691_m_, 0);
                return true;
            }
        }
        InputMappings.Input input = InputMappings.func_197954_a((int)key, (int)scancode);
        if (this.field_230706_i_.field_71474_y.field_151445_Q.isActiveAndMatches(input)) {
            this.func_231175_as__();
            return true;
        }
        return super.func_231046_a_(key, scancode, modifier);
    }

    public void func_231023_e_() {
        if (this.showCode) {
            if (codeX <= 0 || codeX + 316 >= this.field_230708_k_) {
                codeMotionX *= -1;
                this.field_230706_i_.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187676_dE, (float)1.0f));
            }
            if (codeY <= 0 || codeY + 220 >= this.field_230709_l_) {
                codeMotionY *= -1;
                this.field_230706_i_.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187676_dE, (float)1.0f));
            }
            if (!(codeX > 0 && codeX + 316 < this.field_230708_k_ || codeY > 0 && codeY + 220 < this.field_230709_l_)) {
                this.field_230706_i_.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187802_ec, (float)1.0f));
            }
            codeX += codeMotionX;
            codeY += codeMotionY;
        }
    }

    public void func_231152_a_(Minecraft minecraft, int newWidth, int newHeight) {
        super.func_231152_a_(minecraft, newWidth, newHeight);
        this.setCodeData();
    }

    public boolean func_231177_au__() {
        return false;
    }

    private final void setCodeData() {
        codeMotionX = Math.random() < 0.5 ? 1 : -1;
        codeMotionY = Math.random() < 0.5 ? 1 : -1;
        codeX = this.field_230708_k_ / 2 - 163;
        codeY = this.field_230709_l_ / 2 - 110;
    }

    private final double offsetMouseX(double mouseX) {
        return mouseX - (double)(codeX - this.field_230708_k_ / 2 + 163);
    }

    private final double offsetMouseY(double mouseY) {
        return mouseY - (double)(codeY - this.field_230709_l_ / 2 + 110);
    }
}

