/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.gui.container;

import com.legacy.blue_skies.data.BlueSkiesData;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesContainers;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.registries.SkiesTriggers;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AlchemyTableContainer
extends Container {
    private List<Item> outputs = new ArrayList<Item>();
    private final IntReferenceHolder selectedItem = IntReferenceHolder.func_221492_a();
    private final IInventory inputInventory = new Inventory(2){

        public void func_70296_d() {
            super.func_70296_d();
            AlchemyTableContainer.this.func_75130_a((IInventory)this);
            AlchemyTableContainer.this.inventoryUpdateListener.run();
        }
    };
    private final IInventory outputInventory = new Inventory(1);
    private final IWorldPosCallable worldPosCallable;
    private final Slot inputSlotA;
    private final Slot inputSlotB;
    private final Slot outputSlot;
    private ItemStack inputSlotAItem = ItemStack.field_190927_a;
    private ItemStack inputSlotBItem = ItemStack.field_190927_a;
    private Runnable inventoryUpdateListener = () -> {};
    private long lastOnTake;

    public AlchemyTableContainer(int id, PlayerInventory playerInv) {
        this(id, playerInv, IWorldPosCallable.field_221489_a);
    }

    public AlchemyTableContainer(int id, PlayerInventory playerInv, final IWorldPosCallable worldPos) {
        super(SkiesContainers.ALCHEMY_TABLE, id);
        this.worldPosCallable = worldPos;
        this.inputSlotA = this.func_75146_a(new Slot(this.inputInventory, 0, 20, 23));
        this.inputSlotB = this.func_75146_a(new Slot(this.inputInventory, 1, 20, 42));
        this.outputSlot = this.func_75146_a(new Slot(this.outputInventory, 0, 143, 33){

            public boolean func_75214_a(ItemStack stack) {
                return false;
            }

            public ItemStack func_190901_a(PlayerEntity player, ItemStack stack) {
                if (player instanceof ServerPlayerEntity) {
                    SkiesTriggers.USED_ALCHEMY_TABLE.trigger((ServerPlayerEntity)player, stack);
                }
                stack.func_77980_a(player.field_70170_p, player, stack.func_190916_E());
                ItemStack inputA = this.reduceStack(AlchemyTableContainer.this.inputSlotA);
                ItemStack inputB = this.reduceStack(AlchemyTableContainer.this.inputSlotB);
                if (!inputA.func_190926_b() || !inputB.func_190926_b()) {
                    AlchemyTableContainer.this.updateOutputSlot();
                }
                worldPos.func_221486_a((world, pos) -> {
                    long time = world.func_82737_E();
                    if (AlchemyTableContainer.this.lastOnTake != time) {
                        world.func_184133_a((PlayerEntity)null, pos, SkiesSounds.BLOCK_ALCHEMY_TABLE_USE, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        AlchemyTableContainer.this.lastOnTake = time;
                    }
                });
                return super.func_190901_a(player, stack);
            }

            private ItemStack reduceStack(Slot slot) {
                if (slot.func_75216_d()) {
                    ItemStack stack = slot.func_75211_c();
                    if (stack.hasContainerItem() && stack.func_190916_E() == 1) {
                        return stack.getContainerItem();
                    }
                    return slot.func_75209_a(1);
                }
                return ItemStack.field_190927_a;
            }
        });
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)playerInv, x + y * 9 + 9, 8 + x * 18, 84 + y * 18));
            }
        }
        for (int i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)playerInv, i, 8 + i * 18, 142));
        }
    }

    public void func_75134_a(PlayerEntity player) {
        super.func_75134_a(player);
        this.worldPosCallable.func_221486_a((world, pos) -> this.func_193327_a(player, (World)world, this.inputInventory));
    }

    public boolean func_75145_c(PlayerEntity player) {
        return AlchemyTableContainer.func_216963_a((IWorldPosCallable)this.worldPosCallable, (PlayerEntity)player, (Block)SkiesBlocks.alchemy_table);
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack slotStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stackInSlot = slot.func_75211_c();
            Item itemInSlot = stackInSlot.func_77973_b();
            slotStack = stackInSlot.func_77946_l();
            if (index == 2) {
                itemInSlot.func_77622_d(stackInSlot, player.field_70170_p, player);
                if (!this.func_75135_a(stackInSlot, 3, 39, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(stackInSlot, slotStack);
            } else if (index == 0 || index == 1) {
                if (!this.func_75135_a(stackInSlot, 3, 39, false)) {
                    return ItemStack.field_190927_a;
                }
            } else {
                if (!this.func_75135_a(stackInSlot, 0, 2, false)) {
                    return ItemStack.field_190927_a;
                }
                if (index >= 3 && index < 30 ? !this.func_75135_a(stackInSlot, 30, 39, false) : index >= 30 && index < 39 && !this.func_75135_a(stackInSlot, 3, 30, false)) {
                    return ItemStack.field_190927_a;
                }
            }
            if (stackInSlot.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            }
            slot.func_75218_e();
            if (stackInSlot.func_190916_E() == slotStack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, stackInSlot);
            this.func_75142_b();
        }
        return slotStack;
    }

    public boolean func_94530_a(ItemStack stack, Slot slotIn) {
        return slotIn != this.outputSlot && super.func_94530_a(stack, slotIn);
    }

    public void func_75130_a(IInventory inventory) {
        ItemStack inputA = this.inputSlotA.func_75211_c();
        ItemStack inputB = this.inputSlotB.func_75211_c();
        if (inputA.func_77973_b() != this.inputSlotAItem.func_77973_b() || inputB.func_77973_b() != this.inputSlotBItem.func_77973_b()) {
            this.inputSlotAItem = inputA.func_77946_l();
            this.inputSlotBItem = inputB.func_77946_l();
            this.updateRecipes(inventory, inputA, inputB);
        }
    }

    public boolean func_75140_a(PlayerEntity playerIn, int id) {
        if (id >= 0 && id < this.outputs.size()) {
            this.selectedItem.func_221494_a(id);
            this.updateOutputSlot();
        }
        return true;
    }

    private void updateRecipes(IInventory inventory, ItemStack inputA, ItemStack inputB) {
        this.outputs.clear();
        this.selectedItem.func_221494_a(-1);
        this.outputSlot.func_75215_d(ItemStack.field_190927_a);
        if (!inputA.func_190926_b() || !inputB.func_190926_b()) {
            List<Set> recipeOutputs = BlueSkiesData.ALCHEMY_RECIPES.getMatching(inventory.func_70301_a(0), inventory.func_70301_a(1)).stream().map(recipe -> recipe.getResults(inventory.func_70301_a(0), inventory.func_70301_a(1))).collect(Collectors.toList());
            HashSet combinedOutputs = new HashSet();
            recipeOutputs.forEach(set -> combinedOutputs.addAll(set));
            ArrayList<Item> outputList = new ArrayList<Item>(combinedOutputs);
            outputList.sort((a, b) -> a.getRegistryName().compareTo(b.getRegistryName()));
            this.outputs = outputList;
        }
    }

    private void updateOutputSlot() {
        if (!this.outputs.isEmpty() && this.selectedItem.func_221495_b() >= 0 && this.selectedItem.func_221495_b() < this.outputs.size()) {
            this.outputSlot.func_75215_d(new ItemStack((IItemProvider)this.outputs.get(this.selectedItem.func_221495_b())));
        } else {
            this.outputSlot.func_75215_d(ItemStack.field_190927_a);
        }
        this.func_75142_b();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setInventoryUpdateListener(Runnable listener) {
        this.inventoryUpdateListener = listener;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getSelectedItem() {
        return this.selectedItem.func_221495_b();
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Item> getOutputItems() {
        return this.outputs;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getOutputCount() {
        return this.outputs.size();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasItemsinInputSlot() {
        return (this.inputSlotA.func_75216_d() || this.inputSlotB.func_75216_d()) && !this.outputs.isEmpty();
    }
}

