/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.events;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.BlueSkiesConfig;
import com.legacy.blue_skies.capability.SkiesPlayer;
import com.legacy.blue_skies.capability.util.ISkiesPlayer;
import com.legacy.blue_skies.client.audio.ambient.DungeonAmbientSoundHandler;
import com.legacy.blue_skies.client.gui.screen.ArcsScreen;
import com.legacy.blue_skies.client.gui.screen.PerksScreen;
import com.legacy.blue_skies.client.gui.screen.journal.BlueJournalScreen;
import com.legacy.blue_skies.client.gui.screen.widgets.InventoryTabButton;
import com.legacy.blue_skies.client.gui.screen.widgets.SimpleInventoryTabButton;
import com.legacy.blue_skies.entities.util.SkiesDungeonType;
import com.legacy.blue_skies.entities.util.base.SkiesMountEntity;
import com.legacy.blue_skies.events.SkiesPlayerEvents;
import com.legacy.blue_skies.items.tools.weapons.SpearItem;
import com.legacy.blue_skies.items.util.IFalsiteItem;
import com.legacy.blue_skies.items.util.ToolUtils;
import com.legacy.blue_skies.network.PacketHandler;
import com.legacy.blue_skies.network.c_to_s.OpenInventoryPacket;
import com.legacy.blue_skies.registries.SkiesBiomes;
import com.legacy.blue_skies.registries.SkiesDimensions;
import com.legacy.blue_skies.util.BiomeUtil;
import com.legacy.blue_skies.world.StarrySkyRenderer;
import com.legacy.blue_skies.world.everbright.BrightWeatherRenderer;
import com.legacy.blue_skies.world.everdawn.DawnWeatherParticleRenderer;
import com.legacy.blue_skies.world.everdawn.DawnWeatherRenderer;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.BiomeSoundHandler;
import net.minecraft.client.audio.IAmbientSoundHandler;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.LocatableSound;
import net.minecraft.client.audio.TickableSound;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.CreateWorldScreen;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.CreativeScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.RenderSkyboxCube;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.client.world.DimensionRenderInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.ISkyRenderHandler;
import net.minecraftforge.client.IWeatherParticleRenderHandler;
import net.minecraftforge.client.IWeatherRenderHandler;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.versions.forge.ForgeVersion;
import org.apache.commons.lang3.tuple.Triple;

public class SkiesClientEvents {
    private static final Minecraft mc = Minecraft.func_71410_x();
    public static float sandstormStrength = 0.0f;
    public static float snowstormStrength = 0.0f;
    public static float fogDensity = 0.0f;
    public static int clientTicks;
    public static int inventoryTabCount;
    private static final BrightWeatherRenderer EVERBRIGHT_WEATHER_RENDERER;
    private static final DawnWeatherRenderer EVERDAWN_WEATHER_RENDERER;
    private static boolean inDungeon;
    private static DungeonAmbientSoundHandler dungeonAmbientSoundHandler;
    private static final ResourceLocation BLUE_SKIES_ICONS;
    public static final ResourceLocation UPDATE_LOGO;
    public static final ResourceLocation BOSSBAR_FRAMES;
    private static final DimensionRenderInfo EVERBRIGHT_RENDER_INFO;
    private static final DimensionRenderInfo EVERDAWN_RENDER_INFO;

    public static void initDimensionRenderInfo() {
        DimensionRenderInfo.field_239208_a_.put((Object)SkiesDimensions.EVERBRIGHT_ID, (Object)EVERBRIGHT_RENDER_INFO);
        DimensionRenderInfo.field_239208_a_.put((Object)SkiesDimensions.EVERDAWN_ID, (Object)EVERDAWN_RENDER_INFO);
    }

    public static void onModelBake(ModelBakeEvent event) {
    }

    @SubscribeEvent
    public static void onPlayerRender(RenderPlayerEvent.Pre event) {
        PlayerEntity player = event.getPlayer();
        if (SkiesPlayer.getIfPresent(player, ISkiesPlayer::hasFullDuskInvis, () -> false).booleanValue() && !SkiesClientEvents.mc.field_71439_g.func_175149_v()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onOpenGui(GuiOpenEvent event) {
        if (event.getGui() == null) {
            return;
        }
        if (event.getGui() instanceof MainMenuScreen) {
            SkiesPlayerEvents.spawnDimensionID = 0;
            if (BlueSkiesConfig.CLIENT.isPanoramaCustom()) {
                Panoramas.setNewPanorama();
                event.setGui((Screen)new MainMenuScreen());
            }
        }
        if ((event.getGui() instanceof InventoryScreen || event.getGui() instanceof CreativeScreen) && SkiesClientEvents.mc.field_71439_g != null && SkiesClientEvents.mc.field_71439_g.func_184187_bx() != null && SkiesClientEvents.mc.field_71439_g.func_184187_bx() instanceof SkiesMountEntity) {
            event.setCanceled(true);
            PacketHandler.sendToServer(new OpenInventoryPacket.Mount());
        }
    }

    @SubscribeEvent
    public static void openGuiEvent(GuiScreenEvent.InitGuiEvent.Post event) {
        if (BlueSkies.isIndevBuild() && event.getGui() instanceof CreateWorldScreen) {
            StringTextComponent overworld = new StringTextComponent("Spawn: Overworld");
            StringTextComponent bright = new StringTextComponent("Spawn: Everbright");
            StringTextComponent dawn = new StringTextComponent("Spawn: Everdawn");
            event.addWidget((Widget)new Button(10, 10, 98, 20, (ITextComponent)(SkiesPlayerEvents.spawnDimensionID == 1 ? bright : (SkiesPlayerEvents.spawnDimensionID == 2 ? dawn : overworld)), arg_0 -> SkiesClientEvents.lambda$openGuiEvent$1((ITextComponent)bright, (ITextComponent)dawn, (ITextComponent)overworld, arg_0)));
        }
        if (event.getGui().getClass() == InventoryScreen.class || event.getGui().getClass() == CreativeScreen.class || event.getGui().getClass() == ArcsScreen.class || event.getGui().getClass() == PerksScreen.class) {
            boolean simpleFlag = BlueSkiesConfig.CLIENT.useSimpleInventoryTabs();
            InventoryButtonFactory buttonFactory = simpleFlag ? SimpleInventoryTabButton::new : InventoryTabButton::new;
            int[] height = new int[]{0};
            int n = height[0];
            height[0] = n + 1;
            event.addWidget((Widget)buttonFactory.create(0, event.getGui(), !(event.getGui().getClass() == InventoryScreen.class ^ event.getGui().getClass() == CreativeScreen.class), n, button -> {
                ClientPlayerEntity player = SkiesClientEvents.mc.field_71439_g;
                player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                mc.func_147108_a((Screen)new InventoryScreen((PlayerEntity)player));
                PacketHandler.sendToServer(new OpenInventoryPacket.Vanilla());
            }));
            int n2 = height[0];
            height[0] = n2 + 1;
            event.addWidget((Widget)buttonFactory.create(1, event.getGui(), event.getGui().getClass() != ArcsScreen.class, n2, button -> {
                ClientPlayerEntity player = SkiesClientEvents.mc.field_71439_g;
                player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                PacketHandler.sendToServer(new OpenInventoryPacket.Arcs());
            }));
            SkiesPlayer.ifPresent(SkiesClientEvents.mc.field_71439_g, player -> {
                if (player.hasUsedBlueLore()) {
                    int n = height[0];
                    height[0] = n + 1;
                    event.addWidget((Widget)(simpleFlag ? SimpleInventoryTabButton::new : InventoryTabButton::new).createWithSound(3, event.getGui(), event.getGui().getClass() != BlueJournalScreen.class, n, button -> {
                        if (SkiesClientEvents.mc.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                            BlueJournalScreen.open(false);
                        }
                    }, SoundEvents.field_219617_ah));
                }
            });
            if (BlueSkies.SUPPORTERS.isRanked((PlayerEntity)SkiesClientEvents.mc.field_71439_g)) {
                int n3 = height[0];
                height[0] = n3 + 1;
                event.addWidget((Widget)buttonFactory.create(2, event.getGui(), event.getGui().getClass() != PerksScreen.class, n3, button -> {
                    if (SkiesClientEvents.mc.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                        mc.func_147108_a((Screen)new PerksScreen());
                    }
                }));
            }
            inventoryTabCount = height[0];
        }
    }

    @SubscribeEvent
    public static void drawScreenEvent(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (event.getGui() instanceof MainMenuScreen && BlueSkies.isIndevBuild()) {
            VersionChecker.Status status = ForgeVersion.getStatus();
            Screen gui = event.getGui();
            String text = "This is a Blue Skies indev build; it may be extremely unfinished or unplayable.";
            String subtitle = "Please make sure you know what you are doing!";
            int height = status == VersionChecker.Status.BETA || status == VersionChecker.Status.BETA_OUTDATED ? gui.field_230709_l_ - 25 : 5;
            AbstractGui.func_238472_a_((MatrixStack)event.getMatrixStack(), (FontRenderer)SkiesClientEvents.mc.field_71466_p, (ITextComponent)new TranslationTextComponent(text).func_240699_a_(TextFormatting.RED), (int)(gui.field_230708_k_ / 2), (int)height, (int)0xFFFFFF);
            AbstractGui.func_238472_a_((MatrixStack)event.getMatrixStack(), (FontRenderer)SkiesClientEvents.mc.field_71466_p, (ITextComponent)new TranslationTextComponent(subtitle).func_240701_a_(new TextFormatting[]{TextFormatting.RED, TextFormatting.BOLD, TextFormatting.UNDERLINE}), (int)(gui.field_230708_k_ / 2), (int)(height + 11), (int)0xFFFFFF);
        }
    }

    @SubscribeEvent
    public static void cancelPotionShift(GuiScreenEvent.PotionShiftEvent event) {
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onRenderToolTip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack != null) {
            List lore = event.getToolTip();
            if (stack.func_77973_b() instanceof SpearItem) {
                int index = 0;
                for (int i = 0; i < event.getToolTip().size(); ++i) {
                    if (!(lore.get(i) instanceof TranslationTextComponent) || !((TranslationTextComponent)lore.get(i)).func_150268_i().equals("item.modifiers." + EquipmentSlotType.MAINHAND.func_188450_d())) continue;
                    index = i;
                }
                lore.add(index, StringTextComponent.field_240750_d_);
                lore.add(index, new TranslationTextComponent("gui.blue_skies.item.spear.thrown_damage", new Object[]{ItemStack.field_111284_a.format(ToolUtils.getProjectileDamage(8.0f, ((SpearItem)stack.func_77973_b()).getStick()))}).func_240699_a_(TextFormatting.DARK_GREEN));
                lore.add(index, new TranslationTextComponent("gui.blue_skies.item.spear.when_thrown").func_240699_a_(TextFormatting.GRAY));
            }
            if (stack.func_77973_b() instanceof IFalsiteItem && ((IFalsiteItem)stack.func_77973_b()).isFalsiteCompatible(stack) && IFalsiteItem.hasUses(stack)) {
                lore.add(1, new TranslationTextComponent("gui.blue_skies.item.falsite_uses", new Object[]{IFalsiteItem.getFalsiteUses(stack), IFalsiteItem.getMaxFalsiteUses(stack)}).func_240699_a_(TextFormatting.GRAY));
            }
        }
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.HEALTH) {
            RenderSystem.enableBlend();
            mc.func_110434_K().func_110577_a(BLUE_SKIES_ICONS);
            float health = SkiesPlayer.getIfPresent(SkiesClientEvents.mc.field_71439_g, ISkiesPlayer::getNatureHealth, () -> Float.valueOf(0.0f)).floatValue();
            int width = mc.func_228018_at_().func_198107_o();
            int height = mc.func_228018_at_().func_198087_p();
            int i = 0;
            while ((float)i < health / 2.0f) {
                int x = width / 2 - 91 + i * 8;
                int y = height - ForgeIngameGui.left_height;
                SkiesClientEvents.mc.field_71456_v.func_238474_b_(event.getMatrixStack(), x, y, health - (float)(i * 2) <= 1.0f ? 9 : 0, 0, 9, 9);
                ++i;
            }
            if (health > 0.0f) {
                ForgeIngameGui.left_height += 10;
            }
            RenderSystem.disableBlend();
            mc.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
        }
    }

    @SubscribeEvent
    public static void onFogRender(EntityViewRenderEvent.RenderFogEvent event) {
        if (!SkiesClientEvents.mc.field_71439_g.func_208600_a((ITag)FluidTags.field_206959_a) && !SkiesClientEvents.mc.field_71439_g.func_208600_a((ITag)FluidTags.field_206960_b)) {
            if (snowstormStrength > 2.0f && 0.02f * snowstormStrength > fogDensity && SkiesClientEvents.mc.field_71441_e.func_234923_W_() == SkiesDimensions.everbrightKey()) {
                RenderSystem.fogMode((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
                RenderSystem.fogDensity((float)(2.0E-4f * snowstormStrength));
                RenderSystem.enableFog();
            }
            if (sandstormStrength > 2.0f && 0.015f * sandstormStrength > fogDensity && SkiesClientEvents.mc.field_71441_e.func_234923_W_() == SkiesDimensions.everdawnKey()) {
                RenderSystem.fogMode((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
                RenderSystem.fogDensity((float)(0.001f * sandstormStrength));
                RenderSystem.enableFog();
            }
        }
    }

    @SubscribeEvent
    public static void onSetFogDensity(EntityViewRenderEvent.FogDensity event) {
        fogDensity = event.getDensity();
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        ++clientTicks;
        ClientWorld world = SkiesClientEvents.mc.field_71441_e;
        ClientPlayerEntity player = SkiesClientEvents.mc.field_71439_g;
        if (world == null || !world.field_72995_K) {
            return;
        }
        if (player != null) {
            BlockPos blockpos;
            Entity entity;
            SkiesPlayer.ifPresent(player, skyPlayer -> {
                skyPlayer.clientTick();
                SkiesClientEvents.dungeonAmbientSoundHandler.dungeonType = skyPlayer.getDungeonMusicId();
            });
            dungeonAmbientSoundHandler.func_204253_a();
            if (SkiesDimensions.inSkyDimension((Entity)player)) {
                for (IAmbientSoundHandler handler : (List)ObfuscationReflectionHelper.getPrivateValue(ClientPlayerEntity.class, (Object)player, (String)"field_204232_cf")) {
                    if (!(handler instanceof BiomeSoundHandler)) continue;
                    BiomeSoundHandler biomeSoundHandler = (BiomeSoundHandler)handler;
                    Object2ObjectArrayMap activeBiomeSoundsMap = (Object2ObjectArrayMap)ObfuscationReflectionHelper.getPrivateValue(BiomeSoundHandler.class, (Object)biomeSoundHandler, (String)"field_239514_e_");
                    if (SkiesClientEvents.dungeonAmbientSoundHandler.dungeonType != null && SkiesClientEvents.dungeonAmbientSoundHandler.dungeonType != SkiesDungeonType.NONE || player.func_226278_cu_() + (double)player.func_70047_e() < (double)world.func_181545_F()) {
                        ((Object2ObjectArrayMap)ObfuscationReflectionHelper.getPrivateValue(BiomeSoundHandler.class, (Object)biomeSoundHandler, (String)"field_239514_e_")).values().forEach(BiomeSoundHandler.Sound::func_239526_p_);
                        activeBiomeSoundsMap.values().removeIf(TickableSound::func_147667_k);
                        activeBiomeSoundsMap.values().removeIf(sound -> sound.func_147653_e() <= 0.0f);
                        continue;
                    }
                    activeBiomeSoundsMap.values().removeIf(sound -> sound.func_147653_e() <= 0.0f);
                    activeBiomeSoundsMap.values().removeIf(TickableSound::func_147667_k);
                    Biome biome = player.field_70170_p.func_225523_d_().func_235198_a_(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
                    activeBiomeSoundsMap.values().forEach(BiomeSoundHandler.Sound::func_239526_p_);
                    biome.func_235091_u_().ifPresent(soundEvent -> {
                        BiomeSoundHandler.Sound biomesoundhandler$sound = (BiomeSoundHandler.Sound)activeBiomeSoundsMap.compute((Object)biome, (biomeIn, biomeSound) -> {
                            if (biomeSound == null) {
                                biomeSound = new BiomeSoundHandler.Sound(soundEvent);
                                ObfuscationReflectionHelper.setPrivateValue(LocatableSound.class, (Object)biomeSound, (Object)Float.valueOf(0.01f), (String)"field_147662_b");
                                mc.func_147118_V().func_147682_a((ISound)biomeSound);
                            }
                            biomeSound.func_239527_q_();
                            return biomeSound;
                        });
                    });
                }
            }
            if (world.func_234923_W_() == SkiesDimensions.everbrightKey()) {
                float maxSnowStrength;
                EVERBRIGHT_WEATHER_RENDERER.onUpdate();
                entity = mc.func_175606_aa();
                blockpos = entity.func_233580_cy_();
                float f = world.func_72911_I() && world.func_226691_t_(blockpos).func_201851_b() != Biome.RainType.NONE && world.field_73017_q > 0.0f ? 450.0f : (maxSnowStrength = !world.func_72911_I() && world.field_73004_o > 0.0f ? 200.0f : 200.0f);
                if ((inDungeon && world.func_226658_a_(LightType.SKY, blockpos) <= 0 || blockpos.func_177956_o() < world.func_181545_F()) && world.func_226658_a_(LightType.SKY, blockpos) <= 0 && snowstormStrength > 2.0f || snowstormStrength > maxSnowStrength) {
                    snowstormStrength -= 1.0f;
                } else if (world.func_226658_a_(LightType.SKY, blockpos) <= 12 && snowstormStrength > 70.0f) {
                    snowstormStrength -= 1.0f;
                } else if ((blockpos.func_177956_o() >= world.func_181545_F() || world.func_226658_a_(LightType.SKY, blockpos) > 0) && world.func_72896_J() && snowstormStrength < maxSnowStrength) {
                    snowstormStrength += 1.0f;
                } else if (snowstormStrength > 2.0f && !world.func_72896_J() && snowstormStrength <= maxSnowStrength || world.field_73004_o < 1.0f && snowstormStrength > 2.0f) {
                    snowstormStrength -= 1.0f;
                }
                SkiesPlayer.ifPresent(SkiesClientEvents.mc.field_71439_g, skyPlayer -> {
                    inDungeon = skyPlayer.getDungeonMusicId() == SkiesDungeonType.NATURE;
                });
            } else if (world.func_234923_W_() == SkiesDimensions.everdawnKey()) {
                EVERDAWN_WEATHER_RENDERER.onUpdate();
                entity = mc.func_175606_aa();
                blockpos = entity.func_233580_cy_();
                Biome biome = world.func_226691_t_(new BlockPos(blockpos.func_177958_n(), 0, blockpos.func_177952_p()));
                boolean bossOut = SkiesClientEvents.mc.field_71456_v.func_184046_j().func_184054_d();
                if (blockpos.func_177956_o() < world.func_181545_F() && world.func_226658_a_(LightType.SKY, blockpos) <= 0 && sandstormStrength > 2.0f) {
                    sandstormStrength -= 1.0f;
                } else if (bossOut && sandstormStrength > 10.0f && world.func_226658_a_(LightType.SKY, blockpos) <= 5 && blockpos.func_177956_o() >= world.func_181545_F()) {
                    sandstormStrength -= 1.0f;
                } else if (world.func_226658_a_(LightType.SKY, blockpos) <= 12 && sandstormStrength > 30.0f) {
                    sandstormStrength -= 1.0f;
                } else if (world.field_73004_o > 0.0f && SkiesBiomes.SANDSTORM_APPLICABLE.contains(BiomeUtil.getKeyFromBiome((IWorld)world, biome)) && sandstormStrength < 200.0f) {
                    sandstormStrength += 1.0f;
                } else if (sandstormStrength > 2.0f && !SkiesBiomes.SANDSTORM_APPLICABLE.contains(BiomeUtil.getKeyFromBiome((IWorld)world, biome)) && sandstormStrength <= 200.0f || world.field_73004_o < 1.0f && sandstormStrength > 2.0f) {
                    sandstormStrength -= 1.0f;
                }
            }
        }
    }

    private static /* synthetic */ void lambda$openGuiEvent$1(ITextComponent bright, ITextComponent dawn, ITextComponent overworld, Button button) {
        if (SkiesPlayerEvents.spawnDimensionID == 0) {
            button.func_238482_a_(bright);
        } else if (SkiesPlayerEvents.spawnDimensionID == 1) {
            button.func_238482_a_(dawn);
        } else {
            button.func_238482_a_(overworld);
        }
        SkiesPlayerEvents.spawnDimensionID = SkiesPlayerEvents.spawnDimensionID < 2 ? ++SkiesPlayerEvents.spawnDimensionID : 0;
    }

    static {
        inventoryTabCount = 0;
        EVERBRIGHT_WEATHER_RENDERER = BrightWeatherRenderer.INSTANCE;
        EVERDAWN_WEATHER_RENDERER = DawnWeatherRenderer.INSTANCE;
        inDungeon = false;
        dungeonAmbientSoundHandler = new DungeonAmbientSoundHandler(SkiesClientEvents.mc.field_71439_g, mc.func_147118_V());
        BLUE_SKIES_ICONS = BlueSkies.locate("textures/gui/icons.png");
        UPDATE_LOGO = BlueSkies.locate("textures/gui/update_logo.png");
        BOSSBAR_FRAMES = BlueSkies.locate("textures/gui/bossbar_frames.png");
        EVERBRIGHT_RENDER_INFO = new EverbrightRenderInfo();
        EVERDAWN_RENDER_INFO = new EverdawnRenderInfo();
    }

    public static class Panoramas {
        public static final ResourceLocation BRIGHT_BACKGROUND = BlueSkies.locate("textures/block/dirt_grass/turquoise_dirt.png");
        public static final ResourceLocation DAWN_BACKGROUND = BlueSkies.locate("textures/block/dirt_grass/lunar_dirt.png");
        public static final ResourceLocation PANORAMA_GRADIENT = BlueSkies.locate("textures/gui/panorama/panorama_overlay.png");
        public static final ResourceLocation PANORAMA_EMPTY = new ResourceLocation("textures/gui/title/background/panorama_overlay.png");
        private static Random rand = new Random();
        private static int panoramaIDs = 0;
        public static Map<Integer, Triple<ResourceLocation, ResourceLocation, ResourceLocation>> PANORAMAS = new HashMap<Integer, Triple<ResourceLocation, ResourceLocation, ResourceLocation>>();

        public static void setNewPanorama() {
            Triple<ResourceLocation, ResourceLocation, ResourceLocation> panorama = PANORAMAS.get(rand.nextInt(panoramaIDs));
            MainMenuScreen.field_213098_a = new RenderSkyboxCube((ResourceLocation)panorama.getLeft());
            MainMenuScreen.field_213099_c = (ResourceLocation)panorama.getMiddle();
            try {
                AbstractGui.field_230663_f_ = (ResourceLocation)panorama.getRight();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public static void registerPanoramas() {
            Panoramas.register("calming_skies", true, true);
            Panoramas.register("snow_covered_pines", true, true);
            Panoramas.register("brisk_meadow", true, true);
            Panoramas.register("frostbitten_forest", true, false);
            Panoramas.register("peeking_ocean", true, false, BlueSkies.locate("textures/block/misc/midnight_sand.png"));
            Panoramas.register("nature_dungeon", true, false, BlueSkies.locate("textures/block/dungeon/nature_stonebrick.png"));
            Panoramas.register("shaded_woodlands", false, false);
            Panoramas.register("crystal_roughs", false, false, BlueSkies.locate("textures/block/misc/crystal_sand.png"));
            Panoramas.register("sunset_maple_forest", false, false);
            Panoramas.register("moonlit_reservoir", false, false);
            Panoramas.register("poison_dungeon", false, false, BlueSkies.locate("textures/block/dungeon/poison_stonebrick.png"));
        }

        public static void register(String panorama, boolean everbright, boolean shouldHaveGradient) {
            ResourceLocation background = everbright ? BRIGHT_BACKGROUND : DAWN_BACKGROUND;
            Panoramas.register(panorama, everbright, shouldHaveGradient, background);
        }

        public static void register(String panorama, boolean everbright, boolean shouldHaveGradient, ResourceLocation background) {
            String prefix = everbright ? "everbright/" : "everdawn/";
            String panLoc = "textures/gui/panorama/";
            ResourceLocation gradient = shouldHaveGradient ? PANORAMA_GRADIENT : PANORAMA_EMPTY;
            PANORAMAS.put(panoramaIDs, (Triple<ResourceLocation, ResourceLocation, ResourceLocation>)Triple.of((Object)BlueSkies.locate(panLoc + prefix + panorama + "/panorama"), (Object)gradient, (Object)background));
            ++panoramaIDs;
        }
    }

    private static class EverdawnRenderInfo
    extends DimensionRenderInfo.Overworld {
        public ISkyRenderHandler getSkyRenderHandler() {
            return StarrySkyRenderer.DAWN_INSTANCE;
        }

        public IWeatherRenderHandler getWeatherRenderHandler() {
            return DawnWeatherRenderer.INSTANCE;
        }

        public IWeatherParticleRenderHandler getWeatherParticleRenderHandler() {
            return DawnWeatherParticleRenderer.INSTANCE;
        }
    }

    private static class EverbrightRenderInfo
    extends DimensionRenderInfo {
        public EverbrightRenderInfo() {
            super(178.0f, true, DimensionRenderInfo.FogType.NORMAL, false, false);
        }

        public Vector3d func_230494_a_(Vector3d p_230494_1_, float p_230494_2_) {
            return p_230494_1_.func_216372_d((double)(p_230494_2_ * 0.94f + 0.06f), (double)(p_230494_2_ * 0.94f + 0.06f), (double)(p_230494_2_ * 0.91f + 0.09f));
        }

        public boolean func_230493_a_(int p_230493_1_, int p_230493_2_) {
            return false;
        }

        public ISkyRenderHandler getSkyRenderHandler() {
            return StarrySkyRenderer.BRIGHT_INSTANCE;
        }

        public IWeatherRenderHandler getWeatherRenderHandler() {
            return BrightWeatherRenderer.INSTANCE;
        }
    }

    public static interface InventoryButtonFactorySound {
        public Button createWithSound(int var1, Screen var2, boolean var3, int var4, Button.IPressable var5, SoundEvent var6);
    }

    public static interface InventoryButtonFactory {
        public Button create(int var1, Screen var2, boolean var3, int var4, Button.IPressable var5);
    }
}

