/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.audio.ambient;

import com.legacy.blue_skies.registries.SkiesBiomes;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.util.BiomeUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.TickableSound;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkiesWeatherAmbientSounds {

    @OnlyIn(value=Dist.CLIENT)
    public static class SandstormSound
    extends TickableSound {
        private final ClientPlayerEntity player;
        private int ticksInWeather;

        public SandstormSound(ClientPlayerEntity playerIn) {
            super(SkiesSounds.AMBIENT_SANDSTORM_WIND, SoundCategory.AMBIENT);
            this.player = playerIn;
            this.field_147659_g = true;
            this.field_147665_h = 0;
            this.field_147662_b = 0.1f;
            this.field_204201_l = true;
            this.field_217862_m = true;
        }

        public void func_73660_a() {
            boolean shouldPitchLower;
            Minecraft mc = Minecraft.func_71410_x();
            BlockPos blockpos = mc.func_175606_aa().func_233580_cy_();
            boolean shouldStopPlaying = mc.field_71441_e.func_226658_a_(LightType.SKY, blockpos) <= 0;
            boolean shouldPlay = mc.field_71441_e.func_72896_J() && SkiesBiomes.SANDSTORM_APPLICABLE.contains(BiomeUtil.getKeyFromBiome((IWorld)mc.field_71441_e, mc.field_71441_e.func_226691_t_(blockpos))) && !shouldStopPlaying;
            boolean bl = shouldPitchLower = mc.field_71441_e.func_226658_a_(LightType.SKY, blockpos) <= 5 && blockpos.func_177956_o() >= mc.field_71441_e.func_181545_F() && mc.field_71456_v.func_184046_j().func_184054_d() || mc.field_71441_e.func_226658_a_(LightType.SKY, blockpos) <= 12;
            if (this.player.func_70089_S() && this.ticksInWeather >= 0) {
                this.ticksInWeather = shouldPlay ? ++this.ticksInWeather : (this.ticksInWeather -= 2);
                this.ticksInWeather = Math.min(this.ticksInWeather, 40);
                this.field_147662_b = Math.max(0.0f, Math.min((float)this.ticksInWeather / 40.0f, shouldPitchLower ? 0.8f : 1.0f));
                this.field_147663_c = shouldPitchLower ? 0.7f : 1.0f;
            } else {
                this.func_239509_o_();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class SnowWindSound
    extends TickableSound {
        private final ClientPlayerEntity player;
        private int ticksInWeather;
        private float requestedVolume = 0.8f;
        private float requestedPitch = 1.0f;

        public SnowWindSound(ClientPlayerEntity playerIn) {
            super(SkiesSounds.AMBIENT_SNOW_WIND, SoundCategory.AMBIENT);
            this.player = playerIn;
            this.field_147659_g = true;
            this.field_147665_h = 0;
            this.field_147662_b = 0.1f;
            this.field_204201_l = true;
            this.field_217862_m = true;
        }

        public void func_73660_a() {
            boolean shouldPitchLower;
            World world = this.player.field_70170_p;
            Minecraft mc = Minecraft.func_71410_x();
            BlockPos blockpos = mc.func_175606_aa().func_233580_cy_();
            boolean shouldStopPlaying = world.func_226658_a_(LightType.SKY, blockpos) <= 0;
            boolean shouldPlay = world.func_72896_J() && world.func_226691_t_(blockpos).func_201851_b() != Biome.RainType.NONE && !shouldStopPlaying;
            boolean bl = shouldPitchLower = world.func_226658_a_(LightType.SKY, blockpos) <= 5 && blockpos.func_177956_o() >= world.func_181545_F() && mc.field_71456_v.func_184046_j().func_184054_d() || world.func_226658_a_(LightType.SKY, blockpos) <= 12;
            if (this.player.func_70089_S() && this.ticksInWeather >= 0) {
                this.ticksInWeather = shouldPlay ? ++this.ticksInWeather : (this.ticksInWeather -= 2);
                this.ticksInWeather = Math.min(this.ticksInWeather, 40);
                this.field_147662_b = Math.max(0.0f, Math.min(this.field_147662_b + (this.requestedVolume > this.field_147662_b ? 0.05f : -0.05f), 0.8f));
                this.field_147663_c = Math.max(0.0f, Math.min(this.field_147663_c + (this.requestedPitch > this.field_147663_c ? 0.01f : -0.01f), 1.0f));
                this.requestedPitch = shouldPitchLower ? 0.7f : 1.0f;
                this.requestedVolume = shouldPlay ? 0.8f : 0.0f;
            } else {
                this.func_239509_o_();
            }
        }
    }
}

