/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks.natural;

import com.legacy.blue_skies.blocks.natural.SkyDirtBlock;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.GrassBlock;
import net.minecraft.block.SnowBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.FlowersFeature;
import net.minecraft.world.lighting.LightEngine;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.common.ToolType;

public class SkyGrassBlock
extends GrassBlock {
    private final GrassProperties grassProp;

    public SkyGrassBlock(GrassProperties grassProp) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151577_b).func_200944_c().func_200943_b(0.6f).func_200947_a(SoundType.field_185850_c).harvestTool(ToolType.SHOVEL));
        this.grassProp = grassProp;
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld worldIn, BlockPos pos, BlockPos facingPos) {
        Block block = worldIn.func_180495_p(pos.func_177984_a()).func_177230_c();
        return (BlockState)state.func_206870_a((Property)field_196382_a, (Comparable)Boolean.valueOf(block == Blocks.field_150433_aE || block == Blocks.field_196604_cC));
    }

    private static boolean isLightAbove(BlockState state, IWorldReader world, BlockPos pos) {
        BlockPos blockpos = pos.func_177984_a();
        BlockState blockstate = world.func_180495_p(blockpos);
        if (blockstate.func_177230_c() == Blocks.field_150433_aE && (Integer)blockstate.func_177229_b((Property)SnowBlock.field_176315_a) == 1) {
            return true;
        }
        int i = LightEngine.func_215613_a((IBlockReader)world, (BlockState)state, (BlockPos)pos, (BlockState)blockstate, (BlockPos)blockpos, (Direction)Direction.UP, (int)blockstate.func_200016_a((IBlockReader)world, blockpos));
        return i < world.func_201572_C();
    }

    private static boolean isCovered(BlockState state, IWorldReader world, BlockPos pos) {
        return SkyGrassBlock.isLightAbove(state, world, pos) && !world.func_204610_c(pos.func_177984_a()).func_206884_a((ITag)FluidTags.field_206959_a);
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (!worldIn.field_72995_K) {
            if (!worldIn.isAreaLoaded(pos, 3)) {
                return;
            }
            if (!SkyGrassBlock.isLightAbove(state, (IWorldReader)worldIn, pos)) {
                worldIn.func_175656_a(pos, this.grassProp.getDirtBlock().func_176223_P());
            } else if (worldIn.func_201696_r(pos.func_177984_a()) >= 9) {
                for (int i = 0; i < 4; ++i) {
                    BlockPos blockpos = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(5) - 3, rand.nextInt(3) - 1);
                    Block dirt = worldIn.func_180495_p(blockpos).func_177230_c();
                    if (!this.grassProp.canSpreadTo(dirt) || !SkyGrassBlock.isCovered(this.func_176223_P(), (IWorldReader)worldIn, blockpos)) continue;
                    worldIn.func_175656_a(blockpos, (BlockState)this.grassProp.getSpreadResult(dirt).func_176223_P().func_206870_a((Property)field_196382_a, (Comparable)Boolean.valueOf(worldIn.func_180495_p(blockpos.func_177984_a()).func_177230_c() == Blocks.field_150433_aE)));
                }
            }
        }
    }

    public boolean canSustainPlant(BlockState state, IBlockReader world, BlockPos pos, Direction facing, IPlantable plantable) {
        PlantType type = plantable.getPlantType(world, pos.func_177972_a(facing));
        if (type == PlantType.PLAINS) {
            return true;
        }
        if (type == PlantType.BEACH) {
            for (Direction d : SkyDirtBlock.HORIZONTAL_DIRECTIONS) {
                if (world.func_180495_p(pos.func_177972_a(d)).func_185904_a() != Material.field_151586_h) continue;
                return true;
            }
        }
        return super.canSustainPlant(state, world, pos, facing, plantable);
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        BlockPos blockpos = pos.func_177984_a();
        BlockState blockstate = this.grassProp.getGrass().func_176223_P();
        block0: for (int i = 0; i < 128; ++i) {
            BlockPos blockpos1 = blockpos;
            int j = 0;
            while (true) {
                if (j >= i / 16) {
                    BlockState blockstate1;
                    if (!worldIn.func_175623_d(blockpos1)) continue block0;
                    if (rand.nextInt(8) == 0) {
                        List list = worldIn.func_226691_t_(blockpos1).func_242440_e().func_242496_b();
                        if (list.isEmpty()) continue block0;
                        ConfiguredFeature configuredfeature = (ConfiguredFeature)list.get(0);
                        FlowersFeature flowersfeature = (FlowersFeature)configuredfeature.field_222737_a;
                        blockstate1 = flowersfeature.func_225562_b_(rand, blockpos1, configuredfeature.func_242767_c());
                    } else {
                        blockstate1 = blockstate;
                    }
                    if (!blockstate1.func_196955_c((IWorldReader)worldIn, blockpos1)) continue block0;
                    worldIn.func_180501_a(blockpos1, blockstate1, 3);
                    continue block0;
                }
                if (worldIn.func_180495_p((blockpos1 = blockpos1.func_177982_a(rand.nextInt(3) - 1, (rand.nextInt(3) - 1) * rand.nextInt(3) / 2, rand.nextInt(3) - 1)).func_177977_b()).func_177230_c() != this || SkyGrassBlock.func_208062_a((VoxelShape)worldIn.func_180495_p(blockpos1).func_196952_d((IBlockReader)worldIn, blockpos1))) continue block0;
                ++j;
            }
        }
    }

    public static class GrassProperties {
        private final Supplier<? extends Block> GRASS;
        private final Supplier<? extends Block> DIRTBLOCK;
        private final Map<Supplier<? extends Block>, Supplier<? extends Block>> SPREADMAP;

        public GrassProperties(Supplier<? extends Block> grass, Supplier<? extends Block> dirtBlock, Map<Supplier<? extends Block>, Supplier<? extends Block>> spreadMap) {
            this.GRASS = grass;
            this.DIRTBLOCK = dirtBlock;
            this.SPREADMAP = spreadMap;
        }

        public Block getGrass() {
            return this.GRASS.get();
        }

        public Block getDirtBlock() {
            return this.DIRTBLOCK.get();
        }

        public boolean canSpreadTo(Block dirt) {
            for (Supplier<? extends Block> supplier : this.SPREADMAP.keySet()) {
                if (!supplier.get().equals(dirt)) continue;
                return true;
            }
            return false;
        }

        public Block getSpreadResult(Block dirt) {
            for (Map.Entry<Supplier<? extends Block>, Supplier<? extends Block>> entry : this.SPREADMAP.entrySet()) {
                if (!entry.getKey().get().equals(dirt)) continue;
                return entry.getValue().get();
            }
            return Blocks.field_196658_i;
        }
    }
}

