/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks.natural;

import com.legacy.blue_skies.registries.SkiesItems;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.server.ServerWorld;

public class FruitBlock
extends Block {
    private static final VoxelShape SHAPE = Block.func_208617_a((double)4.0, (double)7.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private Supplier<LeavesBlock> leaves;

    public FruitBlock(Supplier<LeavesBlock> leaves) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200942_a().func_200943_b(0.0f).func_200947_a(SoundType.field_185848_a));
        this.leaves = leaves;
    }

    public LeavesBlock getLeaves() {
        return this.leaves.get();
    }

    public boolean isOvercrowded(ServerWorld world, BlockPos pos) {
        int range = 7;
        int fruitsNear = 0;
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                for (int y = -range; y <= range; ++y) {
                    if (world.func_180495_p(pos.func_177982_a(x, y, z)).func_177230_c() != this) continue;
                    ++fruitsNear;
                }
            }
        }
        return fruitsNear > 2;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        Vector3d vec3d = state.func_191059_e(world, pos);
        return SHAPE.func_197751_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
    }

    public AbstractBlock.OffsetType func_176218_Q() {
        return AbstractBlock.OffsetType.XZ;
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        return !state.func_196955_c((IWorldReader)world, currentPos) ? Blocks.field_150350_a.func_176223_P() : state;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        return world.func_180495_p(pos.func_177984_a()).func_177230_c() == this.getLeaves();
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return new ItemStack((IItemProvider)SkiesItems.crescent_fruit);
    }
}

