/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks.construction;

import com.legacy.structure_gel.util.VoxelShapeUtil;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalFaceBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;

public class WallMoonstoneBlock
extends HorizontalFaceBlock
implements IWaterLoggable {
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private static final VoxelShape FLOOR = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0);
    private static final VoxelShape CEILING = VoxelShapeUtil.mirror((VoxelShape)FLOOR, (Direction.Axis)Direction.Axis.Y);
    private static final VoxelShape NORTH = Block.func_208617_a((double)4.0, (double)4.0, (double)14.0, (double)12.0, (double)12.0, (double)16.0);
    private static final VoxelShape SOUTH = VoxelShapeUtil.rotate((VoxelShape)NORTH, (Direction)Direction.SOUTH);
    private static final VoxelShape EAST = VoxelShapeUtil.rotate((VoxelShape)NORTH, (Direction)Direction.EAST);
    private static final VoxelShape WEST = VoxelShapeUtil.rotate((VoxelShape)NORTH, (Direction)Direction.WEST);

    public WallMoonstoneBlock(AbstractBlock.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH)).func_206870_a((Property)field_196366_M, (Comparable)AttachFace.WALL)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return WallMoonstoneBlock.isValidFace(worldIn, pos, WallMoonstoneBlock.func_196365_i((BlockState)state).func_176734_d());
    }

    public static boolean isValidFace(IWorldReader worldIn, BlockPos pos, Direction direction) {
        BlockPos blockPos = pos.func_177972_a(direction);
        if (direction.func_176740_k() == Direction.Axis.Y && (BlockTags.field_219748_G.func_230235_a_((Object)worldIn.func_180495_p(blockPos).func_177230_c()) || BlockTags.field_219757_z.func_230235_a_((Object)worldIn.func_180495_p(blockPos).func_177230_c()))) {
            return true;
        }
        return worldIn.func_180495_p(blockPos).func_224755_d((IBlockReader)worldIn, blockPos, direction.func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_196366_M, field_185512_D, WATERLOGGED});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((AttachFace)state.func_177229_b((Property)field_196366_M)) {
            case WALL: {
                switch ((Direction)state.func_177229_b((Property)field_185512_D)) {
                    case NORTH: {
                        return NORTH;
                    }
                    case SOUTH: {
                        return SOUTH;
                    }
                    case EAST: {
                        return EAST;
                    }
                }
                return WEST;
            }
            case CEILING: {
                return CEILING;
            }
        }
        return FLOOR;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : Fluids.field_204541_a.func_207188_f();
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        for (Direction direction : context.func_196009_e()) {
            BlockState blockstate = direction.func_176740_k() == Direction.Axis.Y ? (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_196366_M, (Comparable)(direction == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR))).func_206870_a((Property)field_185512_D, (Comparable)context.func_195992_f()) : (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_196366_M, (Comparable)AttachFace.WALL)).func_206870_a((Property)field_185512_D, (Comparable)direction.func_176734_d());
            if (!blockstate.func_196955_c((IWorldReader)context.func_195991_k(), context.func_195995_a())) continue;
            return (BlockState)blockstate.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a));
        }
        return null;
    }
}

