/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks.construction;

import com.google.common.collect.ImmutableList;
import com.legacy.blue_skies.items.tools.AstrolabeItem;
import com.legacy.blue_skies.registries.SkiesParticles;
import com.legacy.blue_skies.registries.SkiesSounds;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.TransportationHelper;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ICollisionReader;
import net.minecraft.world.World;

public class StarEmitterBlock
extends Block {
    private static final VoxelShape SHAPE = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)4.0, (double)5.0, (double)4.0, (double)12.0, (double)13.0, (double)12.0), Block.func_208617_a((double)7.0, (double)2.0, (double)7.0, (double)9.0, (double)5.0, (double)9.0)});
    private static final ImmutableList<Vector3i> HORIZONTAL_TELEPORT_POINTS = ImmutableList.of((Object)new Vector3i(0, 0, -1), (Object)new Vector3i(-1, 0, 0), (Object)new Vector3i(0, 0, 1), (Object)new Vector3i(1, 0, 0), (Object)new Vector3i(-1, 0, -1), (Object)new Vector3i(1, 0, -1), (Object)new Vector3i(-1, 0, 1), (Object)new Vector3i(1, 0, 1));
    private static final ImmutableList<Vector3i> TELEPORT_POINTS = new ImmutableList.Builder().addAll(HORIZONTAL_TELEPORT_POINTS).addAll(HORIZONTAL_TELEPORT_POINTS.stream().map(Vector3i::func_177977_b).iterator()).addAll(HORIZONTAL_TELEPORT_POINTS.stream().map(Vector3i::func_177984_a).iterator()).add((Object)new Vector3i(0, 1, 0)).build();

    public StarEmitterBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        worldIn.func_195594_a((IParticleData)SkiesParticles.STAR_GLIMMER, (double)pos.func_177958_n() + 0.3 + rand.nextDouble() * 0.4, (double)pos.func_177956_o() + 0.4 + rand.nextDouble() * 0.4, (double)pos.func_177952_p() + 0.3 + rand.nextDouble() * 0.4, 0.0, 0.0, 0.0);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() instanceof AstrolabeItem) {
            if (world.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            world.func_184133_a((PlayerEntity)null, pos, SkiesSounds.BLOCK_STAR_EMITTER_USE, SoundCategory.PLAYERS, 1.0f, 1.0f);
            player.func_146105_b((ITextComponent)new TranslationTextComponent("gui.blue_skies.tooltip.astrolabe_pos_set"), true);
            AstrolabeItem.setTeleportPos(stack, pos);
            AstrolabeItem.setTeleportDimension(stack, (RegistryKey<World>)world.func_234923_W_());
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public static Optional<Vector3d> findTeleportPoint(EntityType<?> entity, ICollisionReader reader, BlockPos pos) {
        Optional<Vector3d> optional = StarEmitterBlock.getAvailablePoints(entity, reader, pos, true);
        return optional.isPresent() ? optional : StarEmitterBlock.getAvailablePoints(entity, reader, pos, false);
    }

    private static Optional<Vector3d> getAvailablePoints(EntityType<?> type, ICollisionReader collisionReader, BlockPos pos, boolean checkCanSpawn) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (Vector3i vector3i : TELEPORT_POINTS) {
            blockpos$mutable.func_189533_g((Vector3i)pos).func_243531_h(vector3i);
            Vector3d vector3d = TransportationHelper.func_242379_a(type, (ICollisionReader)collisionReader, (BlockPos)blockpos$mutable, (boolean)checkCanSpawn);
            if (vector3d == null) continue;
            return Optional.of(vector3d);
        }
        return Optional.empty();
    }
}

