/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.mixin;

import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import mod.beethoven92.betterendforge.common.init.ModBiomes;
import mod.beethoven92.betterendforge.common.init.ModBlocks;
import mod.beethoven92.betterendforge.common.world.generator.GeneratorOptions;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.profiler.IProfiler;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.listener.IChunkStatusListener;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.ISpecialSpawner;
import net.minecraft.world.storage.IServerWorldInfo;
import net.minecraft.world.storage.ISpawnWorldInfo;
import net.minecraft.world.storage.SaveFormat;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerWorld.class})
public abstract class ServerLevelMixin
extends World {
    private static String be_lastWorld = null;

    protected ServerLevelMixin(ISpawnWorldInfo writableLevelData, RegistryKey<World> resourceKey, DimensionType dimensionType, Supplier<IProfiler> supplier, boolean bl, boolean bl2, long l) {
        super(writableLevelData, resourceKey, dimensionType, supplier, bl, bl2, l);
    }

    @Inject(method={"<init>*"}, at={@At(value="TAIL")})
    private void be_onServerWorldInit(MinecraftServer server, Executor workerExecutor, SaveFormat.LevelSave session, IServerWorldInfo properties, RegistryKey<World> registryKey, DimensionType dimensionType, IChunkStatusListener worldGenerationProgressListener, ChunkGenerator chunkGenerator, boolean debugWorld, long l, List<ISpecialSpawner> list, boolean bl, CallbackInfo info) {
        if (be_lastWorld != null && be_lastWorld.equals(session.func_237282_a_())) {
            return;
        }
        be_lastWorld = session.func_237282_a_();
        ServerWorld world = (ServerWorld)ServerWorld.class.cast((Object)this);
        ModBiomes.onWorldLoad(world.func_72905_C(), (Registry<Biome>)world.func_241828_r().func_243612_b(Registry.field_239720_u_));
    }

    @Inject(method={"getSpawnPoint"}, at={@At(value="HEAD")}, cancellable=true)
    private void be_getSharedSpawnPos(CallbackInfoReturnable<BlockPos> info) {
        if (GeneratorOptions.changeSpawn() && ((ServerWorld)ServerWorld.class.cast((Object)this)).func_234923_W_() == World.field_234920_i_) {
            BlockPos pos = GeneratorOptions.getSpawn();
            info.setReturnValue((Object)pos);
        }
    }

    @Inject(method={"func_241121_a_"}, at={@At(value="HEAD")}, cancellable=true)
    private static void be_createObsidianPlatform(ServerWorld serverLevel, CallbackInfo info) {
        if (!GeneratorOptions.generateObsidianPlatform()) {
            info.cancel();
        } else if (GeneratorOptions.changeSpawn()) {
            BlockPos blockPos = GeneratorOptions.getSpawn();
            int i = blockPos.func_177958_n();
            int j = blockPos.func_177956_o() - 2;
            int k = blockPos.func_177952_p();
            BlockPos.func_191531_b((int)(i - 2), (int)(j + 1), (int)(k - 2), (int)(i + 2), (int)(j + 3), (int)(k + 2)).forEach(blockPosx -> serverLevel.func_175656_a(blockPosx, Blocks.field_150350_a.func_176223_P()));
            BlockPos.func_191531_b((int)(i - 2), (int)j, (int)(k - 2), (int)(i + 2), (int)j, (int)(k + 2)).forEach(blockPosx -> serverLevel.func_175656_a(blockPosx, Blocks.field_150343_Z.func_176223_P()));
            info.cancel();
        }
    }

    @ModifyArg(method={"tickEnvironment"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/server/ServerWorld;setBlockState(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;)Z"))
    private BlockState be_modifyTickState(BlockPos pos, BlockState state) {
        ResourceLocation biome;
        if (state.func_203425_a(Blocks.field_150432_aD) && (biome = ModBiomes.getBiomeID(this.func_226691_t_(pos))).func_110624_b().equals("betterendforge")) {
            state = ((Block)ModBlocks.EMERALD_ICE.get()).func_176223_P();
        }
        return state;
    }
}

