/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.config.jsons;

import javax.annotation.Nullable;
import mod.beethoven92.betterendforge.BetterEnd;
import mod.beethoven92.betterendforge.config.jsons.JsonConfigKeeper;
import mod.beethoven92.betterendforge.config.jsons.JsonConfigKey;

public abstract class JsonConfig {
    public static final String CONFIG_SYNC_PREFIX = "CONFIG_";
    protected final JsonConfigKeeper keeper;
    protected final boolean autoSync;
    public final String configID;

    protected void registerEntries() {
    }

    protected JsonConfig(String modID, String group) {
        this(modID, group, true, false);
    }

    protected JsonConfig(String modID, String group, boolean autoSync) {
        this(modID, group, autoSync, false);
    }

    public JsonConfig(String modID, String group, boolean autoSync, boolean diffContent) {
        this.configID = modID + "." + group;
        this.keeper = new JsonConfigKeeper(group);
        this.registerEntries();
        this.autoSync = autoSync;
    }

    public void saveChanges() {
        this.keeper.save();
    }

    protected static JsonConfigKey createKey(String category, String key) {
        return new JsonConfigKey(key, category.split("\\."));
    }

    protected static JsonConfigKey createKey(String key) {
        return JsonConfig.createKey("", key);
    }

    @Nullable
    public <T, E extends JsonConfigKeeper.Entry<T>> E getEntry(JsonConfigKey key, Class<E> type) {
        return this.keeper.getEntry(key, type);
    }

    @Nullable
    public <T, E extends JsonConfigKeeper.Entry<T>> T getDefault(JsonConfigKey key, Class<E> type) {
        E entry = this.keeper.getEntry(key, type);
        return entry != null ? (T)((JsonConfigKeeper.Entry)entry).getDefault() : null;
    }

    protected String getString(JsonConfigKey key, String defaultValue) {
        String str = (String)this.keeper.getValue(key, JsonConfigKeeper.StringEntry.class);
        if (str == null) {
            JsonConfigKeeper.StringEntry entry = this.keeper.registerEntry(key, new JsonConfigKeeper.StringEntry(defaultValue));
            return (String)entry.getValue();
        }
        return str != null ? str : defaultValue;
    }

    protected String getString(JsonConfigKey key) {
        String str = (String)this.keeper.getValue(key, JsonConfigKeeper.StringEntry.class);
        return str != null ? str : "";
    }

    protected boolean setString(JsonConfigKey key, String value) {
        try {
            JsonConfigKeeper.StringEntry entry = this.keeper.getEntry(key, JsonConfigKeeper.StringEntry.class);
            if (entry == null) {
                return false;
            }
            entry.setValue(value);
            return true;
        }
        catch (NullPointerException ex) {
            BetterEnd.LOGGER.catching((Throwable)ex);
            return false;
        }
    }

    public int getInt(JsonConfigKey key, int defaultValue) {
        Integer val = (Integer)this.keeper.getValue(key, JsonConfigKeeper.IntegerEntry.class);
        if (val == null) {
            JsonConfigKeeper.IntegerEntry entry = this.keeper.registerEntry(key, new JsonConfigKeeper.IntegerEntry(defaultValue));
            return (Integer)entry.getValue();
        }
        return val != null ? val : defaultValue;
    }

    public int getInt(JsonConfigKey key) {
        Integer val = (Integer)this.keeper.getValue(key, JsonConfigKeeper.IntegerEntry.class);
        return val != null ? val : 0;
    }

    public int getInt(String category, String key, int defaultValue) {
        return this.getInt(JsonConfig.createKey(category, key), defaultValue);
    }

    public int getInt(String category, String key) {
        return this.getInt(JsonConfig.createKey(category, key));
    }

    protected boolean setInt(JsonConfigKey key, int value) {
        try {
            JsonConfigKeeper.IntegerEntry entry = this.keeper.getEntry(key, JsonConfigKeeper.IntegerEntry.class);
            if (entry == null) {
                return false;
            }
            entry.setValue(value);
            return true;
        }
        catch (NullPointerException ex) {
            BetterEnd.LOGGER.catching((Throwable)ex);
            return false;
        }
    }

    protected <T extends Comparable<T>, RE extends JsonConfigKeeper.RangeEntry<T>> boolean setRanged(JsonConfigKey key, T value, Class<RE> type) {
        try {
            JsonConfigKeeper.RangeEntry entry = (JsonConfigKeeper.RangeEntry)this.keeper.getEntry(key, type);
            if (entry == null) {
                return false;
            }
            entry.setValue(value);
            return true;
        }
        catch (ClassCastException | NullPointerException ex) {
            BetterEnd.LOGGER.catching((Throwable)ex);
            return false;
        }
    }

    public float getFloat(JsonConfigKey key, float defaultValue) {
        Float val = (Float)this.keeper.getValue(key, JsonConfigKeeper.FloatEntry.class);
        if (val == null) {
            JsonConfigKeeper.FloatEntry entry = this.keeper.registerEntry(key, new JsonConfigKeeper.FloatEntry(Float.valueOf(defaultValue)));
            return ((Float)entry.getValue()).floatValue();
        }
        return val.floatValue();
    }

    public float getFloat(JsonConfigKey key) {
        Float val = (Float)this.keeper.getValue(key, JsonConfigKeeper.FloatEntry.class);
        return val != null ? val.floatValue() : 0.0f;
    }

    public float getFloat(String category, String key, float defaultValue) {
        return this.getFloat(JsonConfig.createKey(category, key), defaultValue);
    }

    public float getFloat(String category, String key) {
        return this.getFloat(JsonConfig.createKey(category, key));
    }

    public boolean setFloat(JsonConfigKey key, float value) {
        try {
            JsonConfigKeeper.FloatEntry entry = this.keeper.getEntry(key, JsonConfigKeeper.FloatEntry.class);
            if (entry == null) {
                return false;
            }
            entry.setValue(Float.valueOf(value));
            return true;
        }
        catch (NullPointerException ex) {
            BetterEnd.LOGGER.catching((Throwable)ex);
            return false;
        }
    }

    public boolean getBoolean(JsonConfigKey key, boolean defaultValue) {
        Boolean val = (Boolean)this.keeper.getValue(key, JsonConfigKeeper.BooleanEntry.class);
        if (val == null) {
            JsonConfigKeeper.BooleanEntry entry = this.keeper.registerEntry(key, new JsonConfigKeeper.BooleanEntry(defaultValue));
            return (Boolean)entry.getValue();
        }
        return val;
    }

    public boolean getBoolean(JsonConfigKey key) {
        Boolean val = (Boolean)this.keeper.getValue(key, JsonConfigKeeper.BooleanEntry.class);
        return val != null ? val : false;
    }

    public boolean getBoolean(String category, String key, boolean defaultValue) {
        return this.getBoolean(JsonConfig.createKey(category, key), defaultValue);
    }

    public boolean getBoolean(String category, String key) {
        return this.getBoolean(JsonConfig.createKey(category, key));
    }

    protected boolean setBoolean(JsonConfigKey key, boolean value) {
        try {
            JsonConfigKeeper.BooleanEntry entry = this.keeper.getEntry(key, JsonConfigKeeper.BooleanEntry.class);
            if (entry == null) {
                return false;
            }
            entry.setValue(value);
            return true;
        }
        catch (NullPointerException ex) {
            BetterEnd.LOGGER.catching((Throwable)ex);
            return false;
        }
    }
}

