/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.generator;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import mod.beethoven92.betterendforge.common.util.sdf.SDF;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFBinary;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFScale;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFSmoothUnion;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFTranslate;
import mod.beethoven92.betterendforge.common.util.sdf.primitive.SDFCappedCone;
import mod.beethoven92.betterendforge.common.util.sdf.primitive.SDFRadialNoiseMap;
import mod.beethoven92.betterendforge.common.world.generator.GeneratorOptions;
import mod.beethoven92.betterendforge.common.world.generator.LayerOptions;
import mod.beethoven92.betterendforge.common.world.generator.OpenSimplexNoise;
import net.minecraft.util.math.BlockPos;

public class IslandLayer {
    private static final Random RANDOM = new Random();
    private final SDFRadialNoiseMap noise;
    private final SDF island;
    private final List<BlockPos> positions = new ArrayList<BlockPos>(9);
    private final Map<BlockPos, SDF> islands = Maps.newHashMap();
    private final OpenSimplexNoise density;
    private final int seed;
    private int lastX = Integer.MIN_VALUE;
    private int lastZ = Integer.MIN_VALUE;
    private final LayerOptions options;

    public IslandLayer(int seed, LayerOptions options) {
        this.density = new OpenSimplexNoise(seed);
        this.options = options;
        this.seed = seed;
        SDF cone1 = IslandLayer.makeCone(0.0f, 0.4f, 0.2f, -0.3f);
        SDF cone2 = IslandLayer.makeCone(0.4f, 0.5f, 0.1f, -0.1f);
        SDF cone3 = IslandLayer.makeCone(0.5f, 0.45f, 0.03f, 0.0f);
        SDF cone4 = IslandLayer.makeCone(0.45f, 0.0f, 0.02f, 0.03f);
        SDFBinary coneBottom = new SDFSmoothUnion().setRadius(0.02f).setSourceA(cone1).setSourceB(cone2);
        SDFBinary coneTop = new SDFSmoothUnion().setRadius(0.02f).setSourceA(cone3).setSourceB(cone4);
        this.noise = (SDFRadialNoiseMap)new SDFRadialNoiseMap().setSeed(seed).setRadius(0.5f).setIntensity(0.2f).setSource(coneTop);
        this.island = new SDFSmoothUnion().setRadius(0.01f).setSourceA(this.noise).setSourceB(coneBottom);
    }

    private int getSeed(int x, int z) {
        int h = this.seed + x * 374761393 + z * 668265263;
        h = (h ^ h >> 13) * 1274126177;
        return h ^ h >> 16;
    }

    public void updatePositions(double x, double z) {
        int ix = ModMathHelper.floor(x / (double)this.options.distance);
        int iz = ModMathHelper.floor(z / (double)this.options.distance);
        if (this.lastX != ix || this.lastZ != iz) {
            this.lastX = ix;
            this.lastZ = iz;
            this.positions.clear();
            for (int pox = -1; pox < 2; ++pox) {
                int px = pox + ix;
                long px2 = px;
                for (int poz = -1; poz < 2; ++poz) {
                    int pz = poz + iz;
                    long pz2 = pz;
                    if (!GeneratorOptions.noRingVoid() && px2 * px2 + pz2 * pz2 <= this.options.centerDist) continue;
                    RANDOM.setSeed(this.getSeed(px, pz));
                    double posX = ((float)px + RANDOM.nextFloat()) * this.options.distance;
                    double posY = ModMathHelper.randRange(this.options.minY, this.options.maxY, RANDOM);
                    double posZ = ((float)pz + RANDOM.nextFloat()) * this.options.distance;
                    if (!(this.density.eval(posX * 0.01, posZ * 0.01) > 0.0)) continue;
                    this.positions.add(new BlockPos(posX, posY, posZ));
                }
            }
            if (GeneratorOptions.hasCentralIsland() && Math.abs(ix) < GeneratorOptions.getIslandDistChunk() && Math.abs(iz) < GeneratorOptions.getIslandDistChunk()) {
                int count = this.positions.size();
                for (int n = 0; n < count; ++n) {
                    BlockPos pos = this.positions.get(n);
                    long d = (long)pos.func_177958_n() * (long)pos.func_177958_n() + (long)pos.func_177952_p() * (long)pos.func_177952_p();
                    if (d >= GeneratorOptions.getIslandDistBlock()) continue;
                    this.positions.remove(n);
                    --count;
                    --n;
                }
                if (this.options.hasCentralIsland) {
                    this.positions.add(new BlockPos(0, 64, 0));
                }
            }
        }
    }

    private SDF getIsland(BlockPos pos) {
        SDF island = this.islands.get(pos);
        if (island == null) {
            if (pos.func_177958_n() == 0 && pos.func_177952_p() == 0) {
                island = new SDFScale().setScale(1.3f).setSource(this.island);
            } else {
                RANDOM.setSeed(this.getSeed(pos.func_177958_n(), pos.func_177952_p()));
                island = new SDFScale().setScale(RANDOM.nextFloat() + 0.5f).setSource(this.island);
            }
            this.islands.put(pos, island);
        }
        this.noise.setOffset(pos.func_177958_n(), pos.func_177952_p());
        return island;
    }

    private float getRelativeDistance(SDF sdf, BlockPos center, double px, double py, double pz) {
        float x = (float)(px - (double)center.func_177958_n()) / this.options.scale;
        float y = (float)(py - (double)center.func_177956_o()) / this.options.scale;
        float z = (float)(pz - (double)center.func_177952_p()) / this.options.scale;
        return sdf.getDistance(x, y, z);
    }

    private float calculateSDF(double x, double y, double z) {
        float distance = 10.0f;
        for (BlockPos pos : this.positions) {
            SDF island = this.getIsland(pos);
            float dist = this.getRelativeDistance(island, pos, x, y, z);
            distance = ModMathHelper.min(distance, dist);
        }
        return distance;
    }

    public float getDensity(double x, double y, double z) {
        return -this.calculateSDF(x, y, z);
    }

    public float getDensity(double x, double y, double z, float height) {
        this.noise.setIntensity(height);
        this.noise.setRadius(0.5f / (1.0f + height));
        return -this.calculateSDF(x, y, z);
    }

    public void clearCache() {
        if (this.islands.size() > 128) {
            this.islands.clear();
        }
    }

    private static SDF makeCone(float radiusBottom, float radiusTop, float height, float minY) {
        float hh = height * 0.5f;
        SDFCappedCone sdf = new SDFCappedCone().setHeight(hh).setRadius1(radiusBottom).setRadius2(radiusTop);
        return new SDFTranslate().setTranslate(0.0f, minY + hh, 0.0f).setSource(sdf);
    }
}

