/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.generator;

import java.util.HashMap;
import java.util.Random;
import mod.beethoven92.betterendforge.common.world.biome.BetterEndBiome;
import mod.beethoven92.betterendforge.common.world.generator.BiomeChunk;
import mod.beethoven92.betterendforge.common.world.generator.BiomePicker;
import mod.beethoven92.betterendforge.common.world.generator.OpenSimplexNoise;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;

public class BiomeMap {
    private static final SharedSeedRandom RANDOM = new SharedSeedRandom();
    private final HashMap<ChunkPos, BiomeChunk> maps = new HashMap();
    private final int size;
    private final int sizeXZ;
    private final int depth;
    private final OpenSimplexNoise noiseX;
    private final OpenSimplexNoise noiseZ;
    private final BiomePicker picker;
    private final long seed;

    public BiomeMap(long seed, int size, BiomePicker picker) {
        this.maps.clear();
        RANDOM.setSeed(seed);
        this.noiseX = new OpenSimplexNoise(RANDOM.nextLong());
        this.noiseZ = new OpenSimplexNoise(RANDOM.nextLong());
        this.sizeXZ = size;
        this.depth = (int)Math.ceil(Math.log(size) / Math.log(2.0)) - 2;
        this.size = 1 << this.depth;
        this.picker = picker;
        this.seed = seed;
    }

    public long getSeed() {
        return this.seed;
    }

    public void clearCache() {
        if (this.maps.size() > 32) {
            this.maps.clear();
        }
    }

    private BetterEndBiome getRawBiome(int bx, int bz) {
        ChunkPos cpos;
        BiomeChunk chunk;
        double x = (double)bx * (double)this.size / (double)this.sizeXZ;
        double z = (double)bz * (double)this.size / (double)this.sizeXZ;
        double nx = x;
        double nz = z;
        double px = (double)bx * 0.2;
        double pz = (double)bz * 0.2;
        for (int i = 0; i < this.depth; ++i) {
            nx = (x + this.noiseX.eval(px, pz)) / 2.0;
            nz = (z + this.noiseZ.eval(px, pz)) / 2.0;
            x = nx;
            z = nz;
            px = px / 2.0 + (double)i;
            pz = pz / 2.0 + (double)i;
        }
        bx = MathHelper.func_76128_c((double)x);
        bz = MathHelper.func_76128_c((double)z);
        if ((bx & 0xF) == 15) {
            x += (double)(bz / 2 & 1);
        }
        if ((bz & 0xF) == 15) {
            z += (double)(bx / 2 & 1);
        }
        if ((chunk = this.maps.get(cpos = new ChunkPos(MathHelper.func_76128_c((double)(x / 16.0)), MathHelper.func_76128_c((double)(z / 16.0))))) == null) {
            RANDOM.func_202422_a(cpos.field_77276_a, cpos.field_77275_b);
            chunk = new BiomeChunk(this, (Random)RANDOM, this.picker);
            this.maps.put(cpos, chunk);
        }
        return chunk.getBiome(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)z));
    }

    public BetterEndBiome getBiome(int x, int z) {
        BetterEndBiome biome = this.getRawBiome(x, z);
        if (biome.hasEdge() || biome.hasParentBiome() && biome.getParentBiome().hasEdge()) {
            int d;
            BetterEndBiome search = biome;
            if (biome.hasParentBiome()) {
                search = biome.getParentBiome();
            }
            boolean edge = !search.isSame(this.getRawBiome(x + (d = (int)Math.ceil((float)search.getEdgeSize() / 4.0f) << 2), z));
            edge = edge || !search.isSame(this.getRawBiome(x - d, z));
            edge = edge || !search.isSame(this.getRawBiome(x, z + d));
            edge = edge || !search.isSame(this.getRawBiome(x, z - d));
            edge = edge || !search.isSame(this.getRawBiome(x - 1, z - 1));
            edge = edge || !search.isSame(this.getRawBiome(x - 1, z + 1));
            edge = edge || !search.isSame(this.getRawBiome(x + 1, z - 1));
            boolean bl = edge = edge || !search.isSame(this.getRawBiome(x + 1, z + 1));
            if (edge) {
                biome = search.getEdge();
            }
        }
        return biome;
    }
}

