/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.feature.caves;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import mod.beethoven92.betterendforge.common.init.ModTags;
import mod.beethoven92.betterendforge.common.util.BlockHelper;
import mod.beethoven92.betterendforge.common.world.biome.BetterEndCaveBiome;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class CaveChunkPopulatorFeature
extends Feature<NoFeatureConfig> {
    private Supplier<BetterEndCaveBiome> supplier;

    public CaveChunkPopulatorFeature() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random random, BlockPos pos, NoFeatureConfig config) {
        HashSet floorPositions = Sets.newHashSet();
        HashSet ceilPositions = Sets.newHashSet();
        int sx = pos.func_177958_n() >> 4 << 4;
        int sz = pos.func_177952_p() >> 4 << 4;
        BlockPos.Mutable min = new BlockPos.Mutable().func_189533_g((Vector3i)pos);
        BlockPos.Mutable max = new BlockPos.Mutable().func_189533_g((Vector3i)pos);
        this.fillSets(sx, sz, world.func_217349_x(pos), floorPositions, ceilPositions, min, max);
        BetterEndCaveBiome biome = this.supplier.get();
        BlockState surfaceBlock = biome.getBiome().func_242440_e().func_242502_e().func_204108_a();
        this.placeFloor(world, biome, floorPositions, random, surfaceBlock);
        this.placeCeil(world, biome, ceilPositions, random);
        BlockHelper.fixBlocks((IWorld)world, (BlockPos)min, (BlockPos)max);
        return true;
    }

    protected void fillSets(int sx, int sz, IChunk chunk, Set<BlockPos> floorPositions, Set<BlockPos> ceilPositions, BlockPos.Mutable min, BlockPos.Mutable max) {
        BlockPos.Mutable mut = new BlockPos.Mutable();
        BlockPos.Mutable mut2 = new BlockPos.Mutable();
        BlockPos.Mutable mut3 = new BlockPos.Mutable();
        for (int x = 0; x < 16; ++x) {
            mut.func_223471_o(x);
            mut2.func_223471_o(x);
            for (int z = 0; z < 16; ++z) {
                mut.func_223472_q(z);
                mut2.func_223472_q(z);
                mut2.func_185336_p(0);
                for (int y = 1; y < chunk.func_217301_I(); ++y) {
                    mut.func_185336_p(y);
                    BlockState top = chunk.func_180495_p((BlockPos)mut);
                    BlockState bottom = chunk.func_180495_p((BlockPos)mut2);
                    if (top.func_196958_f() && (bottom.func_235714_a_(ModTags.GEN_TERRAIN) || bottom.func_203425_a(Blocks.field_150348_b))) {
                        mut3.func_189533_g((Vector3i)mut2).func_196234_d(sx, 0, sz);
                        floorPositions.add(mut3.func_185334_h());
                        this.updateMin((BlockPos)mut3, min);
                        this.updateMax((BlockPos)mut3, max);
                    } else if (bottom.func_196958_f() && (top.func_235714_a_(ModTags.GEN_TERRAIN) || top.func_203425_a(Blocks.field_150348_b))) {
                        mut3.func_189533_g((Vector3i)mut).func_196234_d(sx, 0, sz);
                        ceilPositions.add(mut3.func_185334_h());
                        this.updateMin((BlockPos)mut3, min);
                        this.updateMax((BlockPos)mut3, max);
                    }
                    mut2.func_185336_p(y);
                }
            }
        }
    }

    private void updateMin(BlockPos pos, BlockPos.Mutable min) {
        if (pos.func_177958_n() < min.func_177958_n()) {
            min.func_223471_o(pos.func_177958_n());
        }
        if (pos.func_177956_o() < min.func_177956_o()) {
            min.func_185336_p(pos.func_177956_o());
        }
        if (pos.func_177952_p() < min.func_177952_p()) {
            min.func_223472_q(pos.func_177952_p());
        }
    }

    private void updateMax(BlockPos pos, BlockPos.Mutable max) {
        if (pos.func_177958_n() > max.func_177958_n()) {
            max.func_223471_o(pos.func_177958_n());
        }
        if (pos.func_177956_o() > max.func_177956_o()) {
            max.func_185336_p(pos.func_177956_o());
        }
        if (pos.func_177952_p() > max.func_177952_p()) {
            max.func_223472_q(pos.func_177952_p());
        }
    }

    protected void placeFloor(ISeedReader world, BetterEndCaveBiome biome, Set<BlockPos> floorPositions, Random random, BlockState surfaceBlock) {
        float density = biome.getFloorDensity();
        floorPositions.forEach(pos -> {
            Feature<?> feature;
            BlockHelper.setWithoutUpdate((IWorldWriter)world, pos, surfaceBlock);
            if (density > 0.0f && random.nextFloat() <= density && (feature = biome.getFloorFeature(random)) != null) {
                feature.func_241855_a(world, null, random, pos.func_177984_a(), null);
            }
        });
    }

    protected void placeCeil(ISeedReader world, BetterEndCaveBiome biome, Set<BlockPos> ceilPositions, Random random) {
        float density = biome.getCeilDensity();
        ceilPositions.forEach(pos -> {
            Feature<?> feature;
            BlockState ceilBlock = biome.getCeil((BlockPos)pos);
            if (ceilBlock != null) {
                BlockHelper.setWithoutUpdate((IWorldWriter)world, pos, ceilBlock);
            }
            if (density > 0.0f && random.nextFloat() <= density && (feature = biome.getCeilFeature(random)) != null) {
                feature.func_241855_a(world, null, random, pos.func_177977_b(), null);
            }
        });
    }
}

