/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.feature;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Random;
import mod.beethoven92.betterendforge.common.block.BlockProperties;
import mod.beethoven92.betterendforge.common.block.SulphurCrystalBlock;
import mod.beethoven92.betterendforge.common.init.ModBlocks;
import mod.beethoven92.betterendforge.common.init.ModTags;
import mod.beethoven92.betterendforge.common.util.BlockHelper;
import mod.beethoven92.betterendforge.common.util.FeatureHelper;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import mod.beethoven92.betterendforge.common.world.generator.OpenSimplexNoise;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class SulphuricLakeFeature
extends Feature<NoFeatureConfig> {
    private static final OpenSimplexNoise NOISE = new OpenSimplexNoise(15152L);
    private static final BlockPos.Mutable POS = new BlockPos.Mutable();

    public SulphuricLakeFeature() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos blockPos, NoFeatureConfig config) {
        if ((blockPos = FeatureHelper.getPosOnSurfaceWG(world, blockPos)).func_177956_o() < 57) {
            return false;
        }
        double radius = ModMathHelper.randRange(10.0, 20.0, rand);
        int dist2 = ModMathHelper.floor(radius * 1.5);
        int minX = blockPos.func_177958_n() - dist2;
        int maxX = blockPos.func_177958_n() + dist2;
        int minZ = blockPos.func_177952_p() - dist2;
        int maxZ = blockPos.func_177952_p() + dist2;
        HashSet brimstone = Sets.newHashSet();
        for (int x = minX; x <= maxX; ++x) {
            POS.func_223471_o(x);
            int x2 = x - blockPos.func_177958_n();
            x2 *= x2;
            for (int z = minZ; z <= maxZ; ++z) {
                POS.func_223472_q(z);
                int z2 = z - blockPos.func_177952_p();
                z2 *= z2;
                double r = radius * (NOISE.eval((double)x * 0.2, (double)z * 0.2) * 0.25 + 0.75);
                double r2 = r * 1.5;
                r *= r;
                r2 *= r2;
                int dist = x2 + z2;
                if ((double)dist <= r) {
                    BlockPos offseted;
                    POS.func_185336_p(FeatureHelper.getYOnSurface(world, x, z) - 1);
                    if (!world.func_180495_p((BlockPos)POS).func_235714_a_(ModTags.GEN_TERRAIN)) continue;
                    if (this.isBorder(world, (BlockPos)POS)) {
                        if (rand.nextInt(8) > 0) {
                            brimstone.add(POS.func_185334_h());
                            if (!rand.nextBoolean()) continue;
                            brimstone.add(POS.func_177977_b());
                            if (!rand.nextBoolean()) continue;
                            brimstone.add(POS.func_177979_c(2));
                            continue;
                        }
                        if (!this.isAbsoluteBorder(world, (BlockPos)POS)) {
                            BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)POS, Blocks.field_150355_j);
                            world.func_205219_F_().func_205360_a((BlockPos)POS, (Object)Fluids.field_204546_a, 0);
                            brimstone.add(POS.func_177977_b());
                            if (!rand.nextBoolean()) continue;
                            brimstone.add(POS.func_177979_c(2));
                            if (!rand.nextBoolean()) continue;
                            brimstone.add(POS.func_177979_c(3));
                            continue;
                        }
                        brimstone.add(POS.func_185334_h());
                        if (!rand.nextBoolean()) continue;
                        brimstone.add(POS.func_177977_b());
                        continue;
                    }
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)POS, Blocks.field_150355_j);
                    brimstone.remove(POS);
                    for (Direction dir : BlockHelper.HORIZONTAL_DIRECTIONS) {
                        offseted = POS.func_177972_a(dir);
                        if (!world.func_180495_p(offseted).func_235714_a_(ModTags.GEN_TERRAIN)) continue;
                        brimstone.add(offseted);
                    }
                    if (this.isDeepWater(world, (BlockPos)POS)) {
                        BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)POS.func_189536_c(Direction.DOWN), Blocks.field_150355_j);
                        brimstone.remove(POS);
                        for (Direction dir : BlockHelper.HORIZONTAL_DIRECTIONS) {
                            offseted = POS.func_177972_a(dir);
                            if (!world.func_180495_p(offseted).func_235714_a_(ModTags.GEN_TERRAIN)) continue;
                            brimstone.add(offseted);
                        }
                    }
                    brimstone.add(POS.func_177977_b());
                    if (!rand.nextBoolean()) continue;
                    brimstone.add(POS.func_177979_c(2));
                    if (!rand.nextBoolean()) continue;
                    brimstone.add(POS.func_177979_c(3));
                    continue;
                }
                if (!((double)dist < r2)) continue;
                POS.func_185336_p(FeatureHelper.getYOnSurface(world, x, z) - 1);
                if (!world.func_180495_p((BlockPos)POS).func_235714_a_(ModTags.GEN_TERRAIN)) continue;
                brimstone.add(POS.func_185334_h());
                if (!rand.nextBoolean()) continue;
                brimstone.add(POS.func_177977_b());
                if (!rand.nextBoolean()) continue;
                brimstone.add(POS.func_177979_c(2));
            }
        }
        brimstone.forEach(bpos -> this.placeBrimstone(world, (BlockPos)bpos, rand));
        return true;
    }

    private boolean isBorder(ISeedReader world, BlockPos pos) {
        int y = pos.func_177956_o() + 1;
        for (Direction dir : BlockHelper.DIRECTIONS) {
            if (FeatureHelper.getYOnSurface(world, pos.func_177958_n() + dir.func_82601_c(), pos.func_177952_p() + dir.func_82599_e()) >= y) continue;
            return true;
        }
        return false;
    }

    private boolean isAbsoluteBorder(ISeedReader world, BlockPos pos) {
        int y = pos.func_177956_o() - 2;
        for (Direction dir : BlockHelper.DIRECTIONS) {
            if (FeatureHelper.getYOnSurface(world, pos.func_177958_n() + dir.func_82601_c() * 3, pos.func_177952_p() + dir.func_82599_e() * 3) >= y) continue;
            return true;
        }
        return false;
    }

    private boolean isDeepWater(ISeedReader world, BlockPos pos) {
        int y = pos.func_177956_o() + 1;
        for (Direction dir : BlockHelper.DIRECTIONS) {
            if (FeatureHelper.getYOnSurface(world, pos.func_177958_n() + dir.func_82601_c(), pos.func_177952_p() + dir.func_82599_e()) >= y && FeatureHelper.getYOnSurface(world, pos.func_177958_n() + dir.func_82601_c() * 2, pos.func_177952_p() + dir.func_82599_e() * 2) >= y && FeatureHelper.getYOnSurface(world, pos.func_177958_n() + dir.func_82601_c() * 3, pos.func_177952_p() + dir.func_82599_e() * 3) >= y) continue;
            return false;
        }
        return true;
    }

    private void placeBrimstone(ISeedReader world, BlockPos pos, Random random) {
        BlockState state = this.getBrimstone(world, pos);
        BlockHelper.setWithoutUpdate((IWorldWriter)world, pos, state);
        if (((Boolean)state.func_177229_b((Property)BlockProperties.ACTIVATED)).booleanValue()) {
            this.makeShards(world, pos, random);
        }
    }

    private BlockState getBrimstone(ISeedReader world, BlockPos pos) {
        for (Direction dir : BlockHelper.DIRECTIONS) {
            if (!world.func_180495_p(pos.func_177972_a(dir)).func_203425_a(Blocks.field_150355_j)) continue;
            return (BlockState)((Block)ModBlocks.BRIMSTONE.get()).func_176223_P().func_206870_a((Property)BlockProperties.ACTIVATED, (Comparable)Boolean.valueOf(true));
        }
        return ((Block)ModBlocks.BRIMSTONE.get()).func_176223_P();
    }

    private void makeShards(ISeedReader world, BlockPos pos, Random random) {
        for (Direction dir : BlockHelper.DIRECTIONS) {
            BlockPos side;
            if (random.nextInt(16) != 0 || !world.func_180495_p(side = pos.func_177972_a(dir)).func_203425_a(Blocks.field_150355_j)) continue;
            BlockState state = (BlockState)((BlockState)((BlockState)((Block)ModBlocks.SULPHUR_CRYSTAL.get()).func_176223_P().func_206870_a((Property)SulphurCrystalBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)SulphurCrystalBlock.FACING, (Comparable)dir)).func_206870_a((Property)SulphurCrystalBlock.AGE, (Comparable)Integer.valueOf(random.nextInt(3)));
            BlockHelper.setWithoutUpdate((IWorldWriter)world, side, state);
        }
    }
}

