/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.feature;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Function;
import mod.beethoven92.betterendforge.common.init.ModBiomes;
import mod.beethoven92.betterendforge.common.init.ModFeatures;
import mod.beethoven92.betterendforge.common.init.ModTags;
import mod.beethoven92.betterendforge.common.util.FeatureHelper;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import mod.beethoven92.betterendforge.common.util.sdf.SDF;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFDisplacement;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFSmoothUnion;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFTranslate;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFUnary;
import mod.beethoven92.betterendforge.common.util.sdf.primitive.SDFPrimitive;
import mod.beethoven92.betterendforge.common.util.sdf.primitive.SDFSphere;
import mod.beethoven92.betterendforge.common.world.generator.OpenSimplexNoise;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.material.Material;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class SpireFeature
extends Feature<NoFeatureConfig> {
    protected static final Function<BlockState, Boolean> REPLACE = state -> {
        if (state.func_235714_a_(ModTags.END_GROUND)) {
            return true;
        }
        if (state.func_177230_c() instanceof LeavesBlock) {
            return true;
        }
        if (state.func_185904_a().equals(Material.field_151585_k)) {
            return true;
        }
        return state.func_185904_a().func_76222_j();
    };

    public SpireFeature() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        if ((pos = FeatureHelper.getPosOnSurfaceWG(world, pos)).func_177956_o() < 10 || !world.func_180495_p(pos.func_177979_c(3)).func_235714_a_(ModTags.GEN_TERRAIN) || !world.func_180495_p(pos.func_177979_c(6)).func_235714_a_(ModTags.GEN_TERRAIN)) {
            return false;
        }
        SDF sdf = new SDFSphere().setRadius(ModMathHelper.randRange(2, 3, rand)).setBlock(Blocks.field_150377_bs);
        int count = ModMathHelper.randRange(3, 7, rand);
        for (int i = 0; i < count; ++i) {
            float rMin = (float)i * 1.3f + 2.5f;
            sdf = this.addSegment(sdf, ModMathHelper.randRange(rMin, rMin + 1.5f, rand), rand);
        }
        OpenSimplexNoise noise = new OpenSimplexNoise(rand.nextLong());
        sdf = new SDFDisplacement().setFunction(vec -> Float.valueOf((float)(Math.abs(noise.eval((double)vec.func_195899_a() * 0.1, (double)vec.func_195900_b() * 0.1, (double)vec.func_195902_c() * 0.1)) * 3.0 + Math.abs(noise.eval((double)vec.func_195899_a() * 0.3, (double)vec.func_195900_b() * 0.3 + 100.0, (double)vec.func_195902_c() * 0.3)) * (double)1.3f))).setSource(sdf);
        BlockPos center = pos;
        ArrayList support = Lists.newArrayList();
        sdf.setReplaceFunction(REPLACE).addPostProcess(info -> {
            if (info.getStateUp().func_196958_f()) {
                if (rand.nextInt(16) == 0) {
                    support.add(info.getPos().func_177984_a());
                }
                return world.func_226691_t_(info.getPos()).func_242440_e().func_242502_e().func_204108_a();
            }
            if (info.getState(Direction.UP, 3).func_196958_f()) {
                return world.func_226691_t_(info.getPos()).func_242440_e().func_242502_e().func_204109_b();
            }
            return info.getState();
        }).fillRecursive((IWorld)world, center);
        support.forEach(bpos -> {
            if (ModBiomes.getFromBiome(world.func_226691_t_(bpos)) == ModBiomes.BLOSSOMING_SPIRES) {
                ModFeatures.TENANEA_BUSH.func_241855_a(world, generator, rand, bpos, null);
            }
        });
        return true;
    }

    protected SDF addSegment(SDF sdf, float radius, Random random) {
        SDFPrimitive sphere = new SDFSphere().setRadius(radius).setBlock(Blocks.field_150377_bs);
        SDFUnary offseted = new SDFTranslate().setTranslate(0.0f, radius + random.nextFloat() * 0.25f * radius, 0.0f).setSource(sdf);
        return new SDFSmoothUnion().setRadius(radius * 0.5f).setSourceA(sphere).setSourceB(offseted);
    }
}

