/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.feature;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import mod.beethoven92.betterendforge.common.block.JellyshroomCapBlock;
import mod.beethoven92.betterendforge.common.init.ModBlocks;
import mod.beethoven92.betterendforge.common.init.ModTags;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import mod.beethoven92.betterendforge.common.util.SplineHelper;
import mod.beethoven92.betterendforge.common.util.sdf.SDF;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFFlatWave;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFScale3D;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFSmoothUnion;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFSubtraction;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFTranslate;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFUnary;
import mod.beethoven92.betterendforge.common.util.sdf.primitive.SDFSphere;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class JellyshroomFeature
extends Feature<NoFeatureConfig> {
    private static final Function<BlockState, Boolean> REPLACE;
    private static final List<Vector3f> ROOT;

    public JellyshroomFeature() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        if (!world.func_180495_p(pos.func_177977_b()).func_177230_c().func_203417_a(ModTags.END_GROUND)) {
            return false;
        }
        BlockState bark = ((Block)ModBlocks.JELLYSHROOM.bark.get()).func_176223_P();
        BlockState membrane = ((Block)ModBlocks.JELLYSHROOM_CAP_PURPLE.get()).func_176223_P();
        int height = ModMathHelper.randRange(5, 8, rand);
        float radius = (float)height * ModMathHelper.randRange(0.15f, 0.25f, rand);
        List<Vector3f> spline = SplineHelper.makeSpline(0.0f, -1.0f, 0.0f, 0.0f, height, 0.0f, 3);
        SplineHelper.offsetParts(spline, rand, 0.5f, 0.0f, 0.5f);
        SDF sdf = SplineHelper.buildSDF(spline, radius, 0.8f, bpos -> bark);
        radius = (float)height * ModMathHelper.randRange(0.7f, 0.9f, rand);
        if (radius < 1.5f) {
            radius = 1.5f;
        }
        float membraneRadius = radius;
        SDF cap = this.makeCap(membraneRadius, rand, membrane);
        Vector3f last = spline.get(spline.size() - 1);
        cap = new SDFTranslate().setTranslate(last.func_195899_a(), last.func_195900_b(), last.func_195902_c()).setSource(cap);
        sdf = new SDFSmoothUnion().setRadius(3.0f).setSourceA(sdf).setSourceB(cap);
        sdf.setReplaceFunction(REPLACE).addPostProcess(info -> {
            if (ModBlocks.JELLYSHROOM.isTreeLog(info.getState())) {
                if (ModBlocks.JELLYSHROOM.isTreeLog(info.getStateUp()) && ModBlocks.JELLYSHROOM.isTreeLog(info.getStateDown())) {
                    return ((Block)ModBlocks.JELLYSHROOM.log.get()).func_176223_P();
                }
            } else if (info.getState().func_203425_a((Block)ModBlocks.JELLYSHROOM_CAP_PURPLE.get())) {
                float dx = (float)(info.getPos().func_177958_n() - pos.func_177958_n()) - last.func_195899_a();
                float dz = (float)(info.getPos().func_177952_p() - pos.func_177952_p()) - last.func_195902_c();
                float distance = ModMathHelper.length(dx, dz) / membraneRadius * 7.0f;
                int color = MathHelper.func_76125_a((int)ModMathHelper.floor(distance), (int)0, (int)7);
                return (BlockState)info.getState().func_206870_a((Property)JellyshroomCapBlock.COLOR, (Comparable)Integer.valueOf(color));
            }
            return info.getState();
        }).fillRecursive((IWorld)world, pos);
        radius = (float)height * 0.5f;
        this.makeRoots(world, pos.func_177982_a(0, 2, 0), radius, rand, bark);
        return true;
    }

    private void makeRoots(ISeedReader world, BlockPos pos, float radius, Random random, BlockState wood) {
        int count = (int)(radius * 3.5f);
        for (int i = 0; i < count; ++i) {
            float angle = (float)i / (float)count * ((float)Math.PI * 2);
            float scale = radius * ModMathHelper.randRange(0.85f, 1.15f, random);
            List<Vector3f> branch = SplineHelper.copySpline(ROOT);
            SplineHelper.rotateSpline(branch, angle);
            SplineHelper.scale(branch, scale);
            Vector3f last = branch.get(branch.size() - 1);
            if (!world.func_180495_p(pos.func_177963_a((double)last.func_195899_a(), (double)last.func_195900_b(), (double)last.func_195902_c())).func_235714_a_(ModTags.GEN_TERRAIN)) continue;
            SplineHelper.fillSpline(branch, (IWorld)world, wood, pos, REPLACE);
        }
    }

    private SDF makeCap(float radius, Random random, BlockState cap) {
        SDF sphere = new SDFSphere().setRadius(radius).setBlock(cap);
        SDFUnary sub = new SDFTranslate().setTranslate(0.0f, -4.0f, 0.0f).setSource(sphere);
        sphere = new SDFSubtraction().setSourceA(sphere).setSourceB(sub);
        sphere = new SDFScale3D().setScale(1.0f, 0.5f, 1.0f).setSource(sphere);
        sphere = new SDFTranslate().setTranslate(0.0f, 1.0f - radius * 0.5f, 0.0f).setSource(sphere);
        float angle = random.nextFloat() * ((float)Math.PI * 2);
        int count = (int)ModMathHelper.randRange(radius * 0.5f, radius, random);
        if (count < 3) {
            count = 3;
        }
        sphere = new SDFFlatWave().setAngle(angle).setRaysCount(count).setIntensity(0.2f).setSource(sphere);
        return sphere;
    }

    static {
        ROOT = Lists.newArrayList((Object[])new Vector3f[]{new Vector3f(0.1f, 0.7f, 0.0f), new Vector3f(0.3f, 0.3f, 0.0f), new Vector3f(0.7f, 0.05f, 0.0f), new Vector3f(0.8f, -0.2f, 0.0f)});
        SplineHelper.offset(ROOT, new Vector3f(0.0f, -0.45f, 0.0f));
        REPLACE = state -> {
            if (state.func_235714_a_(ModTags.END_GROUND) || state.func_185904_a().equals(Material.field_151585_k)) {
                return true;
            }
            return state.func_185904_a().func_76222_j();
        };
    }
}

